/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.view;

import br.com.dsfnet.gpd.fx.util.ConfiguracaoSingleton;
import br.com.dsfnet.gpd.fx.view.BaseFxml;
import br.com.dsfnet.gpd.fx.view.LoginController;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.SleepUtils;
import jakarta.inject.Inject;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.application.Platform;
import javafx.beans.value.WritableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.AnchorPane;
import javafx.util.Duration;

public class SplashController
extends BaseFxml {
    @Inject
    private LoginController loginController;
    @Inject
    private ConfiguracaoSingleton configuracaoSingleton;
    @FXML
    private AnchorPane rootPane;
    @FXML
    private ProgressBar loadingBar;
    @FXML
    private Label loadingLabel;

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.loadingBar.setProgress(0.0);
        Timeline timeline = new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.loadingBar.progressProperty(), (Object)0)}), new KeyFrame(Duration.seconds((double)3.0), new KeyValue[]{new KeyValue((WritableValue)this.loadingBar.progressProperty(), (Object)1)})});
        timeline.setCycleCount(1);
        timeline.play();
        timeline.currentTimeProperty().addListener((observable, oldValue, newValue) -> {
            double progress = newValue.toSeconds() / 4.0;
            if (progress < 0.3) {
                this.loadingLabel.setText("Inicializando...");
            } else if (progress < 0.6) {
                this.loadingLabel.setText("Carregando componentes...");
            } else if (progress < 0.9) {
                this.loadingLabel.setText("Quase pronto...");
            } else {
                this.loadingLabel.setText("Conclu\u00eddo!");
            }
        });
        try {
            Thread r = new Thread(() -> {
                if (!this.configuracaoSingleton.isAmbienteDebug()) {
                    SleepUtils.pauseSeconds((int)3);
                }
                Platform.runLater(() -> this.aplicaEfeitoFadeOut(this.rootPane, this.loginController));
            });
            r.start();
        }
        catch (Exception ex) {
            LogUtils.generate((Throwable)ex);
        }
    }
}

