/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.view;

import br.com.dsfnet.gpd.client.util.PastaUtil;
import br.com.dsfnet.gpd.client.versionamento.VersionamentoEntity;
import br.com.dsfnet.gpd.fx.util.AnalisaIdeDesenvolvimento;
import br.com.dsfnet.gpd.fx.util.OrdenacaoLista;
import br.com.dsfnet.gpd.fx.util.RemoteFactory;
import br.com.dsfnet.gpd.fx.view.BaseFxml;
import br.com.dsfnet.gpd.fx.view.MensagemView;
import br.com.jarch.svn.SvnFachada;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;

public class DescarteVersionamentoController
extends BaseFxml {
    @FXML
    private ComboBox comboBoxPlanejamento;
    @FXML
    private Button buttonInicioDesenvolvimento;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.atualizaCombo();
        Platform.runLater(() -> {
            try {
                this.clearLog();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        });
    }

    @FXML
    public void buttonIniciarDesenvolvimentoAction(ActionEvent event) {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                DescarteVersionamentoController.this.desabilitaComponentes();
                VersionamentoEntity versionamentoEntity = (VersionamentoEntity)DescarteVersionamentoController.this.comboBoxPlanejamento.getSelectionModel().getSelectedItem();
                RemoteFactory.getInstance().getProcessamento().validacaoDescarteVersionamento(versionamentoEntity.getId());
                AnalisaIdeDesenvolvimento.existeAlgumaEmExecucao();
                DescarteVersionamentoController.this.startProcessLog();
                Platform.runLater(() -> DescarteVersionamentoController.this.clearLog());
                DescarteVersionamentoController.this.criaTaskAtualizacaoLabel();
                String branch = versionamentoEntity.getNumeroSol() != null ? versionamentoEntity.getNumeroSol().toString() : versionamentoEntity.getVersao();
                File pastaTrabalho = PastaUtil.getPastaTrabalho((String)DescarteVersionamentoController.this.getConfiguracaoSingleton().getLogin(), (String)versionamentoEntity.getSistemaEntity().getServidorVersionamento(), (String)branch);
                SvnFachada svnFachada = new SvnFachada(DescarteVersionamentoController.this.getConfiguracaoSingleton().getLogin(), DescarteVersionamentoController.this.getConfiguracaoSingleton().getSenha(), DescarteVersionamentoController.this.getOutputStream());
                List logDescarte = svnFachada.descarte(pastaTrabalho, DescarteVersionamentoController.this.getOutputStream());
                ArrayList log = new ArrayList(logDescarte);
                RemoteFactory.getInstance().getProcessamento().atualizacaoBancoDadosDescarteVersionamento(DescarteVersionamentoController.this.getConfiguracaoSingleton().getLogin(), versionamentoEntity.getId());
                Platform.runLater(() -> DescarteVersionamentoController.this.updateLogWebView(log.stream().collect(Collectors.joining("\n"))));
                return null;
            }

            protected void failed() {
                Platform.runLater(() -> {
                    DescarteVersionamentoController.this.endProcessLog();
                    MensagemView.getInstancia().mostraErro(DescarteVersionamentoController.this.anchorPane, this.getException().getMessage());
                    DescarteVersionamentoController.this.habilitaComponentes();
                });
            }

            protected void succeeded() {
                Platform.runLater(() -> {
                    DescarteVersionamentoController.this.endProcessLog();
                    MensagemView.getInstancia().mostraSucesso(DescarteVersionamentoController.this.anchorPane, "Processamento Conclu\u00eddo com Sucesso");
                    DescarteVersionamentoController.this.habilitaComponentes();
                    DescarteVersionamentoController.this.atualizaCombo();
                });
            }
        };
        new Thread((Runnable)task).start();
    }

    private void desabilitaComponentes() {
        this.habilitaDesabilitaComponente(true);
    }

    private void habilitaComponentes() {
        this.habilitaDesabilitaComponente(false);
    }

    private void habilitaDesabilitaComponente(boolean disable) {
        Platform.runLater(() -> {
            this.comboBoxPlanejamento.setDisable(disable);
            this.buttonInicioDesenvolvimento.setDisable(disable);
        });
    }

    private void atualizaCombo() {
        this.comboBoxPlanejamento.getItems().clear();
        this.comboBoxPlanejamento.getItems().addAll((Collection)RemoteFactory.getInstance().getProcessamento().carregaListaDescarteVersionamento().stream().sorted(OrdenacaoLista.versionamentoComparator).collect(Collectors.toList()));
        this.comboBoxPlanejamento.getSelectionModel().select(-1);
    }
}

