/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.util;

import br.com.dsfnet.gpd.client.ejb.ProcessamentoEjb;
import br.com.dsfnet.gpd.client.ejb.ProcessamentoRemote;
import br.com.dsfnet.gpd.fx.util.ConfiguracaoSingleton;
import br.com.jarch.core.exception.ValidationException;
import br.com.jarch.util.LogUtils;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

@Singleton
public class RemoteFactory {
    public static final String INITIAL_CONTEXT_FACTORY = "org.wildfly.naming.client.WildFlyInitialContextFactory";
    public static final String PROVIDER_URL_WILDFLY = "http-remoting://%s:8080";
    public static final String USER = "userejb";
    public static final String SENHA = "D$f@123!";
    @Inject
    private ConfiguracaoSingleton configuracaoSingleton;
    public final String PREFIXO_LOOKUP = "ejb:/gpd-web/";
    private Context context;

    public static RemoteFactory getInstance() {
        return (RemoteFactory)CDI.current().select(RemoteFactory.class, new Annotation[0]).get();
    }

    public ProcessamentoRemote getProcessamento() {
        return this.get(ProcessamentoRemote.class, ProcessamentoEjb.class);
    }

    private <I, T> I get(Class<I> remoteInterface, Class<T> remoteClass) {
        String nomeLookup = "ejb:/gpd-web/" + remoteClass.getSimpleName() + "!" + remoteInterface.getName();
        try {
            if (this.context != null) {
                this.context.close();
            }
            this.context = this.criaContextWildfly();
            LogUtils.generate((String)("====================== LOOKUP EJB REMOTE " + nomeLookup));
            Object instance = this.context.lookup(nomeLookup);
            return (I)instance;
        }
        catch (NamingException ex) {
            throw new ValidationException((Throwable)ex);
        }
    }

    private Context criaContextWildfly() throws NamingException {
        String providerUrl = String.format(PROVIDER_URL_WILDFLY, this.configuracaoSingleton.getServidorGpd());
        LogUtils.generate((String)("######################## EJB REMOTE: " + providerUrl));
        Properties env = new Properties();
        env.put("java.naming.factory.initial", INITIAL_CONTEXT_FACTORY);
        env.put("java.naming.provider.url", providerUrl);
        env.put("java.naming.security.principal", USER);
        env.put("java.naming.security.credentials", SENHA);
        InitialContext context = new InitialContext(env);
        return context;
    }
}

