/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.sistema;

import br.com.dsfnet.gpd.client.exception.VersionamentoException;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity_;
import br.com.dsfnet.gpd.client.sistema.SistemaRepository;
import br.com.dsfnet.gpd.client.type.TecnologiaType;
import br.com.jarch.core.annotation.JArchJpaRepository;
import br.com.jarch.core.crud.jparepository.CrudJpaRepository;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.metamodel.Attribute;
import jakarta.transaction.Transactional;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

@JArchJpaRepository
public class SistemaJpaRepository
extends CrudJpaRepository<SistemaEntity>
implements SistemaRepository {
    @Override
    public List<String> listaCliente() {
        return this.searchAll().stream().map(SistemaEntity::getCliente).distinct().sorted().collect(Collectors.toList());
    }

    @Override
    public List<String> listaSistema() {
        return this.searchAll().stream().map(SistemaEntity::getSistema).distinct().sorted().collect(Collectors.toList());
    }

    @Override
    public Collection<SistemaEntity> ativos() {
        return this.searchAllBy((Attribute)SistemaEntity_.ativo, true);
    }

    @Override
    public List<String> listaSistema(String cliente) {
        return this.searchAllBy("cliente", cliente).stream().map(SistemaEntity::getSistema).distinct().sorted().collect(Collectors.toList());
    }

    @Override
    public SistemaEntity pesquisar(String cliente, String produto, TecnologiaType tecnologia) {
        try {
            Query query = this.getEntityManager().createQuery("SELECT v FROM SistemaEntity v WHERE v.cliente = :cliente AND       v.sistema = :produto AND       v.tecnologia = :tecnologia");
            query.setParameter("cliente", (Object)cliente);
            query.setParameter("produto", (Object)produto);
            query.setParameter("tecnologia", (Object)tecnologia);
            return (SistemaEntity)query.getSingleResult();
        }
        catch (NoResultException ex) {
            throw new NoResultException("N\u00e3o foi poss\u00edvel localizar o registro de publica\u00e7\u00e3o para esse Cliente/Produto/Tecnologia");
        }
    }

    @Override
    @Transactional
    public String atualizaTagVersao3(String cliente, String sistema, TecnologiaType tecnologia) throws VersionamentoException {
        try {
            SistemaEntity sistemaEntity;
            Query query = this.getEntityManager().createQuery("SELECT v FROM SistemaEntity v WHERE v.cliente = :cliente AND       v.sistema = :sistema AND       v.tecnologia = :tecnologia");
            query.setParameter("cliente", (Object)cliente);
            query.setParameter("sistema", (Object)sistema);
            query.setParameter("tecnologia", (Object)tecnologia);
            try {
                sistemaEntity = (SistemaEntity)query.getSingleResult();
            }
            catch (NoResultException ex) {
                throw new Exception("N\u00e3o foi poss\u00edvel localizar o registro de publica\u00e7\u00e3o para esse Cliente/Produto/Tecnologia");
            }
            sistemaEntity.setTagVersao3(sistemaEntity.getTagVersao3() + 1L);
            sistemaEntity.setTagVersao4(0L);
            this.getEntityManager().merge((Object)sistemaEntity);
            return sistemaEntity.getTagVersao1() + "." + sistemaEntity.getTagVersao2() + "." + sistemaEntity.getTagVersao3() + "." + sistemaEntity.getTagVersao4();
        }
        catch (Exception ex) {
            throw new VersionamentoException(ex.getMessage());
        }
    }

    @Override
    @Transactional
    public String atualizaTagVersao4(String cliente, String produto, TecnologiaType tecnologia) throws VersionamentoException {
        try {
            SistemaEntity sistemaEntity;
            Query query = this.getEntityManager().createQuery("SELECT v FROM SistemaEntity v WHERE v.cliente = :cliente AND       v.sistema = :produto AND       v.tecnologia = :tecnologia");
            query.setParameter("cliente", (Object)cliente);
            query.setParameter("produto", (Object)produto);
            query.setParameter("tecnologia", (Object)tecnologia);
            try {
                sistemaEntity = (SistemaEntity)query.getSingleResult();
            }
            catch (NoResultException ex) {
                throw new Exception("N\u00e3o foi poss\u00edvel localizar o registro de publica\u00e7\u00e3o para esse Cliente/Produto/Tecnologia");
            }
            sistemaEntity.setTagVersao4(sistemaEntity.getTagVersao4() + 1L);
            this.getEntityManager().merge((Object)sistemaEntity);
            String retorno = sistemaEntity.getTagVersao1() + "." + sistemaEntity.getTagVersao2() + "." + sistemaEntity.getTagVersao3() + "." + sistemaEntity.getTagVersao4();
            return retorno;
        }
        catch (Exception ex) {
            throw new VersionamentoException(ex.getMessage());
        }
    }

    @Override
    public List<SistemaEntity> buscaTudoPublicavel() {
        return this.getClientJpql().fetchLeftJoin(SistemaEntity_.listaDadosPublicacao).where().equalsTo(SistemaEntity_.permitePublicacao, (Object)true).collect().list();
    }
}

