/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.rs;

import br.com.dsfnet.gpd.client.parametro.ParametroRepository;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.type.AmbienteType;
import br.com.dsfnet.gpd.client.type.PublicacaoType;
import br.com.jarch.util.LogUtils;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Form;
import jakarta.ws.rs.core.Response;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import org.glassfish.jersey.client.authentication.HttpAuthenticationFeature;

public class ServiceClient {
    private static final String APPLICATION_JSON_CHARSET_UTF_8 = "application/json;charset=UTF-8";

    private ServiceClient() {
    }

    public static void automatizaJavaPrincipal(Long id, String sols, SistemaEntity aplicacao, String versao, String token, String idColuna, String corInicial, String corSucesso, String corFalha, AmbienteType ambiente) {
        ServiceClient.servicoJenkins(ServiceClient.desenvolvimento() + "Automatiza_Java_Principal", id, "MERGE_PUBLICACAO", sols, aplicacao, versao, Map.of("AMBIENTE", ambiente.name()), token, idColuna, corInicial, corSucesso, corFalha, ambiente);
    }

    public static void servicoAutomatizaFase2(Long id, String sols, SistemaEntity aplicacao, String versao, String nomeAmbiente, String ipAmbiente, String caminhoAmbiente, String token, String idColuna, String corInicial, String corSucesso, String corFalha, AmbienteType ambiente) {
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("NOME_AMBIENTE", nomeAmbiente);
        parametros.put("IP_AMBIENTES", ipAmbiente);
        parametros.put("CAMINHO_AMBIENTE", caminhoAmbiente);
        ServiceClient.servicoJenkins(ServiceClient.desenvolvimento() + "Automatiza_Java_Fase_2", id, "PUBLICACAO", sols, aplicacao, versao, parametros, token, idColuna, corInicial, corSucesso, corFalha, ambiente);
    }

    public static void versionaJavaPrincipal(Long id, PublicacaoType tipoPublicacao, String sols, SistemaEntity aplicacao, String versao, String nomeAmbiente, String ipAmbiente, String caminhoAmbiente, String tag, String token, String idColuna, String corInicial, String corSucesso, String corFalha, AmbienteType ambiente) {
        HashMap<String, String> parametros = new HashMap<String, String>();
        parametros.put("NOME_AMBIENTE", nomeAmbiente);
        parametros.put("IP_AMBIENTES", ipAmbiente);
        parametros.put("CAMINHO_AMBIENTE", caminhoAmbiente);
        parametros.put("TAG", tag);
        ServiceClient.servicoJenkins(ServiceClient.desenvolvimento() + "Versiona_Java_Principal", id, tipoPublicacao.name(), sols, aplicacao, versao, parametros, token, idColuna, corInicial, corSucesso, corFalha, ambiente);
    }

    private static void servicoJenkins(String metodo, Long id, String tipo, String sols, SistemaEntity aplicacao, String versao, Map<String, String> parametros, String token, String idColuna, String corInicial, String corSucesso, String corFalha, AmbienteType ambiente) {
        Response response;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("SOL", sols);
        hashMap.put("NOME_BRANCH_PACOTE", versao);
        hashMap.put("NOME_PRODUTO", aplicacao.getSistema());
        hashMap.put("PROJETO_SVN", aplicacao.getProjetoSvn());
        hashMap.put("NOME_ARTEFATO", aplicacao.getNomePacote());
        hashMap.put("CLIENTE", aplicacao.getCliente());
        hashMap.put("TECNOLOGIA", aplicacao.getTecnologia().name());
        hashMap.put("ARQUIVOS_EXCLUIDOS", aplicacao.getArquivosExclusao());
        hashMap.put("ARQUIVOS_BACKUP", aplicacao.getArquivosBackup());
        hashMap.put("CMD_POS_PUBLICACAO", aplicacao.getCommandoShellPosPublicacao());
        hashMap.put("ID_GPD", "" + id);
        hashMap.put("TIPO_GPD", tipo);
        hashMap.put("AMBIENTE", ambiente.name());
        hashMap.put("TOKEN", token);
        hashMap.put("ID_COLUNA", idColuna);
        hashMap.put("COR_INICIAL", corInicial);
        hashMap.put("COR_SUCESSO", corSucesso);
        hashMap.put("COR_FALHA", corFalha);
        if (parametros != null) {
            hashMap.putAll(parametros);
        }
        if (ServiceClient.isStatusOk(response = ServiceClient.chamaWSPost(metodo, hashMap))) {
            String resposta = (String)response.readEntity(String.class);
            LogUtils.generate((String)resposta);
        }
    }

    private static String desenvolvimento() {
        String valor = System.getProperty("GPD.DESENVOLVIMENTO");
        if (valor != null && valor.equals("S")) {
            return "H_";
        }
        return "";
    }

    private static Response chamaWSPost(String metodo, Map<String, String> parametro) {
        ParametroRepository parametroManager = (ParametroRepository)CDI.current().select(ParametroRepository.class, new Annotation[0]).get();
        Object url = ParametroRepository.getInstance().pesquisaChave("JENKINS.URL");
        String token = ParametroRepository.getInstance().pesquisaChave("JENKINS.TOKEN");
        String usuario = ParametroRepository.getInstance().pesquisaChave("JENKINS.USUARIO");
        String senha = ParametroRepository.getInstance().pesquisaChave("JENKINS.SENHA");
        Form form = new Form();
        for (Map.Entry<String, String> item : parametro.entrySet()) {
            form.param(item.getKey(), item.getValue());
        }
        url = (String)url + (((String)url).endsWith("/") ? "" : "/") + metodo + "/" + token;
        return ((WebTarget)ClientBuilder.newClient().target((String)url).register((Object)HttpAuthenticationFeature.basicBuilder().build())).request(new String[]{"text/html"}).property("jersey.config.client.http.auth.basic.username", (Object)usuario).property("jersey.config.client.http.auth.basic.password", (Object)senha).accept(new String[]{"application/json"}).post(Entity.form((Form)form));
    }

    private static boolean isStatusOk(Response response) {
        if (response.getStatus() == Response.Status.OK.getStatusCode()) {
            return true;
        }
        String mensagemErro = (String)response.readEntity(String.class);
        LogUtils.warning((String)mensagemErro);
        return false;
    }

    private static String URL() {
        return "http://localhost:8080/gpd-web/servico/";
    }

    private static WebTarget getWebTarget() {
        return ClientBuilder.newClient().target(ServiceClient.URL());
    }

    public static boolean perfil(String login) {
        WebTarget webTarget = ServiceClient.getWebTarget().path("perfil").path(login);
        Invocation.Builder invocationBuilder = webTarget.request(new String[]{APPLICATION_JSON_CHARSET_UTF_8});
        Response response = invocationBuilder.get();
        if (ServiceClient.isStatusOk(response)) {
            return Boolean.valueOf((String)response.readEntity(String.class));
        }
        return false;
    }

    public static boolean perfilBuild(String login) {
        WebTarget webTarget = ServiceClient.getWebTarget().path("perfilBuild").path(login);
        Invocation.Builder invocationBuilder = webTarget.request(new String[]{APPLICATION_JSON_CHARSET_UTF_8});
        Response response = invocationBuilder.get();
        if (ServiceClient.isStatusOk(response)) {
            return Boolean.valueOf((String)response.readEntity(String.class));
        }
        return false;
    }
}

