/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.planejamento;

import br.com.dsfnet.gpd.client.kanban.KanbanEntity;
import br.com.dsfnet.gpd.client.planejamento.PlanejamentoSolEntity;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.jarch.core.annotation.JArchConfiguration;
import br.com.jarch.core.crud.entity.CrudEntity;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToMany;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

@Entity
@Table(name="PLANEJAMENTO")
@JArchConfiguration(ignorePatternsObjetcsDataBase=true, generateFilterSelection=false)
@SequenceGenerator(name="PlanejamentoIdSequence", sequenceName="SEQ_PLANEJAMENTO_ID", allocationSize=1)
public class PlanejamentoEntity
extends CrudEntity
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="PlanejamentoIdSequence")
    private Long id;
    private String versao;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date data;
    @OneToMany(mappedBy="planejamentoEntity", cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER)
    private Set<PlanejamentoSolEntity> listaSol;
    @OneToOne
    @JoinColumn(name="aplicacao_id")
    private SistemaEntity sistemaEntity;
    @OneToOne
    @JoinColumn(name="usuario_id")
    private UsuarioEntity usuarioEntity;
    @OneToOne
    @JoinColumn(name="id_kanban")
    private KanbanEntity kanbanEntity;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getVersao() {
        return this.versao;
    }

    public void setVersao(String versao) {
        this.versao = versao;
    }

    public SistemaEntity getSistemaEntity() {
        return this.sistemaEntity;
    }

    public void setSistemaEntity(SistemaEntity sistemaEntity) {
        this.sistemaEntity = sistemaEntity;
    }

    public UsuarioEntity getUsuarioEntity() {
        return this.usuarioEntity;
    }

    public void setUsuarioEntity(UsuarioEntity usuarioEntity) {
        this.usuarioEntity = usuarioEntity;
    }

    public Date getData() {
        return this.data;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public Set<PlanejamentoSolEntity> getListaSol() {
        return this.listaSol;
    }

    public void setListaSol(Set<PlanejamentoSolEntity> listaSol) {
        this.listaSol = listaSol;
    }

    public KanbanEntity getKanbanEntity() {
        return this.kanbanEntity;
    }

    public void setKanbanEntity(KanbanEntity kanbanEntity) {
        this.kanbanEntity = kanbanEntity;
    }

    public void addSol(PlanejamentoSolEntity planejamentoSolEntity) {
        if (this.listaSol == null) {
            this.listaSol = new HashSet<PlanejamentoSolEntity>();
        }
        planejamentoSolEntity.setPlanejamentoEntity(this);
        this.listaSol.add(planejamentoSolEntity);
    }

    public int compareTo(PlanejamentoEntity outro) {
        if (this.getSistemaEntity() != null && outro.getSistemaEntity() != null && this.getSistemaEntity().getCliente().compareTo(outro.getSistemaEntity().getCliente()) != 0) {
            return this.getSistemaEntity().getCliente().compareTo(outro.getSistemaEntity().getCliente());
        }
        if (this.getSistemaEntity() != null && outro.getSistemaEntity() != null && this.getSistemaEntity().getSistema().compareTo(outro.getSistemaEntity().getSistema()) != 0) {
            return this.getSistemaEntity().getSistema().compareTo(outro.getSistemaEntity().getSistema());
        }
        if (this.getSistemaEntity() != null && outro.getSistemaEntity() != null && this.getSistemaEntity().getTecnologia().compareTo(outro.getSistemaEntity().getTecnologia()) != 0) {
            return this.getSistemaEntity().getTecnologia().compareTo(outro.getSistemaEntity().getTecnologia());
        }
        if (this.getVersao() != null && outro.getVersao() != null) {
            return this.getVersao().compareTo(outro.getVersao());
        }
        return this.getId().compareTo(outro.getId());
    }

    public String toString() {
        Object print = "";
        if (this.sistemaEntity != null) {
            print = (String)print + "Cliente: " + this.sistemaEntity.getCliente();
            print = (String)print + " Produto: " + this.sistemaEntity.getSistema();
            print = (String)print + " Tecnologia: " + String.valueOf((Object)this.sistemaEntity.getTecnologia());
        }
        print = (String)print + " Vers\u00e3o: " + this.versao;
        return print;
    }
}

