/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.empacotamento;

import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.jarch.core.annotation.JArchConfiguration;
import br.com.jarch.core.crud.entity.CrudEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.Date;

@Entity
@Table(name="TB_EMPACOTAMENTOCONFLITO")
@JArchConfiguration(ignorePatternsObjetcsDataBase=true, generateFilterSelection=false)
@SequenceGenerator(name="EmpacotamentoConflitoIdSequence", sequenceName="SEQ_EMPACOTAMENTO_CON_ID", allocationSize=1)
public class EmpacotamentoConflitoEntity
extends CrudEntity
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="EmpacotamentoConflitoIdSequence")
    @Column(name="id_empacotamentoconflito")
    private Long id;
    @OneToOne
    @JoinColumn(name="id_aplicacao")
    private SistemaEntity sistemaEntity;
    @OneToOne
    @JoinColumn(name="id_usuario")
    private UsuarioEntity usuarioEntity;
    @Column(name="nr_versao")
    private String versao;
    @Column(name="dt_conflito")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date data;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getVersao() {
        return this.versao;
    }

    public void setVersao(String versao) {
        this.versao = versao;
    }

    public SistemaEntity getSistemaEntity() {
        return this.sistemaEntity;
    }

    public void setSistemaEntity(SistemaEntity sistemaEntity) {
        this.sistemaEntity = sistemaEntity;
    }

    public UsuarioEntity getUsuarioEntity() {
        return this.usuarioEntity;
    }

    public void setUsuarioEntity(UsuarioEntity usuarioEntity) {
        this.usuarioEntity = usuarioEntity;
    }

    public Date getData() {
        return this.data;
    }

    public void setData(Date data) {
        this.data = data;
    }

    public int compareTo(EmpacotamentoConflitoEntity outro) {
        if (this.getSistemaEntity() != null && outro.getSistemaEntity() != null && this.getSistemaEntity().getCliente().compareTo(outro.getSistemaEntity().getCliente()) != 0) {
            return this.getSistemaEntity().getCliente().compareTo(outro.getSistemaEntity().getCliente());
        }
        if (this.getSistemaEntity() != null && outro.getSistemaEntity() != null && this.getSistemaEntity().getSistema().compareTo(outro.getSistemaEntity().getSistema()) != 0) {
            return this.getSistemaEntity().getSistema().compareTo(outro.getSistemaEntity().getSistema());
        }
        if (this.getSistemaEntity() != null && outro.getSistemaEntity() != null && this.getSistemaEntity().getTecnologia().compareTo(outro.getSistemaEntity().getTecnologia()) != 0) {
            return this.getSistemaEntity().getTecnologia().compareTo(outro.getSistemaEntity().getTecnologia());
        }
        if (this.getVersao() != null && outro.getVersao() != null && this.getVersao().compareTo(outro.getVersao()) != 0) {
            return this.getVersao().compareTo(outro.getVersao());
        }
        return this.getId().compareTo(outro.getId());
    }
}

