/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.desenvolvimento;

import br.com.dsfnet.gpd.client.aceite.AceiteRepository;
import br.com.dsfnet.gpd.client.desenvolvimento.DesenvolvimentoEntity;
import br.com.dsfnet.gpd.client.desenvolvimento.DesenvolvimentoRepository;
import br.com.dsfnet.gpd.client.exception.DesenvolvimentoException;
import br.com.dsfnet.gpd.client.exception.PacoteException;
import br.com.dsfnet.gpd.client.form.AplicacaoForm;
import br.com.dsfnet.gpd.client.form.DesenvolvimentoForm;
import br.com.dsfnet.gpd.client.homologacao.HomologacaoRepository;
import br.com.dsfnet.gpd.client.pacote.PacoteRepository;
import br.com.dsfnet.gpd.client.parametro.ParametroRepository;
import br.com.dsfnet.gpd.client.qualidade.QualidadeRepository;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.sistema.SistemaRepository;
import br.com.dsfnet.gpd.client.sol.SolRepository;
import br.com.dsfnet.gpd.client.svn.DesenvolvimentoSvn;
import br.com.dsfnet.gpd.client.type.StatusType;
import br.com.dsfnet.gpd.client.type.TecnologiaType;
import br.com.dsfnet.gpd.client.util.Factory;
import br.com.jarch.core.crud.service.CrudService;
import br.com.jarch.util.StringUtils;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.inject.spi.CDI;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.List;

public class DesenvolvimentoService
extends CrudService<DesenvolvimentoEntity, DesenvolvimentoRepository> {
    @Inject
    private DesenvolvimentoSvn desenvolvimentoSvn;
    @Inject
    @Named(value="loginSvn")
    private String login;
    @Inject
    @Named(value="senhaSvn")
    private String senha;
    private String servidorSvn;

    public static DesenvolvimentoService getInstance() {
        return (DesenvolvimentoService)((Object)CDI.current().select(DesenvolvimentoService.class, new Annotation[0]).get());
    }

    @PostConstruct
    private void inicializacao() {
        this.servidorSvn = ParametroRepository.getInstance().pesquisaChave("GPD.SVN.SERVIDOR");
    }

    public String descricaoSol(String branch) {
        return SolRepository.getInstance().descricaoTask(branch);
    }

    public DesenvolvimentoEntity pesquisaBranch(String branch) {
        return DesenvolvimentoRepository.getInstance().pesquisaBranch(branch);
    }

    public void validaInicioDesenvolvimento(String branch, String cliente, String sistema, TecnologiaType tecnologia, String login) throws DesenvolvimentoException {
        try {
            this.validaCamposAbrigatorio(branch, cliente, sistema, tecnologia);
            SistemaEntity aplicacao = SistemaRepository.getInstance().pesquisar(cliente, sistema, tecnologia);
            this.validarJaIniciado(aplicacao, branch, login);
            this.validarBloqueadoQualidade(aplicacao, branch);
            this.validarBloqueadoHomologacao(aplicacao, branch);
            this.validarBloqueadoAceiteIndividual(aplicacao, branch);
            this.validarBloqueadoAceitePacote(aplicacao, branch);
        }
        catch (Exception ex) {
            throw new DesenvolvimentoException(ex.getMessage());
        }
    }

    public void validaDescarteDesenvolvimento(DesenvolvimentoEntity desenvolvimento) throws DesenvolvimentoException {
        if (desenvolvimento == null) {
            throw new DesenvolvimentoException("Selecione a SOL");
        }
    }

    public void validaDescarteDesenvolvimento(Long desenvolvimentoId, String login) throws DesenvolvimentoException {
        DesenvolvimentoEntity desenvolvimento = (DesenvolvimentoEntity)DesenvolvimentoRepository.getInstance().find(desenvolvimentoId);
        if (desenvolvimento == null) {
            throw new DesenvolvimentoException("Branch n\u00e3o localizada");
        }
        if (!desenvolvimento.getUsuarioEntity().getLogin().equals(login)) {
            throw new DesenvolvimentoException("Branch n\u00e3o iniciada pelo login " + login);
        }
        if (desenvolvimento.getStatus() != StatusType.BLOQUEADO) {
            throw new DesenvolvimentoException("Branch n\u00e3o iniciada");
        }
    }

    public void validaSalvaDesenvolvimento(DesenvolvimentoEntity desenvolvimento) throws DesenvolvimentoException {
        if (desenvolvimento == null) {
            throw new DesenvolvimentoException("Selecione uma SOL");
        }
        if (desenvolvimento.getNumeroSol().equals("1")) {
            throw new DesenvolvimentoException("### ESSA BranchN\u00c3O PODE SER FINALIZADA, SOMENTE DESCARTADA ###");
        }
    }

    public void validaSalvaDesenvolvimento(Long desenvolvimentoId, String comentario) throws DesenvolvimentoException {
        if (desenvolvimentoId == null) {
            throw new DesenvolvimentoException("Selecione uma SOL");
        }
        DesenvolvimentoEntity desenvolvimento = (DesenvolvimentoEntity)DesenvolvimentoRepository.getInstance().find(desenvolvimentoId);
        if (desenvolvimento == null) {
            throw new DesenvolvimentoException("Selecione uma SOL");
        }
        if (desenvolvimento.getNumeroSol().equals("1")) {
            throw new DesenvolvimentoException("### ESSA BranchN\u00c3O PODE SER FINALIZADA, SOMENTE DESCARTADA ###");
        }
        if (comentario == null || comentario.isEmpty()) {
            throw new DesenvolvimentoException("Coment\u00e1rio tem que conter pelo menos 5 caracteres");
        }
    }

    public void validaFimDesenvolvimento(DesenvolvimentoForm desenvolvimentoForm, AplicacaoForm aplicacaoForm) throws DesenvolvimentoException {
        if (desenvolvimentoForm == null) {
            throw new DesenvolvimentoException("Selecione uma SOL");
        }
        if (desenvolvimentoForm.getBranch().equals("1")) {
            throw new DesenvolvimentoException("### ESSA BranchN\u00c3O PODE SER FINALIZADA, SOMENTE DESCARTADA ###");
        }
        if (desenvolvimentoForm.getTecnologia().pacoteObrigatorio() && (desenvolvimentoForm.getNomeArquivoPacote() == null || desenvolvimentoForm.getNomeArquivoPacote().isEmpty())) {
            throw new DesenvolvimentoException("Pacote para publica\u00e7\u00e3o N\u00c3O selecionado");
        }
        if (desenvolvimentoForm.getTecnologia().pacoteObrigatorio() && desenvolvimentoForm.getTamanhoPacoteBytes() < 10L) {
            throw new DesenvolvimentoException("Pacote para publica\u00e7\u00e3o est\u00e1 vazio (0 bytes)");
        }
        try {
            if (desenvolvimentoForm.getNomeArquivoPacote() == null && aplicacaoForm.getPacotesValido() != null && !aplicacaoForm.getPacotesValido().contains(desenvolvimentoForm.getNomeArquivoPacote())) {
                throw new DesenvolvimentoException(String.format("Nome de pacote inv\u00e1lido. Somente um dos pacotes %s ser\u00e1 aceito", aplicacaoForm.getPacotesValido().replaceAll(",", " / ")));
            }
            if (desenvolvimentoForm.getComentario() == null || desenvolvimentoForm.getComentario().isEmpty()) {
                throw new DesenvolvimentoException("Preencha o coment\u00e1rio");
            }
        }
        catch (Exception ex) {
            throw new DesenvolvimentoException(ex.getMessage());
        }
    }

    public void atualizaBancoDadosInicioDesenvolvimento(String branch, String cliente, String sistema, TecnologiaType tecnologia, String login) {
        SistemaEntity aplicacao = SistemaRepository.getInstance().pesquisar(cliente, sistema, tecnologia);
        DesenvolvimentoRepository.getInstance().iniciar(aplicacao.getId(), branch, login);
    }

    public void atualizaBancoDadosDescarteDesenvolvimento(Long desenvolvimentoId) {
        DesenvolvimentoRepository.getInstance().descartar(desenvolvimentoId);
    }

    public void atualizaBancoDadosSalvaDesenvolvimento(Long desenvolvimentoId) {
    }

    public void atualizaBancoDadosFimDesenvolvimento(DesenvolvimentoForm desenvolvimentoForm, byte[] streamPacote) throws PacoteException, IOException {
        DesenvolvimentoRepository.getInstance().finalizar(desenvolvimentoForm.getId());
        if (streamPacote != null) {
            PacoteRepository.getInstance().gravar(desenvolvimentoForm.getSistema(), desenvolvimentoForm.getTecnologia(), desenvolvimentoForm.getCliente(), desenvolvimentoForm.getBranch(), streamPacote, desenvolvimentoForm.getNomeArquivoPacote());
        }
    }

    public void atualizaBancoDadosFinalizaDesenvolvimento(Long desenvolvimentoId) throws PacoteException, IOException {
        DesenvolvimentoRepository.getInstance().finalizar(desenvolvimentoId);
    }

    public List<String> iniciaDesenvolvimento(String branch, String cliente, String sistema, TecnologiaType tecnologia, boolean mergeTrunk, OutputStream outputStream) throws DesenvolvimentoException {
        try {
            this.validaInicioDesenvolvimento(branch, cliente, sistema, tecnologia, this.login);
            SistemaEntity aplicacao = SistemaRepository.getInstance().pesquisar(cliente, sistema, tecnologia);
            AplicacaoForm aplicacaoForm = Factory.getAplicacaoForm(aplicacao);
            List<String> log = this.desenvolvimentoSvn.inicioDesenvolvimento(this.servidorSvn, this.login, this.senha, branch, aplicacaoForm, mergeTrunk, outputStream);
            this.atualizaBancoDadosInicioDesenvolvimento(branch, cliente, sistema, tecnologia, this.login);
            return log;
        }
        catch (Exception e) {
            throw new DesenvolvimentoException(e.getMessage());
        }
    }

    public List<String> descartaDesenvolvimento(String login, DesenvolvimentoEntity desenvolvimento) throws Exception {
        this.validaDescarteDesenvolvimento(desenvolvimento);
        List<String> log = this.desenvolvimentoSvn.descarteDesenvolvimento(login, desenvolvimento.getSistemaEntity().getServidorDesenvolvimento(), desenvolvimento.getNumeroSol());
        this.atualizaBancoDadosDescarteDesenvolvimento(desenvolvimento.getId());
        return log;
    }

    public List<String> salvaDesenvolvimento(DesenvolvimentoEntity desenvolvimento, String comentario, OutputStream outputStream) throws DesenvolvimentoException {
        try {
            this.validaSalvaDesenvolvimento(desenvolvimento);
            String projetoSvn = desenvolvimento.getSistemaEntity().getProjetoSvn();
            String servidorDesenvolvimento = desenvolvimento.getSistemaEntity().getServidorDesenvolvimento();
            String branch = desenvolvimento.getNumeroSol();
            this.desenvolvimentoSvn.validacaoWorkingCopyBranch(this.servidorSvn, projetoSvn, this.login, this.senha, servidorDesenvolvimento, branch, outputStream);
            List<String> log = this.desenvolvimentoSvn.salvaDesenvolvimento(this.servidorSvn, projetoSvn, this.login, this.senha, servidorDesenvolvimento, branch, null, comentario, outputStream);
            this.atualizaBancoDadosSalvaDesenvolvimento(desenvolvimento.getId());
            return log;
        }
        catch (Exception e) {
            throw new DesenvolvimentoException(e.getMessage());
        }
    }

    public List<String> finalizaDesenvolvimento(DesenvolvimentoForm desenvolvimentoForm, AplicacaoForm aplicacaoForm, byte[] streamPacote, OutputStream outputStream) throws DesenvolvimentoException {
        try {
            this.validaFimDesenvolvimento(desenvolvimentoForm, aplicacaoForm);
            String projetoSvn = aplicacaoForm.getProjetoSvn();
            String login1 = desenvolvimentoForm.getLogin();
            String senha1 = desenvolvimentoForm.getSenha();
            String servidorDesenvolvimento = aplicacaoForm.getServidorDesenvolvimento();
            String branch = desenvolvimentoForm.getBranch();
            this.desenvolvimentoSvn.validacaoWorkingCopyBranch(this.servidorSvn, projetoSvn, login1, senha1, servidorDesenvolvimento, branch, outputStream);
            List<String> log = this.desenvolvimentoSvn.finalizaDesenvolvimento(this.servidorSvn, desenvolvimentoForm, aplicacaoForm, null, outputStream);
            this.atualizaBancoDadosFimDesenvolvimento(desenvolvimentoForm, streamPacote);
            return log;
        }
        catch (Exception e) {
            throw new DesenvolvimentoException(e.getMessage());
        }
    }

    private void validaCamposAbrigatorio(String branch, String cliente, String sistema, TecnologiaType tecnologia) throws DesenvolvimentoException {
        if (StringUtils.isNullOrEmpty((String)branch)) {
            throw new DesenvolvimentoException("N\u00famero da Branch\u00e9 Obrigat\u00f3rio");
        }
        if (StringUtils.isNullOrEmpty((String)cliente)) {
            throw new DesenvolvimentoException("Cliente \u00e9 Obrigat\u00f3rio");
        }
        if (StringUtils.isNullOrEmpty((String)sistema)) {
            throw new DesenvolvimentoException("Sistema \u00e9 Obrigat\u00f3rio");
        }
        if (tecnologia == null) {
            throw new DesenvolvimentoException("Tecnologia \u00e9 Obrigat\u00f3rio");
        }
    }

    private void validarBloqueadoAceiteIndividual(SistemaEntity aplicacao, String branch) throws DesenvolvimentoException {
        try {
            if (AceiteRepository.getInstance().bloqueadoIndividual(aplicacao.getId(), branch)) {
                throw new DesenvolvimentoException("Sol bloqueada no ambiente do ACEITE");
            }
        }
        catch (Exception ex) {
            throw new DesenvolvimentoException(ex.getMessage());
        }
    }

    private void validarBloqueadoAceitePacote(SistemaEntity aplicacao, String branch) throws DesenvolvimentoException {
        try {
            if (AceiteRepository.getInstance().bloqueadoPacote(aplicacao.getId(), branch)) {
                throw new DesenvolvimentoException("Sol bloqueada no ambiente do ACEITE");
            }
        }
        catch (Exception ex) {
            throw new DesenvolvimentoException(ex.getMessage());
        }
    }

    private void validarBloqueadoHomologacao(SistemaEntity aplicacao, String branch) throws DesenvolvimentoException {
        try {
            if (HomologacaoRepository.getInstance().bloqueado(aplicacao.getId(), branch)) {
                throw new DesenvolvimentoException("Sol bloqueada no ambiente da HOMOLOGA\u00c7\u00c3O");
            }
        }
        catch (Exception ex) {
            throw new DesenvolvimentoException(ex.getMessage());
        }
    }

    private void validarBloqueadoQualidade(SistemaEntity aplicacao, String branch) throws DesenvolvimentoException {
        try {
            if (QualidadeRepository.getInstance().bloqueado(aplicacao.getId(), branch)) {
                throw new DesenvolvimentoException("Sol bloqueada no ambiente da QUALIDADE");
            }
        }
        catch (Exception ex) {
            throw new DesenvolvimentoException(ex.getMessage());
        }
    }

    private void validarJaIniciado(SistemaEntity aplicacao, String branch, String login) throws DesenvolvimentoException {
        try {
            List<DesenvolvimentoEntity> lista = DesenvolvimentoRepository.getInstance().aplicacaoEmUso(aplicacao.getSistema(), aplicacao.getProjetoSvn(), login);
            if (lista != null && !lista.isEmpty()) {
                if (lista.stream().noneMatch(x -> x.getNumeroSol().toString().equals(branch))) {
                    return;
                }
                StringBuilder listaSols = new StringBuilder();
                for (DesenvolvimentoEntity andamentoDesenvolvimentoEntity : lista) {
                    listaSols.append(andamentoDesenvolvimentoEntity.getNumeroSol() + ", ");
                }
                listaSols.replace(listaSols.length() - 2, listaSols.length(), "");
                throw new DesenvolvimentoException(String.format("BRANCH(s) %s referente ao sistema %s foi(ram) iniciada(s), por\u00e9m n\u00e3o foi(ram) finalizada(s). Por favor, antes de iniciar uma dessas BRANCH's, proceda com a opera\u00e7\u00e3o FINALIZAR ou DESCARTAR", listaSols, aplicacao.getSistema()));
            }
        }
        catch (DesenvolvimentoException pe) {
            throw new DesenvolvimentoException(pe.getMessage());
        }
    }
}

