/*
 * Decompiled with CFR 0.152.
 */
package com.aspose.words;

import com.aspose.words.CellFormat;
import com.aspose.words.CompositeNode;
import com.aspose.words.DocumentBase;
import com.aspose.words.DocumentVisitor;
import com.aspose.words.Node;
import com.aspose.words.Paragraph;
import com.aspose.words.ParagraphCollection;
import com.aspose.words.ReservedForInternalUse;
import com.aspose.words.Row;
import com.aspose.words.TableCollection;
import com.aspose.words.TableStyle;
import com.aspose.words.internal.zzZwy;
import com.aspose.words.zzVS2;
import com.aspose.words.zzWmx;
import com.aspose.words.zzX8A;
import com.aspose.words.zzY1Y;
import com.aspose.words.zzY3j;
import com.aspose.words.zzYLd;
import com.aspose.words.zzYNR;
import com.aspose.words.zzYOs;
import com.aspose.words.zzYYP;
import com.aspose.words.zzZ7r;

public class Cell
extends CompositeNode<Node>
implements zzY1Y,
zzYYP {
    private zzX8A zzXvp;
    private CellFormat zzwI;
    private ParagraphCollection zzYwa;
    private TableCollection zzZJx;

    public Cell(DocumentBase doc) {
        this(doc, new zzX8A());
    }

    Cell(DocumentBase doc, zzX8A cellPr) {
        super(doc);
        this.zzXvp = cellPr;
    }

    @Override
    public int getNodeType() {
        return 7;
    }

    final Cell zzYEV() {
        return (Cell)this.zzX5();
    }

    public Row getParentRow() {
        return (Row)this.zzYNV();
    }

    public Paragraph getFirstParagraph() {
        return (Paragraph)this.getChild(8, 0, false);
    }

    public Paragraph getLastParagraph() {
        return (Paragraph)this.getChild(8, -1, false);
    }

    public boolean isFirstCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getFirstCell()) {
                return true;
            }
        }
        return false;
    }

    public boolean isLastCell() {
        if (this.getParentRow() != null) {
            Cell cell = this;
            if (cell == cell.getParentRow().getLastCell()) {
                return true;
            }
        }
        return false;
    }

    final int zzZkg() {
        Row row = this.getParentRow();
        if (row != null) {
            return row.zzYeh(this, true);
        }
        return -1;
    }

    final int zzXCO() {
        if (this.getParentRow() != null) {
            return this.getParentRow().zzXCO();
        }
        return -1;
    }

    public CellFormat getCellFormat() {
        if (this.zzwI == null) {
            this.zzwI = new CellFormat(this);
        }
        return this.zzwI;
    }

    public ParagraphCollection getParagraphs() {
        if (this.zzYwa == null) {
            this.zzYwa = new ParagraphCollection(this);
        }
        return this.zzYwa;
    }

    public TableCollection getTables() {
        if (this.zzZJx == null) {
            this.zzZJx = new TableCollection(this);
        }
        return this.zzZJx;
    }

    final zzX8A zzYJP() {
        return this.zzXvp;
    }

    final void zzXDP(zzX8A zzX8A2) {
        this.zzXvp = zzX8A2;
    }

    @Override
    final Node zzXDP(boolean bl, zzVS2 zzVS22) {
        zzX8A zzX8A2;
        Cell cell = (Cell)super.zzXDP(bl, zzVS22);
        zzX8A zzX8A3 = this.zzXvp;
        cell.zzXvp = zzX8A2 = (zzX8A)zzX8A3.zzWst();
        cell.zzwI = null;
        cell.zzYwa = null;
        cell.zzZJx = null;
        return cell;
    }

    @Override
    public boolean accept(DocumentVisitor visitor) throws Exception {
        return this.acceptCore(visitor);
    }

    @Override
    final int zzXDP(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellStart(this);
    }

    @Override
    final int zzYMQ(DocumentVisitor documentVisitor) throws Exception {
        return documentVisitor.visitCellEnd(this);
    }

    public void ensureMinimum() {
        zzY3j.zzXw2(this);
    }

    @Override
    final boolean zzX8e(Node node) {
        return zzWmx.zzW8N(node);
    }

    final int zzXaA() {
        Row row = this.getParentRow();
        if (row == null) {
            return -1;
        }
        int n = -1;
        Cell cell = row.getFirstCell();
        while (cell != null) {
            if (cell.getCellFormat().getHorizontalMerge() != 2) {
                ++n;
            }
            if (cell == this) {
                return n;
            }
            Cell cell2 = cell;
            cell = (Cell)cell2.zzX5();
        }
        return -1;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object getDirectCellAttr(int key) {
        return this.zzXvp.zzWyq(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchCellAttr(int key) {
        Object object = this.zzXvp.zzWyq(key);
        if (object == null) {
            return this.fetchInheritedCellAttr(key);
        }
        zzYLd zzYLd2 = zzZwy.zzXDP(object, zzYLd.class);
        if (zzYLd2 != null && zzYLd2.isInheritedComplexAttr()) {
            return this.fetchInheritedCellAttr(key);
        }
        return object;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public Object fetchInheritedCellAttr(int key) {
        Object object = this.zzXah(key);
        if (object != null) {
            return object;
        }
        if (this.getParentRow() != null) {
            Row row = this.getParentRow();
            switch (key) {
                case 3070: {
                    return row.fetchRowAttr(4300);
                }
                case 3090: {
                    return row.fetchRowAttr(4020);
                }
                case 3080: {
                    return row.fetchRowAttr(4310);
                }
                case 3100: {
                    return row.fetchRowAttr(4320);
                }
                case 3110: {
                    return row.fetchRowAttr(this.getParentRow().isFirstRow() ? 4050 : 4090);
                }
                case 3120: {
                    return row.fetchRowAttr(this.isFirstCell() ? 4060 : 4100);
                }
                case 3130: {
                    return row.fetchRowAttr(this.getParentRow().isLastRow() ? 4070 : 4090);
                }
                case 3140: {
                    return row.fetchRowAttr(this.isLastCell() ? 4080 : 4100);
                }
            }
        }
        return zzX8A.zzZcL(key);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setCellAttr(int key, Object value) {
        this.zzXvp.zzZNm(key, value);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void clearCellAttrs() {
        this.zzXvp.clear();
    }

    private Object zzXah(int n) {
        Cell cell;
        if (this.getParentRow() == null || (cell = this).getParentRow().getParentTable() == null) {
            return null;
        }
        cell = this;
        TableStyle tableStyle = zzZwy.zzXDP((Object)cell.getParentRow().getParentTable().getStyle(), TableStyle.class);
        if (tableStyle != null) {
            return tableStyle.zzXDP(n, this);
        }
        return null;
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZ7r getInsertRevision() {
        Cell cell = this;
        return cell.zzXvp.getInsertRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setInsertRevision(zzZ7r value) {
        Cloneable cloneable = this;
        zzZ7r zzZ7r2 = value;
        cloneable = cloneable.zzXvp;
        ((zzYNR)cloneable).zzZNm(14, zzZ7r2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzZ7r getDeleteRevision() {
        Cell cell = this;
        return cell.zzXvp.getDeleteRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setDeleteRevision(zzZ7r value) {
        Cloneable cloneable = this;
        zzZ7r zzZ7r2 = value;
        cloneable = cloneable.zzXvp;
        ((zzYNR)cloneable).zzZNm(12, zzZ7r2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzYOs getMoveFromRevision() {
        Cell cell = this;
        return cell.zzXvp.getMoveFromRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveFromRevision(zzYOs value) {
        Cloneable cloneable = this;
        zzYOs zzYOs2 = value;
        cloneable = cloneable.zzXvp;
        ((zzYNR)cloneable).zzZNm(13, zzYOs2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public zzYOs getMoveToRevision() {
        Cell cell = this;
        return cell.zzXvp.getMoveToRevision();
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void setMoveToRevision(zzYOs value) {
        Cloneable cloneable = this;
        zzYOs zzYOs2 = value;
        cloneable = cloneable.zzXvp;
        ((zzYNR)cloneable).zzZNm(15, zzYOs2);
    }

    @Override
    @ReservedForInternalUse
    @Deprecated
    public void removeMoveRevisions() {
        Cell cell = this;
        cell.zzXvp.remove(13);
        cell = this;
        cell.zzXvp.remove(15);
    }

    final zzX8A zz2k(boolean bl) {
        Cell cell;
        TableStyle tableStyle;
        zzX8A zzX8A2 = new zzX8A();
        this.zzXDP(3120, zzX8A2);
        this.zzXDP(3140, zzX8A2);
        this.zzXDP(3110, zzX8A2);
        this.zzXDP(3130, zzX8A2);
        this.zzXDP(3090, zzX8A2);
        this.zzXDP(3100, zzX8A2);
        this.zzXDP(3070, zzX8A2);
        this.zzXDP(3080, zzX8A2);
        if (bl && (tableStyle = zzZwy.zzXDP((Object)(cell = this).getParentRow().getParentTable().getStyle(), TableStyle.class)) != null) {
            tableStyle.zzYMQ(this, zzX8A2);
        }
        this.zzXvp.zzYMQ((zzYNR)zzX8A2);
        return zzX8A2;
    }

    private void zzXDP(int n, zzX8A zzX8A2) {
        zzX8A2.zzZNm(n, this.fetchInheritedCellAttr(n));
    }
}

