/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import br.com.jarch.util.CollectionUtils;
import br.com.jarch.util.LogUtils;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class ZipUtils {
    private static final int BYTE_SIZE = 1024;

    private ZipUtils() {
    }

    public static void zipPath(Path zipPathDestiny, Path sourceDirPath) throws IOException {
        Path p = Files.createFile(zipPathDestiny, new FileAttribute[0]);
        try (ZipOutputStream zs = new ZipOutputStream(Files.newOutputStream(p, new OpenOption[0]));){
            Path pp = Paths.get(sourceDirPath.toString(), new String[0]);
            Files.walk(pp, new FileVisitOption[0]).filter(path -> !Files.isDirectory(path, new LinkOption[0])).forEach(path -> {
                ZipEntry zipEntry = new ZipEntry(pp.relativize((Path)path).toString());
                try {
                    zs.putNextEntry(zipEntry);
                    Files.copy(path, zs);
                    zs.closeEntry();
                }
                catch (IOException e) {
                    System.err.println(e);
                }
            });
        }
    }

    public static void compress(File fileDestiny, File file) {
        LogUtils.start();
        byte[] buffer = new byte[1024];
        try (FileOutputStream fos = new FileOutputStream(file);
             ZipOutputStream zos = new ZipOutputStream(fos);
             FileInputStream in = new FileInputStream(fileDestiny);){
            int len;
            ZipEntry ze = new ZipEntry(fileDestiny.getName());
            zos.putNextEntry(ze);
            while ((len = in.read(buffer)) > 0) {
                zos.write(buffer, 0, len);
            }
            in.close();
            zos.closeEntry();
            zos.close();
            LogUtils.end();
        }
        catch (IOException ex) {
            LogUtils.generate(ex);
        }
    }

    public static void compressFile(File fileDestinyZip, File fileCompressed) {
        ZipUtils.compressMultiplesFiles(fileDestinyZip, List.of(fileCompressed));
    }

    public static void compressMultiplesFiles(File fileDestinyZip, Collection<File> filesCompressed) {
        List<String> fileNames = filesCompressed.stream().map(File::getName).collect(Collectors.toList());
        ZipUtils.compressMultiplesFiles(fileDestinyZip, filesCompressed, fileNames);
    }

    public static void compressMultiplesFiles(File fileDestinyZip, Collection<File> files, Collection<String> names) {
        LogUtils.start();
        byte[] buffer = new byte[1024];
        if (CollectionUtils.isNotEmpty(files) && names.size() != files.size()) {
            throw new IllegalArgumentException("filesCompressed e fileNames devem ter o mesmo tamanho e n\u00e3o podem ser nulos");
        }
        try (FileOutputStream fos = new FileOutputStream(fileDestinyZip);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            ArrayList<File> filesCompressed = new ArrayList<File>(files);
            ArrayList<String> fileNames = new ArrayList<String>(names);
            for (int i = 0; i < filesCompressed.size(); ++i) {
                File arquivo = filesCompressed.get(i);
                String entryName = fileNames.get(i);
                try (FileInputStream in = new FileInputStream(arquivo);){
                    int len;
                    ZipEntry ze = new ZipEntry(entryName);
                    zos.putNextEntry(ze);
                    while ((len = in.read(buffer)) > 0) {
                        zos.write(buffer, 0, len);
                    }
                    zos.closeEntry();
                    LogUtils.generate("Arquivo " + entryName + " compresso com sucesso!");
                    continue;
                }
                catch (IOException e) {
                    LogUtils.generate(e);
                }
            }
            LogUtils.end();
        }
        catch (IOException e) {
            LogUtils.generate(e);
        }
    }

    public static void decompress(File arquivoZip, File diretory) throws IOException {
        LogUtils.start();
        try (ZipFile zipFile = new ZipFile(arquivoZip);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) {
                    String diretoryFile = diretory.getPath() + File.separator + entry.getName().substring(0, entry.getName().lastIndexOf(File.separator));
                    new File(diretoryFile).mkdirs();
                    LogUtils.generate("Descompactando diret\u00f3rio: " + entry.getName());
                    new File(String.valueOf(diretory.getAbsoluteFile()) + File.separator + entry.getName()).mkdir();
                    continue;
                }
                LogUtils.generate("Descompactando arquivo:" + String.valueOf(diretory.getAbsoluteFile()) + "/" + entry.getName());
                try (FileOutputStream out = new FileOutputStream(String.valueOf(diretory.getAbsoluteFile()) + "/" + entry.getName());){
                    ZipUtils.copyInputStream(zipFile.getInputStream(entry), new BufferedOutputStream(out));
                }
            }
            LogUtils.end();
        }
    }

    private static void copyInputStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) >= 0) {
            out.write(buffer, 0, len);
        }
        in.close();
        out.close();
    }

    public static void main(String[] args) {
        try {
            LogUtils.start();
            ArrayList<File> files = new ArrayList<File>();
            ArrayList<String> names = new ArrayList<String>();
            for (int i = 1; i <= 5; ++i) {
                File file = File.createTempFile("teste_" + i + "_", ".xlsx");
                files.add(file);
                String name = "Teste_" + i + ".xlsx";
                names.add(name);
            }
            File fileZip = File.createTempFile("teste_wagner", ".zip");
            ZipUtils.compressMultiplesFiles(fileZip, files, names);
            LogUtils.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

