/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import br.com.jarch.util.StringUtils;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class ValidationUtils {
    private ValidationUtils() {
    }

    public static boolean isEmail(String email) {
        if (StringUtils.isNullOrEmpty(email)) {
            return false;
        }
        email = email.trim();
        return Arrays.stream(email.split(";")).allMatch(ValidationUtils::isEmailValid);
    }

    public static boolean isEmailOrNullOrEmpty(String email) {
        if (StringUtils.isNullOrEmpty(email)) {
            return true;
        }
        email = email.trim();
        return Arrays.stream(email.split(";")).allMatch(ValidationUtils::isEmailValid);
    }

    private static boolean isEmailValid(String email) {
        email = email.trim();
        Pattern p = Pattern.compile("^(?=.{1,64}@)[A-Za-z0-9._%+-]+@(?=[^-])[A-Za-z0-9.-]+\\.[A-Za-z]{2,}$");
        Matcher m = p.matcher(email);
        return m.find();
    }

    public static boolean isNullOrEmpty(String value) {
        return StringUtils.isNullOrEmpty(value);
    }
}

