/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import br.com.jarch.util.LogUtils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;

public class QrCodeUtils {
    public static void generateQrCode(File file, String data, int width, int height) throws WriterException, IOException {
        String contents = new String(data.getBytes(StandardCharsets.UTF_8), StandardCharsets.UTF_8);
        BitMatrix matrix = new MultiFormatWriter().encode(contents, BarcodeFormat.QR_CODE, width, height);
        String formatFile = file.getName().substring(file.getName().indexOf(".") + 1);
        MatrixToImageWriter.writeToPath((BitMatrix)matrix, (String)formatFile, (Path)file.toPath());
    }

    public static void main(String[] args) throws WriterException, IOException {
        try {
            File imagemQrCode = File.createTempFile("qrcode", ".png");
            String linkQrCode = "https://notajoseense.sjc.sp.gov.br/notafiscal/paginas/portal/index.html";
            QrCodeUtils.generateQrCode(imagemQrCode, linkQrCode, 200, 200);
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
        }
    }
}

