/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import br.com.jarch.util.LogUtils;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class EmailGmailUtils
implements Serializable {
    private static final long serialVersionUID = -4996145542590233380L;
    private String servidorSmtp = "smtp.gmail.com";
    private String usuarioSmtp;
    private String senhaSmtp;
    private String emailDestinatario;
    private String emailCopia = "";
    private String assunto;
    private String mensagem;
    private List<File> anexos = new ArrayList<File>();

    public static void send(String servidorSmtp, String usuarioSmtp, String senhaSmtp, String emailDestinatario, String assunto, String mensagem) {
        EmailGmailUtils emailGmail = new EmailGmailUtils();
        emailGmail.setServidorSmtp(servidorSmtp);
        emailGmail.setAssunto(assunto);
        emailGmail.setEmailDestinatario(emailDestinatario);
        emailGmail.setMensagem(mensagem);
        emailGmail.setSenhaSmtp(senhaSmtp);
        emailGmail.setUsuarioSmtp(usuarioSmtp);
        emailGmail.enviar();
    }

    public String getServidorSmtp() {
        return this.servidorSmtp;
    }

    public void setServidorSmtp(String servidorSmtp) {
        this.servidorSmtp = servidorSmtp;
    }

    public String getUsuarioSmtp() {
        return this.usuarioSmtp;
    }

    public void setUsuarioSmtp(String usuarioSmtp) {
        this.usuarioSmtp = usuarioSmtp;
    }

    public String getSenhaSmtp() {
        return this.senhaSmtp;
    }

    public void setSenhaSmtp(String senhaSmtp) {
        this.senhaSmtp = senhaSmtp;
    }

    public String getEmailDestinatario() {
        return this.emailDestinatario;
    }

    public void setEmailDestinatario(String emailDestinatario) {
        this.emailDestinatario = emailDestinatario;
    }

    public String getEmailCopia() {
        return this.emailCopia;
    }

    public void setEmailCopia(String emailCopia) {
        this.emailCopia = emailCopia;
    }

    public String getAssunto() {
        return this.assunto;
    }

    public void setAssunto(String assunto) {
        this.assunto = assunto;
    }

    public String getMensagem() {
        return this.mensagem;
    }

    public void setMensagem(String mensagem) {
        this.mensagem = mensagem;
    }

    public List<File> getAnexos() {
        return this.anexos;
    }

    public void setAnexos(List<File> anexos) {
        this.anexos = anexos;
    }

    public void enviar() {
        LogUtils.start();
        try {
            int i;
            Properties props = System.getProperties();
            props.put("mail.smtp.starttls.enable", "true");
            props.put("mail.smtp.host", this.servidorSmtp);
            props.put("mail.smtp.user", this.usuarioSmtp);
            props.put("mail.smtp.password", this.senhaSmtp);
            props.put("mail.smtp.port", "587");
            props.put("mail.smtp.auth", "true");
            String[] destinatarios = this.emailDestinatario.split(";");
            String[] copias = this.emailCopia.split(";");
            Session session = Session.getDefaultInstance((Properties)props, null);
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(this.usuarioSmtp));
            InternetAddress[] toAddress = new InternetAddress[destinatarios.length];
            for (i = 0; i < destinatarios.length; ++i) {
                toAddress[i] = new InternetAddress(destinatarios[i]);
            }
            for (i = 0; i < toAddress.length; ++i) {
                message.addRecipient(Message.RecipientType.TO, (Address)toAddress[i]);
            }
            if (!"".equals(this.emailCopia)) {
                int i2;
                InternetAddress[] toCopias = new InternetAddress[copias.length];
                for (i2 = 0; i2 < copias.length; ++i2) {
                    toCopias[i2] = new InternetAddress(copias[i2]);
                }
                for (i2 = 0; i2 < toCopias.length; ++i2) {
                    message.addRecipient(Message.RecipientType.CC, (Address)toCopias[i2]);
                }
            }
            MimeBodyPart mbpMensagem = new MimeBodyPart();
            mbpMensagem.setText(this.mensagem);
            MimeMultipart mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)mbpMensagem);
            for (File anexo : this.anexos) {
                MimeBodyPart mbpAnexo = new MimeBodyPart();
                FileDataSource fds = new FileDataSource(anexo);
                mbpAnexo.setDataHandler(new DataHandler((DataSource)fds));
                mbpAnexo.setFileName(fds.getName());
                mp.addBodyPart((BodyPart)mbpAnexo);
            }
            message.setContent((Multipart)mp);
            LogUtils.generate("USUARIO SMTP: " + this.usuarioSmtp);
            LogUtils.generate("SENHA SMTP: " + this.senhaSmtp);
            LogUtils.generate("SERVIDOR SMTP: " + this.servidorSmtp);
            for (String para : destinatarios) {
                LogUtils.generate("DESTINATARIO(s): " + para);
            }
            for (String copia : copias) {
                LogUtils.generate("COPIAS(s): " + copia);
            }
            LogUtils.generate("ASSUNTO: " + this.assunto);
            LogUtils.generate("MENSAGEM: " + this.mensagem);
            message.setSubject(this.assunto);
            Transport transport = session.getTransport("smtp");
            transport.connect(this.servidorSmtp, this.usuarioSmtp, this.senhaSmtp);
            transport.sendMessage((Message)message, message.getAllRecipients());
            transport.close();
            LogUtils.end();
        }
        catch (MessagingException e) {
            LogUtils.generate(e);
        }
    }
}

