/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import br.com.jarch.util.NumberUtils;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

public final class DateUtils {
    private DateUtils() {
    }

    public static String formatDateJson(LocalDate value) {
        return DateUtils.formatddMMyyyy(value);
    }

    public static String format(String formatter, LocalDate localDate) {
        return localDate.format(DateTimeFormatter.ofPattern(formatter));
    }

    public static String format(String formatter, LocalDateTime localDateTime) {
        return localDateTime.format(DateTimeFormatter.ofPattern(formatter));
    }

    public static String format(String formatter, Date date) {
        return DateUtils.toLocalDate(date).format(DateTimeFormatter.ofPattern(formatter));
    }

    public static String formatddMMyyyy(LocalDate d) {
        if (d == null) {
            return "";
        }
        return d.format(DateTimeFormatter.ofPattern("dd/MM/yyyy"));
    }

    public static String formatDateTimeJson(LocalDateTime value) {
        return DateUtils.formatddMMyyyyHHmm(value);
    }

    public static String formatddMMyyyyHHmm(LocalDateTime localDateTime) {
        return localDateTime.format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm"));
    }

    public static Date toDateStartOfDay(Date d) {
        if (d == null) {
            return null;
        }
        LocalDateTime localDataHora = LocalDateTime.ofInstant(d.toInstant(), ZoneId.systemDefault()).with(LocalTime.MIN);
        return Date.from(localDataHora.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date toDateEndOfDay(LocalDate d) {
        if (d == null) {
            return null;
        }
        Instant instant = LocalDateTime.of(d, LocalTime.MAX).atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public static Date toDateEndOfDay(Date d) {
        LocalDateTime localDataHora = LocalDateTime.ofInstant(d.toInstant(), ZoneId.systemDefault()).with(LocalTime.MAX);
        return Date.from(localDataHora.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDateTime toLocalDateTime(Date d) {
        if (d == null) {
            return null;
        }
        Instant instant = Instant.ofEpochMilli(d.getTime());
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static LocalDateTime toLocalDateTimeStartOfDay(Date d) {
        if (d == null) {
            return null;
        }
        Instant instant = Instant.ofEpochMilli(d.getTime());
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalDate().atStartOfDay();
    }

    public static LocalDateTime toLocalDateTimeStartOfDay(LocalDate d) {
        if (d == null) {
            return null;
        }
        return d.atTime(LocalTime.MIN);
    }

    public static LocalDateTime toLocalDateTimeStartOfDay(XMLGregorianCalendar xmlGregorianCalendar) {
        LocalDateTime localDataHora = DateUtils.toLocalDateTime(xmlGregorianCalendar);
        return localDataHora.toLocalDate().atTime(LocalTime.MIN);
    }

    public static LocalDateTime toLocalDateTime(XMLGregorianCalendar xmlGregorianCalendar) {
        return xmlGregorianCalendar.toGregorianCalendar().toZonedDateTime().toLocalDateTime();
    }

    public static LocalDateTime toLocalDateTimeEndOfDay(Date d) {
        Instant instant = Instant.ofEpochMilli(d.getTime());
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalDate().atTime(LocalTime.MAX);
    }

    public static LocalDateTime toLocalDateTimeEndOfDay(LocalDate d) {
        if (d == null) {
            return null;
        }
        return d.atTime(LocalTime.MAX);
    }

    public static LocalDateTime toLocalDateTimeEndOfDay(XMLGregorianCalendar xmlGregorianCalendar) {
        LocalDate localData = DateUtils.toLocalDate(xmlGregorianCalendar);
        return localData.atTime(LocalTime.MAX);
    }

    public static LocalDate toLocalDate(XMLGregorianCalendar xmlGregorianCalendar) {
        return xmlGregorianCalendar.toGregorianCalendar().toZonedDateTime().toLocalDate();
    }

    public static Integer year() {
        return LocalDate.now().getYear();
    }

    public static String formatMMyyyy(Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat("MM/yyyy").format(date);
    }

    public static String formatMMyyyy(LocalDate localDate) {
        if (localDate == null) {
            return "";
        }
        return YearMonth.from(localDate).format(DateTimeFormatter.ofPattern("MM/yyyy"));
    }

    public static String formatMMyyyy(YearMonth yearMonth) {
        if (yearMonth == null) {
            return "";
        }
        return yearMonth.format(DateTimeFormatter.ofPattern("MM/yyyy"));
    }

    public static String formatMMMM(YearMonth yearMonth) {
        if (yearMonth == null) {
            return "";
        }
        String result = yearMonth.format(DateTimeFormatter.ofPattern("MMMM"));
        return result.substring(0, 1).toUpperCase() + result.substring(1);
    }

    public static String formatddMMyyyy(Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat("dd/MM/yyyy").format(date);
    }

    public static String formatddMMyyyTHHmmss(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return "";
        }
        return localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"));
    }

    public static String formatddMMyyyyHHmmss(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return "";
        }
        return localDateTime.format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss"));
    }

    public static String formatddMMyyyyHHmmssSSS(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return "";
        }
        return localDateTime.format(DateTimeFormatter.ofPattern("dd/MM/yyyy HH:mm:ss:SSS"));
    }

    public static String formatyyyyMMddHHmm(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return "";
        }
        return localDateTime.format(DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm"));
    }

    public static String formatyyyyMMddHHmmss(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return "";
        }
        return localDateTime.format(DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss"));
    }

    public static String formatyyyyMMddHHmmssSSS(LocalDateTime localDateTime) {
        if (localDateTime == null) {
            return "";
        }
        return localDateTime.format(DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss:SSS"));
    }

    public static String formatddMMyyyyHHmm(Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat("dd/MM/yyyy HH:mm").format(date);
    }

    public static String formatddMMyyyyHHmmss(Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat("dd/MM/yyyy HH:mm:ss").format(date);
    }

    public static String formatyyyyMM(LocalDate localDate) {
        if (localDate == null) {
            return "";
        }
        return localDate.format(DateTimeFormatter.ofPattern("yyyy/MM"));
    }

    public static String formatyyyyMM(YearMonth yearMonth) {
        if (yearMonth == null) {
            return "";
        }
        return yearMonth.format(DateTimeFormatter.ofPattern("yyyy/MM"));
    }

    public static String formatyyyyMMOnlyNumber(YearMonth yearMonth) {
        String result = DateUtils.formatyyyyMM(yearMonth);
        return NumberUtils.onlyNumber(result);
    }

    public static String formatyyyyMMOnlyNumber(LocalDate localDate) {
        String result = DateUtils.formatyyyyMM(localDate);
        return NumberUtils.onlyNumber(result);
    }

    public static String formatyyyyMMdd(LocalDate localDate) {
        if (localDate == null) {
            return "";
        }
        return localDate.format(DateTimeFormatter.ofPattern("yyyy/MM/dd"));
    }

    public static String formatyyyyMMddOnlyNumber(LocalDate localDate) {
        String result = DateUtils.formatyyyyMMdd(localDate);
        return NumberUtils.onlyNumber(result);
    }

    public static String formatHHmm(LocalTime localTime) {
        return localTime.format(DateTimeFormatter.ofPattern("HH:mm"));
    }

    public static String formatHHmmss(LocalTime localTime) {
        return localTime.format(DateTimeFormatter.ofPattern("HH:mm:ss"));
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(YearMonth yearMonth) {
        return DateUtils.toXMLGregorianCalendar(DateUtils.toDate(LocalDate.of(yearMonth.getYear(), yearMonth.getMonthValue(), 1)));
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(LocalDate localDate) {
        return DateUtils.toXMLGregorianCalendar(DateUtils.toDate(localDate));
    }

    public static Date toDate(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        return DateUtils.toDateStartOfDay(localDate);
    }

    public static Date toDateStartOfDay(LocalDate localDate) {
        Instant instant = localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(LocalDateTime localDate) {
        return DateUtils.toXMLGregorianCalendar(DateUtils.toDate(localDate));
    }

    public static XMLGregorianCalendar toXMLGregorianCalendar(Date date) {
        try {
            return DatatypeFactory.newInstance().newXMLGregorianCalendar(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(date));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static Date toDate(LocalDateTime localDateTime) {
        Instant instant = localDateTime.atZone(ZoneId.systemDefault()).toInstant();
        return Date.from(instant);
    }

    public static YearMonth toYearMonth(XMLGregorianCalendar xmlGregorianCalendar) {
        return YearMonth.from(xmlGregorianCalendar.toGregorianCalendar().toZonedDateTime().toLocalDateTime());
    }

    public static YearMonth toYearMonth(Date date) {
        return YearMonth.from(DateUtils.toLocalDate(date));
    }

    public static LocalDate toLocalDate(Date date) {
        Instant instant = Instant.ofEpochMilli(date.getTime());
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault()).toLocalDate();
    }

    public static YearMonth toYearMonth(LocalDate localDate) {
        return YearMonth.from(localDate);
    }

    public static YearMonth toYearMonth(LocalDateTime localDateTime) {
        return YearMonth.from(localDateTime);
    }

    public static LocalDateTime toLocalDateTimeFromOffSetDateTime(String dateTimeString) {
        OffsetDateTime offsetDateTime = OffsetDateTime.parse(dateTimeString, DateTimeFormatter.ISO_OFFSET_DATE_TIME);
        return offsetDateTime.toLocalDateTime();
    }

    public static String toDateTimeEventBpm(LocalDateTime localDateTime) {
        DateTimeFormatter formatter = DateTimeFormatter.ISO_DATE_TIME;
        return localDateTime.withNano(0).atOffset(ZoneOffset.UTC).format(formatter);
    }

    public static void validPeriod(LocalDate begin, LocalDate end, String message) {
        if (end == null) {
            return;
        }
        if (begin.isAfter(end)) {
            throw new IllegalArgumentException(message);
        }
        if (end.isBefore(begin)) {
            throw new IllegalArgumentException(message);
        }
    }
}

