/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> List<T> transform(Class<T> type, Collection<?> collection) {
        ArrayList<T> list = new ArrayList<T>();
        for (Object value : collection) {
            list.add(type.cast(value));
        }
        return list;
    }

    public static <T extends Collection<I>, I> T transform(T instance, Class<I> objectType, Collection<?> collection) {
        for (Object value : collection) {
            instance.add(objectType.cast(value));
        }
        return instance;
    }

    public static <T> T[] addItemArray(T[] arrayObj, T item) {
        int newSize = arrayObj.length + 1;
        T[] newItens = Arrays.copyOf(arrayObj, newSize);
        newItens[newSize - 1] = item;
        return newItens;
    }

    public static boolean isNullOrEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtils.isNullOrEmpty(collection);
    }

    public static <T> Collection<List<T>> breakList(List<T> list, Integer size) {
        AtomicInteger counter = new AtomicInteger();
        return list.stream().collect(Collectors.groupingBy(l -> counter.getAndIncrement() / size)).values();
    }

    public static <T> List<List<T>> generateBlocks(Collection<T> listaNfs, int blockSize) {
        ArrayList<List<T>> result = new ArrayList<List<T>>();
        ArrayList<T> actual = new ArrayList<T>();
        int count = 0;
        for (T item : listaNfs) {
            if (count >= blockSize) {
                result.add(new ArrayList(actual));
                actual = new ArrayList();
                count = 0;
            }
            actual.add(item);
            ++count;
        }
        if (CollectionUtils.isNotEmpty(actual)) {
            result.add(actual);
        }
        return result;
    }
}

