/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import br.com.jarch.util.LogUtils;
import br.com.jarch.util.NumberUtils;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class CharacterUtils {
    private static final char[] FIRST_CHAR = " !'#$%&'()*+\\-./0123456789:;<->?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\\]^_`abcdefghijklmnopqrstuvwxyz{|}~ E ,f'.++^%S<O Z  ''''.--~Ts>o ZY !C#$Y|$'(a<--(_o+23'u .,1o>113?AAAAAAACEEEEIIIIDNOOOOOXOUUUUyTsaaaaaaaceeeeiiiidnooooo/ouuuuyty".toCharArray();
    private static final char[] SECOND_CHAR = "  '         ,                                               \\                                   $  r'. + o  E      ''    M  e     #  =  'C.<  R .-..     ..>424     E E               E E     hs    e e         h     e e     h ".toCharArray();
    private static final String PT_BR = "pt-BR";

    public static String alignTextLeft(String text, int size) {
        return CharacterUtils.alignText(text, size, " ", Direction.LEFT);
    }

    public static String alignTextLeft(String texto, int tamanho, String letra) {
        return CharacterUtils.alignText(texto, tamanho, letra, Direction.LEFT);
    }

    public static String alignTextLeft(String texto, String letra, int tamanho) {
        return CharacterUtils.alignText(texto, tamanho, letra, Direction.LEFT);
    }

    public static String alignTextRigth(String texto, int tamanho) {
        return CharacterUtils.alignText(texto, tamanho, " ", Direction.RIGHT);
    }

    public static String alignTextRigth(String texto, int tamanho, String letra) {
        return CharacterUtils.alignText(texto, tamanho, letra, Direction.RIGHT);
    }

    private static String alignText(String value, int tamanho, String caracter, Direction direcao) {
        String texto = value;
        if (texto == null || "".equals(texto.trim())) {
            texto = "";
        }
        while (texto.contains("  ")) {
            texto = texto.replace("  ", " ").trim();
        }
        if ((texto = texto.replaceAll("[./-]", "")).length() > tamanho) {
            texto = texto.substring(0, tamanho);
        }
        StringBuilder sb = new StringBuilder(texto);
        if (direcao == Direction.LEFT) {
            for (int i = sb.length(); i < tamanho; ++i) {
                sb.append(caracter);
            }
        } else {
            for (int i = sb.length(); i < tamanho; ++i) {
                sb.insert(0, caracter);
            }
        }
        return sb.toString();
    }

    public static String removeChar(String value, String caracteres) {
        String texto = value;
        if (texto == null || "".equals(texto.trim())) {
            texto = "";
        }
        while (texto.contains("  ")) {
            texto = texto.replace("  ", " ").trim();
        }
        texto = texto.replaceAll("[" + caracteres + "]", "").trim();
        return texto;
    }

    public static String formatarIM(String value) {
        if (value == null) {
            return null;
        }
        return value.substring(0, value.length() - 1) + "-" + value.substring(value.length() - 1);
    }

    public static String onlyNumber(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder numbers = new StringBuilder();
        for (char ch : value.toCharArray()) {
            if (!Character.isDigit(ch)) continue;
            numbers.append(Character.toString(ch));
        }
        return numbers.toString();
    }

    public static String onlyNumberOrLetter(String value) {
        if (value == null) {
            return null;
        }
        StringBuilder numbers = new StringBuilder();
        for (char ch : value.toCharArray()) {
            if (!Character.isDigit(ch) && !Character.isAlphabetic(ch)) continue;
            numbers.append(ch);
        }
        return numbers.toString();
    }

    public static String firstWord(String value) {
        if (value == null) {
            return null;
        }
        String primeiraPalavra = value;
        int posicaoEspaco = primeiraPalavra.indexOf(32);
        if (posicaoEspaco > 0) {
            primeiraPalavra = primeiraPalavra.substring(0, posicaoEspaco);
        }
        return primeiraPalavra;
    }

    public static String lastWord(String value) {
        if (value == null) {
            return null;
        }
        String ultimaPalavra = value;
        int posicaoEspaco = ultimaPalavra.lastIndexOf(32);
        if (posicaoEspaco > 0) {
            ultimaPalavra = ultimaPalavra.substring(posicaoEspaco + 1);
        }
        return ultimaPalavra;
    }

    public static String formataLikeSql(String conteudo) {
        if (NumberUtils.containsOnlyNumber(conteudo)) {
            Long numero = Long.valueOf(conteudo);
            return numero.toString();
        }
        return conteudo.toLowerCase(Locale.forLanguageTag(PT_BR));
    }

    public static String removeCharEspecial(String str) {
        if (str == null) {
            return str;
        }
        char[] chars = str.toCharArray();
        StringBuilder ret = new StringBuilder(chars.length * 2);
        for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            if (aChar == ' ' || aChar == '\t') {
                ret.append(' ');
                continue;
            }
            if (aChar <= ' ' || aChar >= '\u0100') continue;
            if (FIRST_CHAR[aChar - 32] != ' ') {
                ret.append(FIRST_CHAR[aChar - 32]);
            }
            if (SECOND_CHAR[aChar - 32] == ' ') continue;
            ret.append(SECOND_CHAR[aChar - 32]);
        }
        return ret.toString();
    }

    public static String uTF8toISO(String str) {
        Charset utf8 = Charset.forName("UTF-8");
        Charset iso = Charset.forName("ISO-8859-1");
        ByteBuffer inputBuffer = ByteBuffer.wrap(str.getBytes());
        CharBuffer data = utf8.decode(inputBuffer);
        ByteBuffer outputBuffer = iso.encode(data);
        byte[] outputData = outputBuffer.array();
        return new String(outputData);
    }

    public static String iSOtoUTF8(String str) {
        Charset utf8charset = Charset.forName("UTF-8");
        Charset iso88591charset = Charset.forName("ISO-8859-1");
        ByteBuffer inputBuffer = ByteBuffer.wrap(str.getBytes());
        CharBuffer data = iso88591charset.decode(inputBuffer);
        ByteBuffer outputBuffer = utf8charset.encode(data);
        byte[] outputData = outputBuffer.array();
        return new String(outputData);
    }

    public static String firstCaracterLowerCase(String value) {
        return value.substring(0, 1).toLowerCase(Locale.forLanguageTag(PT_BR)).concat(value.substring(1));
    }

    public static String firstCaracterUpperCase(String value) {
        return value.substring(0, 1).toUpperCase(Locale.forLanguageTag(PT_BR)).concat(value.substring(1));
    }

    public static String removeHtmlTags(String value) {
        return value == null ? "" : value.replace("<br>", "\n").replace("<br />", "\n").replaceAll("\\<[^>]*>", "").trim();
    }

    public static String replicate(String value, int size) {
        return String.join((CharSequence)"", Collections.nCopies(size, value));
    }

    public static String replaceCharEspecial(String str, String newStr) {
        if (str == null) {
            return str;
        }
        char[] chars = str.toCharArray();
        StringBuilder ret = new StringBuilder(chars.length * 2);
        for (int i = 0; i < chars.length; ++i) {
            char aChar = chars[i];
            if (aChar == ' ' || aChar == '\t') {
                ret.append(' ');
                continue;
            }
            if (aChar <= ' ' || aChar >= '\u0100') continue;
            char letra = ' ';
            if (FIRST_CHAR[aChar - 32] != ' ') {
                letra = FIRST_CHAR[aChar - 32];
            }
            if (SECOND_CHAR[aChar - 32] != ' ') {
                letra = SECOND_CHAR[aChar - 32];
            }
            if (aChar == letra) {
                ret.append(letra);
                continue;
            }
            ret.append(newStr);
        }
        return ret.toString();
    }

    public static List<String> splitSize(String value, int splitSize) {
        ArrayList<String> parts = new ArrayList<String>();
        int length = value.length();
        for (int i = 0; i < length; i += splitSize) {
            parts.add(value.substring(i, Math.min(length, i + splitSize)));
        }
        return parts;
    }

    public static void main(String ... args) {
        LogUtils.warning(CharacterUtils.onlyNumber("123ABCabc..0.456789\u00e7.;,askfj"));
        LogUtils.warning("123ABCabc..0.456789\u00e7.;,askfj".toLowerCase(Locale.forLanguageTag(PT_BR)));
    }

    private static enum Direction {
        LEFT,
        RIGHT;

    }
}

