/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;

public final class ByteUtils {
    public static final int BLOCK_SIZE = 1024;

    private ByteUtils() {
    }

    public static byte[] toByteArray(File arquivo) {
        try {
            Path path = Paths.get(arquivo.getAbsolutePath(), new String[0]);
            return Files.readAllBytes(path);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] toByteArray(InputStream is) {
        try {
            int len;
            int size = 1024;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[size];
            while ((len = is.read(buf, 0, size)) != -1) {
                bos.write(buf, 0, len);
            }
            buf = bos.toByteArray();
            return buf;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

