/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.util;

import br.com.jarch.util.LogUtils;
import br.com.jarch.util.OperationSystemUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collection;

public final class BashUtils {
    private BashUtils() {
    }

    public static int execute(Collection<String> commands, OutputStream outputStream) {
        commands.forEach(LogUtils::generate);
        String comandFinal = String.join((CharSequence)" && ", commands);
        return BashUtils.executeCommands(comandFinal, outputStream);
    }

    public static int execute(String[] commands, OutputStream outputStream) {
        Arrays.stream(commands).forEach(LogUtils::generate);
        String comandFinal = String.join((CharSequence)" && ", commands);
        return BashUtils.executeCommands(comandFinal, outputStream);
    }

    private static int executeCommands(String commands, OutputStream outputStreamSsh) {
        try {
            String line;
            String cmdLine = OperationSystemUtils.isWindows() ? "cmd.exe" : "/bin/bash";
            String parameter = OperationSystemUtils.isWindows() ? "/c" : "-c";
            ProcessBuilder processBuilder = new ProcessBuilder(cmdLine, parameter, commands);
            Process process = processBuilder.start();
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            while ((line = reader.readLine()) != null) {
                BashUtils.addOutputStream(line, outputStreamSsh);
            }
            return process.waitFor();
        }
        catch (Exception ex) {
            LogUtils.generate(ex);
            BashUtils.addOutputStream(ex.getMessage(), outputStreamSsh);
            return -1;
        }
    }

    private static void addOutputStream(String value, OutputStream outputStreamSsh) {
        try {
            LogUtils.generate(value);
            String valueWithoutPassord = value.replaceAll("(?i)password[:\\s]+\\S+", "password **********").concat("\n");
            outputStreamSsh.write(valueWithoutPassord.getBytes());
        }
        catch (IOException e) {
            LogUtils.generate(e);
        }
    }
}

