/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.jpa.inspect;

import br.com.jarch.core.crud.repository.BaseRepository;
import br.com.jarch.core.model.IIdentity;
import jakarta.persistence.Column;
import jakarta.persistence.metamodel.Attribute;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

public class AnalyzeSqlRequest {
    private final BaseRepository<? extends IIdentity> repository;
    private final String sql;
    private final Collection<String> columnsRequiredFilter;

    private AnalyzeSqlRequest(Builder builder) {
        this.repository = builder.repository;
        this.sql = builder.sql;
        this.columnsRequiredFilter = builder.columnsRequiredFilter;
    }

    public BaseRepository<? extends IIdentity> getRepository() {
        return this.repository;
    }

    public String getSql() {
        return this.sql;
    }

    public Collection<String> getColumnsRequiredFilter() {
        return this.columnsRequiredFilter;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private BaseRepository<? extends IIdentity> repository;
        private String sql;
        private Collection<String> columnsRequiredFilter;

        public Builder repository(BaseRepository<? extends IIdentity> repository) {
            this.repository = repository;
            return this;
        }

        public Builder sql(String sql) {
            this.sql = sql;
            return this;
        }

        public Builder addColumnsRequiredFilter(Attribute<?, ?> attribute) {
            if (this.columnsRequiredFilter == null) {
                this.columnsRequiredFilter = new ArrayList<String>();
            }
            try {
                Field field = attribute.getDeclaringType().getJavaType().getDeclaredField(attribute.getName());
                Column column = field.getAnnotation(Column.class);
                String columnRequiredFilter = column == null || column.name().isEmpty() ? field.getName() : column.name();
                this.columnsRequiredFilter.add(columnRequiredFilter);
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            return this;
        }

        public AnalyzeSqlRequest build() {
            Objects.requireNonNull(this.repository, "repository \u00e9 obrigat\u00f3rio");
            Objects.requireNonNull(this.sql, "sql \u00e9 obrigat\u00f3rio");
            Objects.requireNonNull(this.columnsRequiredFilter, "columnsRequiredFilter \u00e9 obrigat\u00f3rio");
            return new AnalyzeSqlRequest(this);
        }
    }
}

