/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.communication;

import br.com.jarch.core.crud.communication.CommunicationAttachEntity;
import br.com.jarch.core.crud.communication.CommunicationRepository;
import br.com.jarch.util.LogUtils;
import jakarta.ejb.Stateless;
import jakarta.ejb.TransactionAttribute;
import jakarta.ejb.TransactionAttributeType;
import jakarta.enterprise.inject.spi.CDI;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.jboss.ejb3.annotation.TransactionTimeout;

@Stateless
@TransactionAttribute(value=TransactionAttributeType.NOT_SUPPORTED)
public class CommunicationDaoHelper {
    public static CommunicationDaoHelper getInstance() {
        return (CommunicationDaoHelper)CDI.current().select(CommunicationDaoHelper.class, new Annotation[0]).get();
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @TransactionTimeout(unit=TimeUnit.MINUTES, value=30L)
    public void saveAttachFromBytes(CommunicationAttachEntity communicationAttach, String fileName, byte[] bytes) {
        communicationAttach.setFileName(fileName);
        communicationAttach.setBinary(bytes);
        CommunicationRepository.getInstance().getEntityManager().merge((Object)communicationAttach);
    }

    @TransactionAttribute(value=TransactionAttributeType.REQUIRED)
    @TransactionTimeout(unit=TimeUnit.MINUTES, value=30L)
    public void saveAttachFromFile(CommunicationAttachEntity communicationAttach, String fileName, File file) {
        try {
            LogUtils.start();
            LogUtils.generate((String)("INICIO - Gravando Arquivo Banco Dados " + fileName));
            communicationAttach.setFileName(fileName);
            communicationAttach.setBinary(FileUtils.readFileToByteArray((File)file));
            CommunicationRepository.getInstance().getEntityManager().merge((Object)communicationAttach);
            LogUtils.end();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

