/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.batch;

import br.com.jarch.core.annotation.JArchOrderBy;
import br.com.jarch.core.annotation.JArchOrderByField;
import br.com.jarch.core.annotation.JArchSearchWhereJpa;
import br.com.jarch.core.annotation.JArchValidRequired;
import br.com.jarch.core.crud.batch.ExecutionEntity;
import br.com.jarch.core.crud.entity.CrudMultiTenantEntity;
import br.com.jarch.core.jpa.converter.LocalDateTimeJpaConverter;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.Index;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Size;
import java.time.LocalDateTime;
import org.hibernate.envers.Audited;

@Audited
@Table(name="tb_batch_execution_log", indexes={@Index(columnList="dh_time", name="dx_batchexecutionlogdhtim"), @Index(columnList="ds_information", name="dx_batchexecutionlogdsinf")})
@Entity(name="log")
@SequenceGenerator(name="LogIdSequence", sequenceName="sq_idbatchexecutionlog", allocationSize=1)
@JArchOrderBy(fields={@JArchOrderByField(value="id", desc=true)})
@JArchSearchWhereJpa(id="filterLastExecutionByCode", conditionWhereJpa="log.execution.id = :idExecution", active=false)
public class LogEntity
extends CrudMultiTenantEntity {
    public static final String FILTER_LAST_EXECUTION_BY_CODE = "filterLastExecutionByCode";
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="LogIdSequence")
    @Column(name="id_batchexecutionlog")
    private Long id;
    @ManyToOne
    @JoinColumn(name="id_batchexecution", nullable=false)
    private ExecutionEntity execution;
    @Column(name="dh_time", nullable=false)
    @Convert(converter=LocalDateTimeJpaConverter.class)
    @JArchValidRequired(value="label.timeLog")
    private LocalDateTime timeLog;
    @Column(name="ds_information", nullable=false, length=500)
    @JArchValidRequired(value="label.information")
    @Size(max=500, message="{message.maxSizeExceeded}")
    private @Size(max=500, message="{message.maxSizeExceeded}") String information;

    public LogEntity() {
    }

    public LogEntity(Long id, LocalDateTime timeLog, String information) {
        this.id = id;
        this.timeLog = timeLog;
        this.information = information;
    }

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }

    public ExecutionEntity getExecution() {
        return this.execution;
    }

    public void setExecution(ExecutionEntity execution) {
        this.execution = execution;
    }

    public LocalDateTime getTimeLog() {
        return this.timeLog;
    }

    public void setTimeLog(LocalDateTime timeLog) {
        this.timeLog = timeLog;
    }

    public String getInformation() {
        return this.information;
    }

    public void setInformation(String information) {
        this.information = information;
    }
}

