/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.model.type;

import br.com.jarch.core.util.BundleUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public enum ActionCrudType {
    INSERT("label.incluir"),
    CLONE("label.clonar"),
    CHANGE("label.alterar"),
    CONSULT("label.consultar"),
    DELETE("label.excluir"),
    PRINT("label.imprimir"),
    ACTIVE("label.ativar"),
    DEACTIVE("label.desativar"),
    DYNAMIC("label.acaoDinamica");

    private final String description;

    private ActionCrudType(String description) {
        this.description = description;
    }

    public String getDescription() {
        return BundleUtils.messageBundle(this.description);
    }

    public boolean isInsert() {
        return this == INSERT;
    }

    public boolean isClone() {
        return this == CLONE;
    }

    public boolean isChange() {
        return this == CHANGE;
    }

    public boolean isConsult() {
        return this == CONSULT;
    }

    public boolean isDelete() {
        return this == DELETE;
    }

    public boolean isDynamic() {
        return this == DYNAMIC;
    }

    public String getId() {
        return "actionCrud" + this.name();
    }

    public boolean isDefault() {
        return !this.equals((Object)DYNAMIC);
    }

    public static Collection<ActionCrudType> getCollection() {
        return Arrays.stream(ActionCrudType.values()).collect(Collectors.toList());
    }

    public static Collection<ActionCrudType> getCollectionAudit() {
        return List.of(INSERT, CHANGE, CONSULT, DELETE);
    }
}

