/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.model;

import br.com.jarch.core.cdi.GlobalInformation;
import java.io.Serializable;

public class ProgressInformation
implements Serializable {
    private int actual;
    private int size;
    private int percentual;
    private String status;

    private ProgressInformation() {
    }

    public static ProgressInformation getInstance() {
        ProgressInformation progress = (ProgressInformation)GlobalInformation.getInstance().get("jarch.progress");
        if (progress == null) {
            progress = new ProgressInformation();
            progress.saveGlobal();
        }
        return progress;
    }

    public static ProgressInformation newInstance() {
        return new ProgressInformation();
    }

    public int getActual() {
        return this.actual;
    }

    public ProgressInformation actual(int actual) {
        this.actual = actual;
        double result = (double)actual / (double)this.size * 100.0;
        this.percentual = (int)result;
        return this;
    }

    public int getSize() {
        return this.size;
    }

    public ProgressInformation size(int size) {
        this.size = size;
        return this;
    }

    public int getPercentual() {
        return this.percentual;
    }

    public ProgressInformation percentual(int percentual) {
        this.percentual = percentual;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public ProgressInformation status(String status) {
        this.status = status;
        return this;
    }

    public ProgressInformation reset() {
        this.status = "";
        this.percentual = 0;
        this.actual = 0;
        this.size = 0;
        return this;
    }

    public void start(int size) {
        this.percentual = 0;
        this.actual = 0;
        this.size = size;
    }

    public ProgressInformation increment() {
        return this.increment(1);
    }

    public ProgressInformation increment(int increment) {
        this.actual += increment;
        double result = (double)this.actual / (double)this.size * 100.0;
        this.percentual = (int)result;
        return this;
    }

    public ProgressInformation saveGlobal() {
        GlobalInformation.getInstance().set("jarch.progress", this);
        return this;
    }
}

