/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.migration;

import br.com.jarch.core.annotation.JArchIgnoreMigrate;
import br.com.jarch.core.exception.ValidationException;
import br.com.jarch.core.migration.CloneMigratedEntity;
import br.com.jarch.core.migration.Migrated;
import br.com.jarch.core.model.ICrudEntity;
import br.com.jarch.core.model.MultiTenant;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.ZipUtils;
import jakarta.enterprise.context.Dependent;
import jakarta.inject.Inject;
import jakarta.persistence.EntityManager;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;

@Dependent
public class MigrationService
implements Serializable {
    private File diretorioDefault = new File(System.getProperty("java.io.tmpdir") + File.separator + "migration");
    @Inject
    private EntityManager entityManager;

    public InputStream migraDados(List<Migrated> lista) throws IOException {
        for (Migrated migrated : lista) {
            File diretorio = this.criaEstruturaPasta(migrated);
            List<ICrudEntity> listaDados = migrated.getListSelected();
            int contador = 1;
            for (Object e : listaDados) {
                try {
                    FileOutputStream arquivo = new FileOutputStream(String.valueOf(diretorio.getAbsoluteFile()) + "/" + migrated.getNameClassEntity().toLowerCase() + "_" + contador++ + ".dat");
                    ObjectOutputStream objeto = new ObjectOutputStream(arquivo);
                    objeto.writeObject(e);
                    objeto.flush();
                    objeto.close();
                    arquivo.flush();
                    arquivo.close();
                }
                catch (IOException ex) {
                    LogUtils.generate((Throwable)ex);
                    throw new ValidationException(BundleUtils.messageBundle("message.erroNaSerializacao"));
                }
            }
        }
        if (!this.diretorioDefault.exists()) {
            throw new ValidationException(BundleUtils.messageBundle("message.diretorioInvalido"));
        }
        File arquivoTemporario = File.createTempFile("migracao", ".zip");
        arquivoTemporario.deleteOnExit();
        ZipUtils.zipPath((Path)Path.of(arquivoTemporario.getPath(), new String[0]), (Path)Path.of(this.diretorioDefault.getPath(), new String[0]));
        FileInputStream fileInputStream = new FileInputStream(arquivoTemporario);
        return fileInputStream;
    }

    public void restauraDados(List<Migrated> lista, File arquivoUpload) throws IOException {
        ZipUtils.decompress((File)arquivoUpload, (File)this.diretorioDefault);
        if (!this.diretorioDefault.exists()) {
            return;
        }
        for (Migrated migrated : lista) {
            for (File diretorio : this.diretorioDefault.listFiles()) {
                if (!migrated.getNameClassEntity().toLowerCase().equals(diretorio.getName())) continue;
                for (File arquivo : diretorio.listFiles()) {
                    try {
                        FileInputStream arquivoLeitura = new FileInputStream(arquivo);
                        ObjectInputStream objLeitura = new ObjectInputStream(arquivoLeitura);
                        ICrudEntity crudEntity = (ICrudEntity)objLeitura.readObject();
                        if (!migrated.getClassEntity().getClass().isAssignableFrom(crudEntity.getClass())) {
                            throw new ValidationException(BundleUtils.messageBundle("message.migracaoDeEntidadeInvalida"));
                        }
                        CloneMigratedEntity.clone(MultiTenant.getInstance().get(), migrated.getService(), migrated.getRepository(), crudEntity);
                        objLeitura.close();
                        arquivoLeitura.close();
                        arquivo.deleteOnExit();
                    }
                    catch (IOException | ClassNotFoundException ex) {
                        LogUtils.generate((Throwable)ex);
                    }
                }
            }
        }
    }

    private File criaEstruturaPasta(Migrated migrated) {
        try {
            File diretorio;
            if (!this.diretorioDefault.exists()) {
                this.diretorioDefault.mkdir();
            }
            if ((diretorio = new File(this.diretorioDefault.getAbsolutePath() + "/" + migrated.getNameClassEntity().toLowerCase())).exists()) {
                FileUtils.deleteDirectory((File)diretorio);
            }
            diretorio.mkdir();
            return diretorio;
        }
        catch (IOException e) {
            throw new ValidationException(BundleUtils.messageBundle("message.erroAoCriarEstruturaDePastas"));
        }
    }

    public List<Class> pesquisaEntidades() {
        ArrayList<Class> lista = new ArrayList<Class>();
        ArrayList listaRemover = new ArrayList();
        String dirPackageLib = "br.com.dsfnet.corporativo;_aud";
        this.entityManager.getMetamodel().getEntities().stream().filter(entity -> entity.getJavaType() != null && entity.getJavaType().getAnnotation(JArchIgnoreMigrate.class) == null && ICrudEntity.class.isAssignableFrom(entity.getJavaType()) && !Arrays.stream(dirPackageLib.split(";")).anyMatch(dir -> entity.getJavaType().getName().toLowerCase().contains((CharSequence)dir))).collect(Collectors.toList()).forEach(entityType -> lista.add(entityType.getJavaType()));
        for (Class clazz2 : lista) {
            for (Field field : clazz2.getDeclaredFields()) {
                Class<?> clazzField = null;
                Type type = null;
                if (ParameterizedType.class.isAssignableFrom(field.getGenericType().getClass())) {
                    ParameterizedType parameterizedType = (ParameterizedType)field.getGenericType();
                    type = parameterizedType.getActualTypeArguments()[0];
                    try {
                        clazzField = Class.forName(type.getTypeName());
                    }
                    catch (Exception exception) {}
                } else {
                    clazzField = field.getType();
                }
                if (clazzField.getName().equals(clazz2.getName())) continue;
                if (field.getAnnotation(ManyToOne.class) != null) {
                    listaRemover.add(clazz2);
                }
                if (field.getAnnotation(OneToMany.class) == null || type == null) continue;
                listaRemover.add(clazzField);
            }
        }
        lista.removeIf(clazz -> listaRemover.contains(clazz));
        return lista;
    }
}

