/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.jpa.api;

import br.com.jarch.core.jpa.api.RootJpql;
import br.com.jarch.core.model.IIdentity;
import br.com.jarch.core.type.EntityGraphType;
import br.com.jarch.core.util.JpaUtils;
import br.com.jarch.core.util.JpqlUtils;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class CollectorJpql<E extends IIdentity> {
    RootJpql<E> rootJpql;

    CollectorJpql(RootJpql<E> rootJpql) {
        this.rootJpql = rootJpql;
    }

    public Long count() {
        return (Long)this.getQueryCount().getSingleResult();
    }

    public boolean exists() {
        return this.count() > 0L;
    }

    public List<E> list() {
        if (this.rootJpql.selects.isEmpty()) {
            return this.getQuerySelect(this.alias(), this.classEntity()).getResultList();
        }
        return this.getQuerySelect(this.rootJpql.selects, this.classEntity()).getResultList();
    }

    public Set<E> set() {
        return new HashSet<E>(this.list());
    }

    public <T> List<T> list(Class<T> clazz) {
        TypedQuery<T> query = this.getQuerySelectGroup(clazz);
        try {
            return query.getResultList();
        }
        catch (IllegalArgumentException iae) {
            if (iae.getMessage().contains("from tuple")) {
                return List.of();
            }
            throw iae;
        }
    }

    public <T> Set<T> set(Class<T> clazz) {
        return new HashSet<T>(this.list(clazz));
    }

    public List<Object[]> listArrayObject() {
        return this.getQuerySelect(String.join((CharSequence)", ", this.rootJpql.selects), Object[].class).getResultList();
    }

    public E single() {
        return (E)((IIdentity)this.getQuerySelect(this.alias(), this.classEntity()).getSingleResult());
    }

    public <T> T single(Class<T> clazz) {
        TypedQuery<T> querySelect = this.getQuerySelect("new " + clazz.getName() + "(" + String.join((CharSequence)", ", this.rootJpql.selects) + ")", clazz);
        return (T)querySelect.getSingleResult();
    }

    public Object[] arrayObject() {
        if (this.rootJpql.selects.size() < 2) {
            return new Object[]{this.getQuerySelect(String.join((CharSequence)", ", this.rootJpql.selects), Object.class).getSingleResult()};
        }
        return (Object[])this.getQuerySelect(String.join((CharSequence)", ", this.rootJpql.selects), Object[].class).getSingleResult();
    }

    public Optional<E> any() {
        try {
            return this.list().stream().findAny();
        }
        catch (NoResultException | NonUniqueResultException ex) {
            return Optional.empty();
        }
    }

    public <T> Optional<T> any(Class<T> clazz) {
        try {
            return this.list(clazz).stream().findAny();
        }
        catch (NoResultException | NonUniqueResultException ex) {
            return Optional.empty();
        }
    }

    private TypedQuery<Long> getQueryCount() {
        Object jpql = "SELECT COUNT(" + (this.rootJpql.distinct ? "DISTINCT " : "") + JpqlUtils.aliasEntity(this.classEntity()) + ") ";
        jpql = (String)jpql + JpqlUtils.from(this.classEntity(), this.rootJpql.joinFetchs) + " ";
        jpql = ((String)jpql).replace("JOIN FETCH", "JOIN");
        jpql = (String)jpql + JpqlUtils.where(this.classEntity(), this.rootJpql.wheres, this.rootJpql.joinFetchs);
        TypedQuery query = this.rootJpql.getEntityManager().createQuery((String)jpql, Long.class);
        this.setConfiguration(query);
        JpqlUtils.addValueParam((Query)query, this.rootJpql.wheres);
        if (this.rootJpql.lockMode != null) {
            query.setLockMode(this.rootJpql.lockMode);
        }
        return query;
    }

    private <T> TypedQuery<T> getQuerySelect(List<String> fields, Class<T> classReturn) {
        String fieldsSelect = fields.stream().map(f -> JpqlUtils.aliasEntity(this.classEntity()) + "." + f).collect(Collectors.joining(", "));
        String jpql = "SELECT NEW " + classReturn.getName() + "(" + (this.rootJpql.distinct ? "DISTINCT " : "") + fieldsSelect + ") ";
        jpql = jpql + JpqlUtils.from(this.classEntity(), this.rootJpql.joinFetchs) + " ";
        jpql = jpql + JpqlUtils.where(this.classEntity(), this.rootJpql.wheres, this.rootJpql.joinFetchs) + " ";
        jpql = jpql + JpqlUtils.orderBy(this.classEntity(), this.rootJpql.orderBys);
        TypedQuery query = this.rootJpql.getEntityManager().createQuery(jpql, classReturn);
        this.setConfiguration(query);
        JpqlUtils.addValueParam((Query)query, this.rootJpql.wheres);
        if (this.rootJpql.lockMode != null) {
            query.setLockMode(this.rootJpql.lockMode);
        }
        return query;
    }

    private <T> TypedQuery<T> getQuerySelect(String paramsSelect, Class<T> classReturn) {
        String jpql = "SELECT " + (this.rootJpql.distinct ? "DISTINCT " : "") + paramsSelect + " ";
        jpql = jpql + JpqlUtils.from(this.classEntity(), this.rootJpql.joinFetchs) + " ";
        jpql = jpql + JpqlUtils.where(this.classEntity(), this.rootJpql.wheres, this.rootJpql.joinFetchs) + " ";
        jpql = jpql + JpqlUtils.orderBy(this.classEntity(), this.rootJpql.orderBys);
        TypedQuery query = this.rootJpql.getEntityManager().createQuery(jpql, classReturn);
        this.setConfiguration(query);
        JpqlUtils.addValueParam((Query)query, this.rootJpql.wheres);
        if (this.rootJpql.lockMode != null) {
            query.setLockMode(this.rootJpql.lockMode);
        }
        return query;
    }

    private <T> TypedQuery<T> getQuerySelectGroup(Class<T> classReturn) {
        String jpql = "SELECT new " + classReturn.getName() + "(" + String.join((CharSequence)", ", this.rootJpql.selects) + ") ";
        jpql = jpql + JpqlUtils.from(this.classEntity(), this.rootJpql.joinFetchs) + " ";
        jpql = jpql + JpqlUtils.where(this.classEntity(), this.rootJpql.wheres, this.rootJpql.joinFetchs) + " ";
        jpql = jpql + JpqlUtils.groupBy(this.rootJpql.groupBys) + " ";
        jpql = jpql + JpqlUtils.having(this.classEntity(), this.rootJpql.havings, this.rootJpql.joinFetchs) + " ";
        jpql = jpql + JpqlUtils.orderBy(this.classEntity(), this.rootJpql.orderBys);
        TypedQuery query = this.rootJpql.getEntityManager().createQuery(jpql, classReturn);
        this.setConfiguration(query);
        JpqlUtils.addValueParam((Query)query, this.rootJpql.wheres);
        JpqlUtils.addValueParam((Query)query, this.rootJpql.havings);
        if (this.rootJpql.lockMode != null) {
            query.setLockMode(this.rootJpql.lockMode);
        }
        return query;
    }

    private String alias() {
        return JpqlUtils.aliasEntity(this.classEntity());
    }

    private Class<E> classEntity() {
        return this.rootJpql.classEntity;
    }

    private void setConfiguration(TypedQuery<?> typedQuery) {
        if (this.rootJpql.entityGraph != null && !this.rootJpql.entityGraph.isEmpty()) {
            if (this.rootJpql.graphType == null || EntityGraphType.FETCH.equals((Object)this.rootJpql.graphType)) {
                typedQuery.setHint("javax.persistence.fetchgraph", (Object)this.rootJpql.getEntityManager().getEntityGraph(this.rootJpql.entityGraph));
            } else {
                typedQuery.setHint("javax.persistence.loadgraph", (Object)this.rootJpql.getEntityManager().getEntityGraph(this.rootJpql.entityGraph));
            }
        }
        if (this.rootJpql.cacheable || JpaUtils.cached(this.rootJpql.classEntity)) {
            typedQuery = JpaUtils.forceCache(typedQuery);
        }
        if (this.rootJpql.firstResult > 0) {
            typedQuery = typedQuery.setFirstResult(this.rootJpql.firstResult);
        }
        if (this.rootJpql.maxResults > 0) {
            typedQuery.setMaxResults(this.rootJpql.maxResults);
        }
    }
}

