/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.util;

import br.com.jarch.core.annotation.JArchColumnDataTable;
import br.com.jarch.core.annotation.JArchSearchField;
import br.com.jarch.core.annotation.JArchValidCep;
import br.com.jarch.core.annotation.JArchValidCnpj;
import br.com.jarch.core.annotation.JArchValidCnpjBase;
import br.com.jarch.core.annotation.JArchValidCpf;
import br.com.jarch.core.annotation.JArchValidCpfCnpj;
import br.com.jarch.core.model.ICrudEntity;
import br.com.jarch.core.type.FieldType;
import br.com.jarch.core.util.JpaUtils;
import br.com.jarch.util.CharacterUtils;
import br.com.jarch.util.ReflectionUtils;
import jakarta.persistence.Embedded;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;

public final class RemoveMasksUtils {
    public static void removeMaskAllFields(Object entity) {
        if (entity == null) {
            return;
        }
        for (Field field : entity.getClass().getDeclaredFields()) {
            RemoveMasksUtils.removeMaskCollection(entity, field);
            RemoveMasksUtils.removeMaskCep(entity, field);
            RemoveMasksUtils.removeMaskCpf(entity, field);
            RemoveMasksUtils.removeMaskCpfCnpjBase(entity, field);
            RemoveMasksUtils.removeMaskCnpj(entity, field);
            RemoveMasksUtils.removeMaskCpfCnpj(entity, field);
            RemoveMasksUtils.removeMaskColumnDataTable(entity, field);
            RemoveMasksUtils.removeMaskFieldSearch(entity, field);
            RemoveMasksUtils.removeMaskEmbeddable(entity, field);
        }
    }

    private static void removeMaskEmbeddable(Object entidade, Field field) {
        if (!field.isAnnotationPresent(Embedded.class)) {
            return;
        }
        RemoveMasksUtils.removeMaskAllFields(ReflectionUtils.getValueByField((Object)entidade, (Field)field));
    }

    private static void removeMaskCnpj(Object entidade, Field field) {
        if (!field.isAnnotationPresent(JArchValidCnpj.class)) {
            return;
        }
        RemoveMasksUtils.removeMasks(entidade, field);
    }

    private static void removeMaskCpfCnpj(Object entidade, Field field) {
        if (!field.isAnnotationPresent(JArchValidCpfCnpj.class)) {
            return;
        }
        RemoveMasksUtils.removeMasks(entidade, field);
    }

    private static void removeMaskCpfCnpjBase(Object entidade, Field field) {
        if (!field.isAnnotationPresent(JArchValidCnpjBase.class)) {
            return;
        }
        RemoveMasksUtils.removeMasks(entidade, field);
    }

    private static void removeMaskColumnDataTable(Object entidade, Field field) {
        Arrays.stream((JArchColumnDataTable[])field.getAnnotationsByType(JArchColumnDataTable.class)).filter(c -> RemoveMasksUtils.haveMask(c.type())).findAny().ifPresent(c -> RemoveMasksUtils.removeMasks(entidade, field));
    }

    private static void removeMaskCpf(Object entidade, Field field) {
        if (!field.isAnnotationPresent(JArchValidCpf.class)) {
            return;
        }
        RemoveMasksUtils.removeMasks(entidade, field);
    }

    private static void removeMaskCep(Object entidade, Field field) {
        if (!field.isAnnotationPresent(JArchValidCep.class)) {
            return;
        }
        RemoveMasksUtils.removeMasks(entidade, field);
    }

    private static void removeMaskCollection(Object entidade, Field field) {
        if (!ReflectionUtils.isCollection((Field)field)) {
            return;
        }
        Class classeGenericoColletion = ReflectionUtils.getGenericClass((Field)field, (int)0);
        if (!ICrudEntity.class.isAssignableFrom(classeGenericoColletion) || !JpaUtils.isObjectInitialize(entidade, field)) {
            return;
        }
        Collection listaEntidades = (Collection)ReflectionUtils.getValueByField((Object)entidade, (Field)field);
        if (listaEntidades == null) {
            return;
        }
        listaEntidades.stream().forEach(RemoveMasksUtils::removeMaskAllFields);
    }

    private static void removeMaskFieldSearch(Object entidade, Field field) {
        Arrays.stream((JArchSearchField[])field.getAnnotationsByType(JArchSearchField.class)).filter(c -> RemoveMasksUtils.haveMask(c.type())).findAny().ifPresent(c -> RemoveMasksUtils.removeMasks(entidade, field));
    }

    private static boolean haveMask(FieldType tipo) {
        return tipo == FieldType.CPF || tipo == FieldType.CNPJ || tipo == FieldType.CNPJ_BASE || tipo == FieldType.CEP;
    }

    private static void removeMasks(Object entidade, Field field) {
        if (field.getType() != String.class) {
            return;
        }
        Object conteudo = ReflectionUtils.getValueByField((Object)entidade, (Field)field);
        if (conteudo == null) {
            return;
        }
        String conteudoString = CharacterUtils.onlyNumber((String)((String)conteudo));
        ReflectionUtils.setValue((Object)entidade, (Field)field, (Object)conteudoString);
    }
}

