/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.listener;

import br.com.jarch.core.annotation.JArchExclusionLogic;
import br.com.jarch.core.exception.DeleteException;
import br.com.jarch.core.model.ICrudEntity;
import br.com.jarch.core.util.BundleUtils;
import br.com.jarch.core.util.JpaUtils;
import br.com.jarch.core.util.JpqlUtils;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.persistence.EntityManager;
import jakarta.persistence.metamodel.Attribute;
import jakarta.persistence.metamodel.EntityType;
import jakarta.transaction.Transactional;
import java.util.List;
import java.util.stream.Collectors;

@ApplicationScoped
public class VerifyRelationship {
    @Transactional(value=Transactional.TxType.NOT_SUPPORTED)
    public void verify(EntityManager entityManager, ICrudEntity entityDelete) {
        if (this.isOrphanAccepted(entityDelete.getClass())) {
            return;
        }
        List<EntityType<?>> entitysType = this.filterEntities(entityManager, entityDelete);
        for (EntityType<?> entityType : entitysType) {
            if (this.isOrphanAccepted(entityType.getJavaType())) continue;
            String labelEntityVinculo = this.adjustLabel(entityType.getName());
            String labelEntityDelete = this.adjustLabel(entityDelete.getClass().getSimpleName());
            throw new DeleteException(BundleUtils.messageBundleParam("message.registroComVinculoEncontradoEm", BundleUtils.messageBundle("label." + labelEntityDelete), BundleUtils.messageBundle("label." + labelEntityVinculo)));
        }
    }

    private List<EntityType<?>> filterEntities(EntityManager entityManager, ICrudEntity entityDelete) {
        return entityManager.getMetamodel().getEntities().stream().filter(e -> this.isRelationshipPresent(entityDelete.getClass(), (EntityType<?>)e)).collect(Collectors.toSet()).stream().filter(e -> this.isRegisterExisting(entityManager, entityDelete, (EntityType<?>)e)).collect(Collectors.toUnmodifiableList());
    }

    private boolean isRegisterExisting(EntityManager entityManager, ICrudEntity entityDelete, EntityType<?> e) {
        return e.getAttributes().stream().anyMatch(a -> a.getJavaType().equals(entityDelete.getClass()) && this.existsRegister(entityManager, entityDelete, e.getJavaType(), (Attribute<?, ?>)a));
    }

    private boolean isRelationshipPresent(Class<?> classDelete, EntityType<?> entityRelation) {
        return entityRelation.getAttributes().stream().anyMatch(a -> a.getJavaType().equals(classDelete)) && !JpaUtils.isOneToManyAndCascadeRemove(classDelete, entityRelation.getJavaType()) && !JpaUtils.isOneToOneAndCascadeRemove(classDelete, entityRelation.getJavaType()) && !JpaUtils.isOneToOneAndMappedBy(classDelete, entityRelation.getJavaType()) && !JpaUtils.isOneToOneAndOrphanRemoval(classDelete, entityRelation.getJavaType());
    }

    private boolean isOrphanAccepted(Class<?> classEntity) {
        JArchExclusionLogic exclusionLogicAnnotation = classEntity.getAnnotation(JArchExclusionLogic.class);
        return exclusionLogicAnnotation != null && exclusionLogicAnnotation.orphanAccepted();
    }

    private boolean existsRegister(EntityManager entityManager, ICrudEntity entityDelete, Class<?> classAnotherEntity, Attribute<?, ?> a) {
        if (this.isOrphanAccepted(classAnotherEntity)) {
            return false;
        }
        String jpql = this.buildJpqlQuery(classAnotherEntity, a);
        return (Long)entityManager.createQuery(jpql, Long.class).setParameter("id", (Object)entityDelete.getId()).getSingleResult() > 0L;
    }

    private String buildJpqlQuery(Class<?> classAnotherEntity, Attribute<?, ?> a) {
        String jpql = "SELECT COUNT(a) FROM " + JpqlUtils.aliasEntity(classAnotherEntity) + " a WHERE a." + a.getName() + ".id = :id";
        if (this.isOrphanAccepted(classAnotherEntity)) {
            jpql = jpql + " AND a.dateHourLogicExclusion IS NULL";
        }
        return jpql;
    }

    private String adjustLabel(String label) {
        label = label.endsWith("Entity") ? label.substring(0, label.indexOf("Entity")) : label;
        return label.substring(0, 1).toLowerCase().concat(label.substring(1));
    }
}

