/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.batch;

import br.com.jarch.core.annotation.JArchJpaRepository;
import br.com.jarch.core.crud.batch.BatchEntity;
import br.com.jarch.core.crud.batch.BatchEntity_;
import br.com.jarch.core.crud.batch.ExecutionEntity;
import br.com.jarch.core.crud.batch.ExecutionEntity_;
import br.com.jarch.core.crud.batch.ExecutionRepository;
import br.com.jarch.core.crud.jparepository.CrudJpaRepository;
import br.com.jarch.util.LogUtils;
import jakarta.transaction.Transactional;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;

@JArchJpaRepository
public class ExecutionJpaRepository
extends CrudJpaRepository<ExecutionEntity>
implements ExecutionRepository {
    @Override
    @Transactional
    public void markErrorWithoutEnd(String codeBatch) {
        List<ExecutionEntity> executions = this.getClientJpql().where().equalsTo(ExecutionEntity_.batch, BatchEntity_.code, codeBatch).and().isNull(ExecutionEntity_.endTime).collect().list();
        for (ExecutionEntity execution : executions) {
            LogUtils.generate((String)("JOB NAO FINALIZADO - MARCANDO EXECUCAO COMO ERRO ID: " + execution.getId()));
            execution.setSuccess(false);
            execution.setEndTime(LocalDateTime.now());
            this.change(execution);
        }
    }

    @Override
    public Optional<ExecutionEntity> searchLast(BatchEntity batch) {
        return this.getClientJpql().where().equalsTo(ExecutionEntity_.batch, batch).and().jpql("NOT EXISTS(FROM execution e2 WHERE e2 > execution)").collect().any();
    }
}

