/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.crud.batch;

import br.com.jarch.core.annotation.JArchJpaRepository;
import br.com.jarch.core.crud.batch.BatchEntity;
import br.com.jarch.core.crud.batch.BatchEntity_;
import br.com.jarch.core.crud.batch.BatchRepository;
import br.com.jarch.core.crud.batch.ExecutionEntity;
import br.com.jarch.core.crud.batch.ExecutionEntity_;
import br.com.jarch.core.crud.batch.ExecutionJpqlBuilder;
import br.com.jarch.core.crud.batch.ExecutionRepository;
import br.com.jarch.core.crud.batch.LogService;
import br.com.jarch.core.crud.jparepository.CrudJpaRepository;
import jakarta.persistence.metamodel.Attribute;
import jakarta.transaction.Transactional;
import java.time.LocalDateTime;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

@JArchJpaRepository
public class BatchJpaRepository
extends CrudJpaRepository<BatchEntity>
implements BatchRepository {
    @Override
    public Optional<BatchEntity> searchBy(String code, String name) {
        return this.getClientJpql().where().equalsTo(BatchEntity_.code, code).and().equalsTo(BatchEntity_.name, name).collect().any();
    }

    @Override
    @Transactional
    public void deleteAllBefore(LocalDateTime beforeThan) {
        List<ExecutionEntity> executions = ExecutionJpqlBuilder.newInstance().setMaxResults(1000).where().lessThan(ExecutionEntity_.startTime, beforeThan).orderByAsc((Attribute<ExecutionEntity, ?>)ExecutionEntity_.id).collect().list();
        for (ExecutionEntity execution : executions) {
            LogService.getInstance().addLog("DELETE LOG BY EXECUTION ID: " + execution.getId());
            this.getEntityManager().createQuery("DELETE FROM log b WHERE b.execution = :execution").setParameter("execution", (Object)execution).executeUpdate();
            LogService.getInstance().addLog("DELETE EXECUTION ID: " + execution.getId());
            ExecutionRepository.getInstance().delete(execution);
        }
        Collection batchs = BatchRepository.getInstance().searchAll();
        for (BatchEntity batch : batchs) {
            LogService.getInstance().addLog("ANALYSE BATCH ID: " + batch.getId());
            boolean existsExecution = ExecutionRepository.getInstance().existsBy(ExecutionEntity_.batch, batch);
            if (existsExecution) continue;
            LogService.getInstance().addLog("DELETE BATCH: " + batch.getId());
            this.delete(batch);
        }
    }
}

