/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.annotation.constraint;

import br.com.jarch.core.annotation.JArchValidRequiredOneOfManyField;
import br.com.jarch.core.exception.ValidationException;
import br.com.jarch.core.util.BeanValidationUtils;
import br.com.jarch.core.util.BundleUtils;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.beanutils.BeanUtils;

public class RequiredOneOfManyFieldConstraint
implements ConstraintValidator<JArchValidRequiredOneOfManyField, Object> {
    private JArchValidRequiredOneOfManyField annotation;

    public void initialize(JArchValidRequiredOneOfManyField value) {
        this.annotation = value;
    }

    public boolean isValid(Object value, ConstraintValidatorContext constraintValidatorContext) {
        String mensagemFinal = this.getMessageConstraint();
        constraintValidatorContext.disableDefaultConstraintViolation();
        constraintValidatorContext.buildConstraintViolationWithTemplate(mensagemFinal).addConstraintViolation();
        boolean valid = false;
        for (int i = 0; i < this.annotation.fields().length; ++i) {
            try {
                String valueAtual = BeanUtils.getProperty((Object)value, (String)this.annotation.fields()[i]);
                if (valueAtual == null) continue;
                boolean bl = valid = !value.toString().isBlank();
                if (!valid) continue;
                break;
            }
            catch (Exception e) {
                throw new ValidationException(e.getMessage(), e);
            }
        }
        if (!valid) {
            String mensagem = constraintValidatorContext.getDefaultConstraintMessageTemplate();
            for (String field : this.annotation.fields()) {
                constraintValidatorContext.buildConstraintViolationWithTemplate(mensagem).addPropertyNode(field);
            }
        }
        return valid;
    }

    private String getMessageConstraint() {
        String mensagem;
        String string = mensagem = this.annotation.message().isEmpty() ? "{message.required}" : this.annotation.message();
        if (!mensagem.contains("message.required")) {
            return mensagem;
        }
        mensagem = BeanValidationUtils.messageBundle(mensagem);
        return Arrays.stream(this.annotation.fields()).map(s -> BundleUtils.messageBundle("label." + s)).collect(Collectors.joining(" ou ")) + ": " + mensagem;
    }
}

