/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.core.annotation.constraint;

import br.com.jarch.core.annotation.JArchValidPeriod;
import br.com.jarch.util.ReflectionUtils;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.time.YearMonth;
import java.time.chrono.ChronoLocalDate;
import java.util.Date;

public class PeriodConstraint
implements ConstraintValidator<JArchValidPeriod, Object> {
    private JArchValidPeriod annotation;
    private Object periodBegin;
    private Object perdiodEnd;

    public void initialize(JArchValidPeriod value) {
        this.annotation = value;
    }

    public boolean isValid(Object value, ConstraintValidatorContext constraintValidatorContext) {
        this.periodBegin = ReflectionUtils.getValueByName((Object)value, (String)this.annotation.fieldBegin());
        this.perdiodEnd = ReflectionUtils.getValueByName((Object)value, (String)this.annotation.fieldEnd());
        if (this.periodBegin == null || this.perdiodEnd == null) {
            return true;
        }
        if (Date.class.isAssignableFrom(this.periodBegin.getClass())) {
            return this.validDate();
        }
        if (ChronoLocalDate.class.isAssignableFrom(this.periodBegin.getClass())) {
            return this.validLocalDate();
        }
        if (YearMonth.class.isAssignableFrom(this.periodBegin.getClass())) {
            return this.validYearMonth();
        }
        return false;
    }

    private boolean validYearMonth() {
        YearMonth yearMonthBegin = (YearMonth)this.periodBegin;
        YearMonth yearMonthEnd = (YearMonth)this.perdiodEnd;
        return yearMonthBegin.isBefore(yearMonthEnd);
    }

    private boolean validLocalDate() {
        ChronoLocalDate dateBegin = (ChronoLocalDate)this.periodBegin;
        ChronoLocalDate dateEnd = (ChronoLocalDate)this.perdiodEnd;
        return dateBegin.isBefore(dateEnd);
    }

    private boolean validDate() {
        Date dateBegin = (Date)this.periodBegin;
        Date dateEnd = (Date)this.perdiodEnd;
        return dateBegin.before(dateEnd);
    }
}

