/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.generate;

import br.com.jarch.apt.generate.BynaryFile;
import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchGenerateCrud;
import br.com.jarch.core.type.FieldType;
import br.com.jarch.util.FileUtils;
import br.com.jarch.util.LogUtils;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.lang.model.element.Element;

public final class DataControllerCodeGenerate {
    private final Element element;
    private final JArchGenerateCrud generateCrud;
    private final File fileDataController;
    private final String namePackage;
    private final String nomeSemCaracterEspecial;
    private final String nomeSemCaracterEspecialMinusculo;
    private final Set<String> dataDetails = new HashSet<String>();
    private final Set<BynaryFile> binarys = new HashSet<BynaryFile>();

    private DataControllerCodeGenerate(Element element, JArchGenerateCrud generateCrud) {
        this.element = element;
        this.generateCrud = generateCrud;
        this.nomeSemCaracterEspecial = ProcessorUtils.getNameWithoutCharEspecialCapitalize(generateCrud.master().name());
        this.nomeSemCaracterEspecialMinusculo = ProcessorUtils.getNameWithoutCharEspecialStartLowerCase(generateCrud.master().name());
        File folder = new File(ProcessorUtils.getPathSource(element, generateCrud.nameSubPackage()).replace("-client", "-web").replace(File.separator + "client" + File.separator, File.separator + "web" + File.separator));
        if (!folder.exists()) {
            folder.mkdirs();
        }
        this.fileDataController = new File(folder.getAbsolutePath(), this.nomeSemCaracterEspecial + "DataController.java");
        this.namePackage = ProcessorUtils.getPackage(element, generateCrud.nameSubPackage()).replace(".client.", ".web.");
    }

    public static void generate(Element element, JArchGenerateCrud generateCrud) {
        new DataControllerCodeGenerate(element, generateCrud).generate();
    }

    private void generate() {
        if (ProcessorUtils.isFileExistsClientOrWebOrWs(this.fileDataController)) {
            return;
        }
        Arrays.stream(this.generateCrud.master().details()).forEach(d -> {
            this.dataDetails.add(ProcessorUtils.getNameWithoutCharEspecialCapitalize(d.name()));
            Arrays.stream(d.subDetails()).forEach(sd -> this.dataDetails.add(ProcessorUtils.getNameWithoutCharEspecialCapitalize(sd.name())));
        });
        Arrays.stream(this.generateCrud.master().fields()).filter(field -> FieldType.BINARY.equals((Object)field.type())).forEach(field -> this.binarys.add(new BynaryFile(this.generateCrud.master().name(), field.fieldName(), true)));
        Arrays.stream(this.generateCrud.master().details()).forEach(detail -> {
            Arrays.stream(detail.fields()).filter(field -> FieldType.BINARY.equals((Object)field.type())).forEach(field -> this.binarys.add(new BynaryFile(detail.name(), field.fieldName(), false)));
            Arrays.stream(detail.subDetails()).forEach(subDetail -> Arrays.stream(subDetail.fields()).filter(field -> FieldType.BINARY.equals((Object)field.type())).forEach(field -> this.binarys.add(new BynaryFile(subDetail.name(), field.fieldName(), false))));
        });
        this.create();
    }

    private void create() {
        StringBuilder sbListController = new StringBuilder();
        ProcessorUtils.addCode(sbListController, "package " + this.namePackage + ";");
        ProcessorUtils.addLineBlank(sbListController);
        ProcessorUtils.addCode(sbListController, "import br.com.jarch.core.annotation.JArchDataController;");
        ProcessorUtils.addCode(sbListController, "import br.com.jarch.faces.controller.CrudDataController;");
        if (!this.dataDetails.isEmpty()) {
            ProcessorUtils.addCode(sbListController, "import br.com.jarch.faces.controller.CrudDataDetail;");
            ProcessorUtils.addCode(sbListController, "import jakarta.inject.Inject;");
        }
        if (!this.binarys.isEmpty()) {
            ProcessorUtils.addCode(sbListController, "import org.primefaces.event.FileUploadEvent;");
            ProcessorUtils.addCode(sbListController, "import org.primefaces.model.file.UploadedFile;");
        }
        if (this.namePackage.contains(".web.")) {
            ProcessorUtils.addCode(sbListController, "import " + this.namePackage.replace(".web.", ".client.") + "." + this.nomeSemCaracterEspecial + "Entity;");
            ProcessorUtils.addCode(sbListController, "import " + this.namePackage.replace(".web.", ".client.") + "." + this.nomeSemCaracterEspecial + "CrudService;");
            ProcessorUtils.addCode(sbListController, "import " + this.namePackage.replace(".web.", ".client.") + "." + this.nomeSemCaracterEspecial + "Repository;");
            this.dataDetails.forEach(d -> ProcessorUtils.addCode(sbListController, "import " + this.namePackage.replace(".web.", ".client.") + "." + d + "Entity;"));
        }
        ProcessorUtils.addLineBlank(sbListController);
        ProcessorUtils.addCode(sbListController, "@JArchDataController");
        ProcessorUtils.addCode(sbListController, "public class " + this.nomeSemCaracterEspecial + "DataController extends CrudDataController<" + this.nomeSemCaracterEspecial + "Entity, " + this.nomeSemCaracterEspecial + "CrudService, " + this.nomeSemCaracterEspecial + "Repository> {");
        ProcessorUtils.addLineBlank(sbListController);
        this.dataDetails.forEach(d -> ProcessorUtils.addCode(sbListController, "\t@Inject \n\tprivate CrudDataDetail<" + d + "Entity> dataDetail" + d + ";\n"));
        this.binarys.forEach(b -> ProcessorUtils.addCode(sbListController, b.getFieldInject()));
        ProcessorUtils.addCode(sbListController, "\t@Override");
        ProcessorUtils.addCode(sbListController, "\tpublic String getPageList() {");
        ProcessorUtils.addCode(sbListController, "\t\treturn \"" + this.nomeSemCaracterEspecialMinusculo + "List.jsf\";");
        ProcessorUtils.addCode(sbListController, "\t}");
        ProcessorUtils.addLineBlank(sbListController);
        this.dataDetails.forEach(d -> ProcessorUtils.addCode(sbListController, "\tpublic CrudDataDetail<" + d + "Entity> getDataDetail" + d + "() {\n\t\treturn dataDetail" + d + ";\n\t}\n"));
        this.binarys.forEach(b -> ProcessorUtils.addCode(sbListController, b.getMethodGetterSetter()));
        ProcessorUtils.addCode(sbListController, "}");
        try {
            FileUtils.save((File)this.fileDataController, (String)sbListController.toString());
            ProcessorUtils.messageNote("JARCH Created ==> " + String.valueOf(this.fileDataController.getAbsoluteFile()), this.element);
        }
        catch (IOException e) {
            LogUtils.generate((Throwable)e);
        }
    }
}

