/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.processor;

import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchValidRequired;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"br.com.jarch.core.annotation.JArchValidRequired"})
public class RequiredProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            ProcessorUtils.processingEnvironment = this.processingEnv;
            ProcessorUtils.messageNote("Analyzing: " + this.getClass().getSimpleName());
            roundEnv.getElementsAnnotatedWithAny(Set.of(JArchValidRequired.class)).stream().forEach(element -> {
                ProcessorUtils.messageAnalyzing(this.getClass(), element);
                this.validRequired((Element)element);
            });
            return false;
        }
        catch (Exception ex) {
            ProcessorUtils.messageError("JARCH ERROR: Erro no APT " + this.getClass().getSimpleName() + " Mensagem: " + ex.getMessage());
            return false;
        }
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private void validRequired(Element element) {
        for (JArchValidRequired anotacao : (JArchValidRequired[])element.getAnnotationsByType(JArchValidRequired.class)) {
            if (anotacao.value().isEmpty() || anotacao.value().startsWith("label.") || anotacao.value().startsWith("message.") || anotacao.value().startsWith("required.")) continue;
            ProcessorUtils.messageError("JARCH ERROR: @JArchValidRequired com value igual " + anotacao.value() + " fora do padrao para uma chave do bundle. Utilizar o seguinte prefixo: \"label.\" ou \"message.\" ou \"required.\" .", element);
        }
    }
}

