/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.processor;

import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchDao;
import br.com.jarch.core.annotation.JArchFacade;
import br.com.jarch.core.annotation.JArchJpaRepository;
import br.com.jarch.core.annotation.JArchRepository;
import br.com.jarch.core.annotation.JArchService;
import jakarta.annotation.Resource;
import jakarta.ejb.EJB;
import jakarta.inject.Inject;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;

@SupportedAnnotationTypes(value={"br.com.jarch.core.annotation.JArchService", "br.com.jarch.core.annotation.JArchRepository", "br.com.jarch.core.annotation.JArchJpaRepository", "br.com.jarch.core.annotation.JArchFacade", "br.com.jarch.core.annotation.JArchDao"})
public class JArchNoStateForManagementProcessor
extends AbstractProcessor {
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            ProcessorUtils.processingEnvironment = this.processingEnv;
            ProcessorUtils.messageNote("Analyzing: " + this.getClass().getSimpleName());
            roundEnv.getElementsAnnotatedWithAny(Set.of(JArchService.class, JArchRepository.class, JArchJpaRepository.class, JArchFacade.class, JArchDao.class)).forEach(element -> {
                ProcessorUtils.messageAnalyzing(this.getClass(), element);
                this.validateNoStateFields((Element)element);
            });
        }
        catch (Exception ex) {
            ProcessorUtils.messageError("JARCH ERROR: Erro no APT " + this.getClass().getSimpleName() + " Mensagem: " + ex.getMessage());
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    private void validateNoStateFields(Element element) {
        if (!(element instanceof TypeElement)) {
            return;
        }
        TypeElement type = (TypeElement)element;
        TypeMirror injectType = this.processingEnv.getElementUtils().getTypeElement(Inject.class.getName()) != null ? this.processingEnv.getElementUtils().getTypeElement(Inject.class.getName()).asType() : null;
        TypeMirror ejbType = this.processingEnv.getElementUtils().getTypeElement(EJB.class.getName()) != null ? this.processingEnv.getElementUtils().getTypeElement(EJB.class.getName()).asType() : null;
        TypeMirror resourceType = this.processingEnv.getElementUtils().getTypeElement(Resource.class.getName()) != null ? this.processingEnv.getElementUtils().getTypeElement(Resource.class.getName()).asType() : null;
        for (Element element2 : type.getEnclosedElements()) {
            boolean isInjected;
            if (element2.getKind() != ElementKind.FIELD) continue;
            VariableElement field = (VariableElement)element2;
            Set<Modifier> mods = field.getModifiers();
            boolean isStatic = mods.contains((Object)Modifier.STATIC);
            boolean isFinal = mods.contains((Object)Modifier.FINAL);
            boolean isConstant = isStatic && isFinal;
            boolean bl = isInjected = this.hasAnnotation(field, injectType) || this.hasAnnotation(field, ejbType) || this.hasAnnotation(field, resourceType);
            if (isConstant || isInjected) continue;
            ProcessorUtils.messageError("Classes anotadas:  \n\t@JArchService \n\t@JArchRepository \n\t@JArchJpaRepository \n\t@JArchFacade \n\t@JArchDao \nS\u00f3 podem declarar atributos se forem injetados (@Inject / @EJB / @Resource) ou constantes (static final). \nField '" + String.valueOf(field.getSimpleName()) + "' na classe '" + String.valueOf(type.getQualifiedName()) + "' com estado, favor verificar.", field);
        }
    }

    private boolean hasAnnotation(Element element, TypeMirror annotationType) {
        if (annotationType == null) {
            return false;
        }
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            if (!this.processingEnv.getTypeUtils().isSameType(annotationMirror.getAnnotationType(), annotationType)) continue;
            return true;
        }
        return false;
    }
}

