/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.processor;

import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchValidExclusive;
import br.com.jarch.core.annotation.JArchValidExclusives;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Completion;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

@SupportedAnnotationTypes(value={"br.com.jarch.core.annotation.JArchValidExclusive"})
public class ExclusiveProcessor
extends AbstractProcessor {
    private final List<Completion> listaAtributos = new ArrayList<Completion>();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            ProcessorUtils.processingEnvironment = this.processingEnv;
            ProcessorUtils.messageNote("Analyzing: " + this.getClass().getSimpleName());
            roundEnv.getElementsAnnotatedWith(JArchValidExclusive.class).stream().forEach(element -> {
                ProcessorUtils.messageAnalyzing(this.getClass(), element);
                if ("id".equalsIgnoreCase(element.getSimpleName().toString())) {
                    ProcessorUtils.messageError("JARCH ERROR: @JArchValidExclusive n\u00e3o pode ser utilizado no atributo id", element);
                }
            });
        }
        catch (Exception ex) {
            ProcessorUtils.messageError("JARCH ERROR: Erro no APT " + this.getClass().getSimpleName() + " Mensagem: " + ex.getMessage());
        }
        return false;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        this.listaAtributos.clear();
        TypeElement classeElement = (TypeElement)element;
        JArchValidExclusives anotacao = element.getAnnotation(JArchValidExclusives.class);
        if (member.getSimpleName().toString().contains("value")) {
            String[] fields;
            for (String field : fields = anotacao.fields()) {
                this.listaAtributos.add(new MyCmpl(field));
                ProcessorUtils.messageError("JARCH ERROR: Atributo " + field + " n\u00e3o localizado na anota\u00e7\u00e3o @JArchValidExclusives da classe " + classeElement.getQualifiedName().toString(), element);
            }
            return this.listaAtributos;
        }
        return super.getCompletions(element, annotation, member, userText);
    }

    private static final class MyCmpl
    implements Completion {
        private final String protocol;

        public MyCmpl(String protocol) {
            this.protocol = protocol;
        }

        @Override
        public String getValue() {
            return "\"" + this.protocol;
        }

        @Override
        public String getMessage() {
            return "DEUS E FIEL !!!";
        }
    }
}

