/*
 * Decompiled with CFR 0.152.
 */
package br.com.jarch.apt.generate;

import br.com.jarch.apt.generate.BaseCodeGenerate;
import br.com.jarch.apt.type.CodeType;
import br.com.jarch.apt.type.ModuleType;
import br.com.jarch.apt.util.ProcessorUtils;
import br.com.jarch.core.annotation.JArchGenerateCrud;
import javax.lang.model.element.Element;

public class ListControllerCodeGenerate
extends BaseCodeGenerate {
    public static void generate(Element element, JArchGenerateCrud generateCrud) {
        new ListControllerCodeGenerate(element, generateCrud).generate();
    }

    ListControllerCodeGenerate(Element element, JArchGenerateCrud generateCrud) {
        super(element, generateCrud);
    }

    @Override
    public ModuleType getModule() {
        return ModuleType.WEB;
    }

    @Override
    public CodeType getType() {
        return CodeType.LIST_CONTROLLER;
    }

    @Override
    public String getContent() {
        StringBuilder code = new StringBuilder();
        this.addPackage(code);
        this.addImports(code);
        this.addBody(code);
        return code.toString();
    }

    private void addPackage(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "package " + this.getNamePackage() + ";");
        ProcessorUtils.addLineBlank(sbListCode);
    }

    private void addImports(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "import br.com.jarch.core.annotation.JArchListController;");
        ProcessorUtils.addCode(sbListCode, "import br.com.jarch.faces.controller.CrudListController;");
        ProcessorUtils.addCode(sbListCode, "import " + this.getFullNameEntity() + ";");
        ProcessorUtils.addCode(sbListCode, "import " + this.getFullNameService() + ";");
        ProcessorUtils.addCode(sbListCode, "import " + this.getFullNameRepository() + ";");
        ProcessorUtils.addLineBlank(sbListCode);
    }

    private void addBody(StringBuilder sbListCode) {
        ProcessorUtils.addCode(sbListCode, "@JArchListController");
        ProcessorUtils.addCode(sbListCode, "public class " + this.getName() + " extends CrudListController<" + this.getNameEntity() + ", " + this.getNameService() + ", " + this.getNameRepository() + "> {");
        ProcessorUtils.addLineBlank(sbListCode);
        ProcessorUtils.addCode(sbListCode, "\t@Override");
        ProcessorUtils.addCode(sbListCode, "\tpublic String getPageData() {");
        ProcessorUtils.addCode(sbListCode, "\t\treturn \"" + this.getVarName() + "Data.jsf\";");
        ProcessorUtils.addCode(sbListCode, "\t}");
        ProcessorUtils.addCode(sbListCode, "}");
    }
}

