/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.MemberSocketInterceptor;
import com.hazelcast.nio.SocketChannelWrapper;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;

public class SocketAcceptor
implements Runnable {
    private final ServerSocketChannel serverSocketChannel;
    private final ConnectionManager connectionManager;
    private Selector selector;
    private final ILogger logger;

    public SocketAcceptor(ServerSocketChannel serverSocketChannel, ConnectionManager connectionManager) {
        this.serverSocketChannel = serverSocketChannel;
        this.connectionManager = connectionManager;
        this.logger = connectionManager.ioService.getLogger(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block12: {
            this.connectionManager.ioService.onIOThreadStart();
            this.log(Level.FINEST, "Starting SocketAcceptor on " + this.serverSocketChannel);
            this.selector = Selector.open();
            this.serverSocketChannel.configureBlocking(false);
            this.serverSocketChannel.register(this.selector, 16);
            while (this.connectionManager.isLive()) {
                int keyCount = this.selector.select();
                if (Thread.currentThread().isInterrupted()) break;
                if (keyCount == 0) continue;
                Set<SelectionKey> setSelectedKeys = this.selector.selectedKeys();
                Iterator<SelectionKey> it = setSelectedKeys.iterator();
                while (it.hasNext()) {
                    SelectionKey sk = it.next();
                    it.remove();
                    if (!sk.isValid() || !sk.isAcceptable()) continue;
                    this.acceptSocket();
                }
            }
            Object var6_7 = null;
            try {
                this.logger.log(Level.FINEST, "Closing selector " + Thread.currentThread().getName());
                this.selector.close();
            }
            catch (Exception ignored) {}
            break block12;
            {
                catch (OutOfMemoryError e) {
                    OutOfMemoryErrorDispatcher.onOutOfMemory(e);
                    Object var6_8 = null;
                    try {
                        this.logger.log(Level.FINEST, "Closing selector " + Thread.currentThread().getName());
                        this.selector.close();
                    }
                    catch (Exception ignored) {}
                    break block12;
                }
                catch (IOException e) {
                    this.log(Level.SEVERE, e.getClass().getName() + ": " + e.getMessage(), e);
                    Object var6_9 = null;
                    try {
                        this.logger.log(Level.FINEST, "Closing selector " + Thread.currentThread().getName());
                        this.selector.close();
                    }
                    catch (Exception ignored) {}
                }
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                try {
                    this.logger.log(Level.FINEST, "Closing selector " + Thread.currentThread().getName());
                    this.selector.close();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    private void acceptSocket() {
        SocketChannel socketChannel;
        if (!this.connectionManager.isLive()) {
            return;
        }
        SocketChannelWrapper socketChannelWrapper = null;
        try {
            socketChannel = this.serverSocketChannel.accept();
            if (socketChannel != null) {
                socketChannelWrapper = this.connectionManager.wrapSocketChannel(socketChannel, false);
            }
        }
        catch (Exception e) {
            if (e instanceof ClosedChannelException && !this.connectionManager.isLive()) {
                this.logger.log(Level.FINEST, "Terminating socket acceptor thread...", e);
            }
            String error = "Unexpected error while accepting connection! " + e.getClass().getName() + ": " + e.getMessage();
            this.logger.log(Level.WARNING, error, e);
            this.connectionManager.ioService.getSystemLogService().logConnection(error);
            try {
                this.serverSocketChannel.close();
            }
            catch (Exception ignore) {
                // empty catch block
            }
            this.connectionManager.ioService.onFatalError(e);
        }
        if (socketChannelWrapper != null) {
            socketChannel = socketChannelWrapper;
            this.connectionManager.ioService.executeAsync(new Runnable((SocketChannelWrapper)((Object)socketChannel)){
                final /* synthetic */ SocketChannelWrapper val$socketChannel;
                {
                    this.val$socketChannel = socketChannelWrapper;
                }

                public void run() {
                    block5: {
                        String message = this.val$socketChannel.socket().getLocalPort() + " is accepting socket connection from " + this.val$socketChannel.socket().getRemoteSocketAddress();
                        SocketAcceptor.this.log(Level.INFO, message);
                        try {
                            MemberSocketInterceptor memberSocketInterceptor = SocketAcceptor.this.connectionManager.getMemberSocketInterceptor();
                            if (memberSocketInterceptor != null) {
                                SocketAcceptor.this.log(Level.FINEST, "Calling member socket interceptor: " + memberSocketInterceptor + " for " + this.val$socketChannel);
                                memberSocketInterceptor.onAccept(this.val$socketChannel.socket());
                            }
                            this.val$socketChannel.configureBlocking(false);
                            SocketAcceptor.this.connectionManager.initSocket(this.val$socketChannel.socket());
                            SocketAcceptor.this.connectionManager.assignSocketChannel(this.val$socketChannel);
                        }
                        catch (Exception e) {
                            SocketAcceptor.this.log(Level.WARNING, e.getClass().getName() + ": " + e.getMessage(), e);
                            if (this.val$socketChannel == null) break block5;
                            try {
                                this.val$socketChannel.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                    }
                }
            });
        }
    }

    private void log(Level level, String message) {
        this.log(level, message, null);
    }

    private void log(Level level, String message, Exception e) {
        this.logger.log(level, message, e);
        this.connectionManager.ioService.getSystemLogService().logConnection(message);
    }
}

