/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.view;

import br.com.dsfnet.gpd.client.form.AutenticacaoForm;
import br.com.dsfnet.gpd.fx.util.AmbienteUtils;
import br.com.dsfnet.gpd.fx.view.Aplicacao;
import br.com.dsfnet.gpd.fx.view.BaseFxml;
import br.com.dsfnet.gpd.fx.view.ImagemFx;
import br.com.dsfnet.gpd.fx.view.MenuPrincipalController;
import br.com.jarch.util.LogUtils;
import jakarta.inject.Inject;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class LoginController
extends BaseFxml {
    @FXML
    private VBox vboxLogin;
    @FXML
    private Label lblVersao;
    @FXML
    private ImageView imgviewFundo;
    @FXML
    private TextField txtLogin;
    @FXML
    private TextField txtSenha;
    @FXML
    private Label lblMensagem;
    @Inject
    private MenuPrincipalController menuPrincipalController;

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.lblMensagem.setText("");
        this.lblVersao.setText("25.10.2.1237");
        this.imgviewFundo.setImage(ImagemFx.getInstancia().getImgLoginFundo());
        AnchorPane.setTopAnchor((Node)this.imgviewFundo, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.imgviewFundo, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.imgviewFundo, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.imgviewFundo, (Double)0.0);
        this.imgviewFundo.setPreserveRatio(false);
        this.imgviewFundo.setFitWidth(1024.0);
        this.imgviewFundo.setFitHeight(768.0);
        this.vboxLogin.setLayoutX(312.0);
        this.vboxLogin.setLayoutY(151.0);
        Platform.runLater(() -> this.txtLogin.requestFocus());
    }

    public void handleLoginAction(ActionEvent event) {
        Platform.runLater(() -> {
            if (this.getConfiguracaoSingleton().getServidorSvn() == null || this.getConfiguracaoSingleton().getServidorSvn().isEmpty()) {
                this.lblMensagem.setText("SERVIDOR SVN n\u00e3o informado na inicializa\u00e7\u00e3o");
                return;
            }
            if (this.getConfiguracaoSingleton().getUrlGpd() == null || this.getConfiguracaoSingleton().getUrlGpd().isEmpty()) {
                this.lblMensagem.setText("SERVIDOR GPD n\u00e3o informado na inicializa\u00e7\u00e3o");
                return;
            }
            if (this.txtLogin.getText().isEmpty()) {
                this.lblMensagem.setText("Login obrigat\u00f3rio");
                return;
            }
            if (this.txtSenha.getText().isEmpty()) {
                this.lblMensagem.setText("Senha obrigat\u00f3rio");
                return;
            }
            try {
                AutenticacaoForm autenticacaoForm = new AutenticacaoForm();
                autenticacaoForm.setLogin(this.txtLogin.getText());
                autenticacaoForm.setSenha(this.txtSenha.getText());
                autenticacaoForm.setServidorSvn(this.getConfiguracaoSingleton().getServidorSvn());
                this.getConfiguracaoSingleton().setLogin(this.txtLogin.getText());
                this.getConfiguracaoSingleton().setSenha(this.txtSenha.getText());
                this.getConsumoRestSingleton().login(autenticacaoForm);
                this.aplicaEfeitoFadeOut(this.anchorPane, this.menuPrincipalController);
            }
            catch (Exception ce) {
                this.lblMensagem.setText(ce.getMessage());
            }
        });
    }

    public void handleCancelarAction(ActionEvent event) {
        Aplicacao.getInstancia().encerrar();
    }

    public void loginKeyPressed(KeyEvent keyEvent) {
        this.lblMensagem.setText("");
        try {
            this.analisaEasterEgg(keyEvent);
        }
        catch (UnknownHostException e) {
            LogUtils.generate((Throwable)e);
        }
    }

    public void senhaKeyPressed(KeyEvent keyEvent) {
        this.lblMensagem.setText("");
    }

    public void loginMousePressed(MouseEvent mouseEvent) {
    }

    public void onKeyReleasedAnchorPane(KeyEvent event) {
    }

    private void analisaEasterEgg(KeyEvent keyEvent) throws UnknownHostException {
        LogUtils.generate((String)AmbienteUtils.nomeComputador());
        if ((AmbienteUtils.nomeComputador().equals("wagner-G7") || AmbienteUtils.nomeComputador().equals("wagner-pc") || AmbienteUtils.nomeComputador().contains("wagner-mac-studio")) && keyEvent.isControlDown() && keyEvent.isShiftDown() && keyEvent.getCode() == KeyCode.F12) {
            this.txtLogin.setText("wagner.araujo");
            this.txtSenha.setText("j2s5s_cr3st4@");
            this.handleLoginAction(null);
        }
    }

    private boolean loginValido(AutenticacaoForm autenticacaoForm) {
        LogUtils.generate((String)("######### TENTANDO LOGIN: " + autenticacaoForm.getLogin()));
        try {
            SVNRepository repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)autenticacaoForm.getServidorSvn()));
            ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)autenticacaoForm.getLogin(), (String)autenticacaoForm.getSenha());
            repository.setAuthenticationManager(authManager);
            repository.testConnection();
            LogUtils.generate((String)("######### LOGIN: " + autenticacaoForm.getLogin() + " SUCESSO ########"));
            return true;
        }
        catch (Exception e) {
            LogUtils.generate((Throwable)e);
            return false;
        }
    }
}

