/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.view;

import br.com.dsfnet.gpd.client.desenvolvimento.DesenvolvimentoEntity;
import br.com.dsfnet.gpd.client.empacotamento.EmpacotamentoEntity;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.type.PublicacaoType;
import br.com.dsfnet.gpd.client.type.TecnologiaType;
import br.com.dsfnet.gpd.client.util.Utils;
import br.com.dsfnet.gpd.client.versionamento.VersionamentoEntity;
import br.com.dsfnet.gpd.fx.util.AnalisaIdeDesenvolvimento;
import br.com.dsfnet.gpd.fx.util.OrdenacaoLista;
import br.com.dsfnet.gpd.fx.util.RemoteFactory;
import br.com.dsfnet.gpd.fx.view.BaseFxml;
import br.com.dsfnet.gpd.fx.view.MensagemView;
import br.com.jarch.core.exception.ValidationException;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.StringUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;

public class InicioVersionamentoController
extends BaseFxml {
    @FXML
    private RadioButton radioButtonIndividual;
    @FXML
    private RadioButton radioButtonPacote;
    @FXML
    private TextField textFieldBranchPacote;
    @FXML
    private Label labelBranchPacote;
    @FXML
    private ComboBox comboBoxPlanejamento;
    @FXML
    private Button buttonInicioDesenvolvimento;
    private SistemaEntity sistemaEntity;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.textFieldBranchPacote.textProperty().addListener((observable, oldValue, newValue) -> {
            String value = Utils.extraiNumeroJira((String)newValue);
            this.textFieldBranchPacote.setText(value);
            this.atualizaCombo();
            if (StringUtils.isNotEmpty((String)value)) {
                this.comboBoxPlanejamento.getItems().removeIf(l -> !l.toString().contains(value));
                Object itemSelecionado = this.comboBoxPlanejamento.getItems().stream().filter(s -> s.toString().contains(value)).findFirst().orElse(null);
                this.comboBoxPlanejamento.setValue(itemSelecionado);
            }
        });
        this.atualizaCombo();
        Platform.runLater(() -> {
            this.atualizaLabelBranchPacote();
            try {
                this.clearLog();
            }
            catch (Exception ex) {
                LogUtils.generate((Throwable)ex);
            }
        });
        this.radioButtonIndividual.setOnMouseClicked(event -> {
            this.atualizaCombo();
            this.atualizaLabelBranchPacote();
        });
        this.radioButtonPacote.setOnMouseClicked(event -> {
            this.atualizaCombo();
            this.atualizaLabelBranchPacote();
        });
    }

    private void chamaOnShow() {
        this.textFieldBranchPacote.clear();
        this.radioButtonIndividual.setSelected(false);
        this.radioButtonPacote.setSelected(false);
        this.comboBoxPlanejamento.setValue(null);
    }

    public void buttonIniciarDesenvolvimentoAction(ActionEvent event) {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                String branch;
                InicioVersionamentoController.this.desabilitaComponentes();
                PublicacaoType publicacaoType = null;
                if (InicioVersionamentoController.this.radioButtonIndividual.isSelected()) {
                    publicacaoType = PublicacaoType.INDIVIDUAL;
                } else if (InicioVersionamentoController.this.radioButtonPacote.isSelected()) {
                    publicacaoType = PublicacaoType.PACOTE;
                }
                DesenvolvimentoEntity desenvolvimento = null;
                if (publicacaoType != null && publicacaoType == PublicacaoType.INDIVIDUAL) {
                    desenvolvimento = (DesenvolvimentoEntity)InicioVersionamentoController.this.comboBoxPlanejamento.getSelectionModel().getSelectedItem();
                }
                EmpacotamentoEntity empacotamento = null;
                if (publicacaoType != null && publicacaoType == PublicacaoType.PACOTE) {
                    empacotamento = (EmpacotamentoEntity)InicioVersionamentoController.this.comboBoxPlanejamento.getSelectionModel().getSelectedItem();
                }
                Long idDesenvolvimento = null;
                if (desenvolvimento != null) {
                    idDesenvolvimento = desenvolvimento.getId();
                }
                Long idEmpacotamento = null;
                if (empacotamento != null) {
                    idEmpacotamento = empacotamento.getId();
                }
                try {
                    RemoteFactory.getInstance().getProcessamento().validacaoInicioVersionamento(publicacaoType, idDesenvolvimento, idEmpacotamento);
                }
                catch (Exception ex) {
                    throw new ValidationException("Existe alguma restri\u00e7\u00e3o para versionar esse item, provavelmente existe um versionamento em andamento para esse sistema");
                }
                AnalisaIdeDesenvolvimento.existeAlgumaEmExecucao();
                InicioVersionamentoController.this.startProcessLog();
                Platform.runLater(() -> InicioVersionamentoController.this.clearLog());
                InicioVersionamentoController.this.criaTaskAtualizacaoLabel();
                ArrayList log = new ArrayList();
                InicioVersionamentoController.this.getVersionamentoSvn().inicioVersionamento(InicioVersionamentoController.this.getConfiguracaoSingleton().getServidorSvn(), InicioVersionamentoController.this.getConfiguracaoSingleton().getLogin(), InicioVersionamentoController.this.getConfiguracaoSingleton().getSenha(), publicacaoType, desenvolvimento, empacotamento, log, InicioVersionamentoController.this.getOutputStream());
                VersionamentoEntity versionamentoEntity = RemoteFactory.getInstance().getProcessamento().atualizacaoBancoDadosInicioVersionamento(InicioVersionamentoController.this.getConfiguracaoSingleton().getLogin(), publicacaoType, idDesenvolvimento, idEmpacotamento);
                if (desenvolvimento != null) {
                    InicioVersionamentoController.this.sistemaEntity = desenvolvimento.getSistemaEntity();
                    branch = desenvolvimento.getNumeroSol().toString();
                } else {
                    InicioVersionamentoController.this.sistemaEntity = empacotamento.getSistemaEntity();
                    branch = empacotamento.getVersao();
                }
                if (InicioVersionamentoController.this.sistemaEntity != null) {
                    InicioVersionamentoController.this.getVersionamentoSvn().verificaConflito(InicioVersionamentoController.this.getConfiguracaoSingleton().getLogin(), InicioVersionamentoController.this.getConfiguracaoSingleton().getSenha(), versionamentoEntity, branch, InicioVersionamentoController.this.getOutputStream());
                }
                if (empacotamento != null && empacotamento.getSistemaEntity().getTecnologia() == TecnologiaType.JAVA) {
                    InicioVersionamentoController.this.getBibliotecaSvn().baixaBiblioteca(InicioVersionamentoController.this.getConfiguracaoSingleton().getServidorSvn(), InicioVersionamentoController.this.getConfiguracaoSingleton().getLogin(), InicioVersionamentoController.this.getConfiguracaoSingleton().getSenha());
                }
                if (desenvolvimento != null && desenvolvimento.getSistemaEntity().getTecnologia() == TecnologiaType.JAVA) {
                    InicioVersionamentoController.this.getBibliotecaSvn().baixaBiblioteca(InicioVersionamentoController.this.getConfiguracaoSingleton().getServidorSvn(), InicioVersionamentoController.this.getConfiguracaoSingleton().getLogin(), InicioVersionamentoController.this.getConfiguracaoSingleton().getSenha());
                }
                Platform.runLater(() -> InicioVersionamentoController.this.updateLogWebView(String.join((CharSequence)"\n", log)));
                return null;
            }

            protected void failed() {
                Platform.runLater(() -> {
                    InicioVersionamentoController.this.endProcessLog();
                    String mensagemErro = this.exceptionNow().getMessage();
                    MensagemView.getInstancia().mostraErro(InicioVersionamentoController.this.anchorPane, mensagemErro);
                    InicioVersionamentoController.this.habilitaComponentes();
                });
            }

            protected void succeeded() {
                Platform.runLater(() -> {
                    InicioVersionamentoController.this.endProcessLog();
                    MensagemView.getInstancia().mostraSucesso(InicioVersionamentoController.this.anchorPane, "Processamento Conclu\u00eddo com Sucesso");
                    InicioVersionamentoController.this.habilitaComponentes();
                    InicioVersionamentoController.this.atualizaCombo();
                    InicioVersionamentoController.this.atualizaLabelBranchPacote();
                });
            }
        };
        new Thread((Runnable)task).start();
    }

    private void desabilitaComponentes() {
        this.habilitaDesabilitaComponente(true);
    }

    private void habilitaComponentes() {
        this.habilitaDesabilitaComponente(false);
    }

    private void habilitaDesabilitaComponente(boolean disable) {
        Platform.runLater(() -> {
            this.comboBoxPlanejamento.setDisable(disable);
            this.buttonInicioDesenvolvimento.setDisable(disable);
        });
    }

    private void atualizaLabelBranchPacote() {
        Platform.runLater(() -> {
            if (this.radioButtonPacote.isSelected()) {
                this.labelBranchPacote.setText("Pacote");
            } else {
                this.labelBranchPacote.setText("Branch");
            }
        });
    }

    private void atualizaCombo() {
        this.comboBoxPlanejamento.getSelectionModel().clearSelection();
        this.comboBoxPlanejamento.getItems().clear();
        if (this.radioButtonIndividual.isSelected()) {
            this.comboBoxPlanejamento.getItems().addAll((Collection)RemoteFactory.getInstance().getProcessamento().carregaListaIndividualInicioVersionamento().stream().sorted(OrdenacaoLista.desenvolvimentoComparator).collect(Collectors.toList()));
        } else if (this.radioButtonPacote.isSelected()) {
            this.comboBoxPlanejamento.getItems().addAll((Collection)RemoteFactory.getInstance().getProcessamento().carregaListaPacoteInicioVersionamento().stream().sorted(OrdenacaoLista.empacotamentoComparator).collect(Collectors.toList()));
        }
        this.comboBoxPlanejamento.setValue(null);
    }
}

