/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.view;

import br.com.dsfnet.gpd.client.empacotamento.EmpacotamentoEntity;
import br.com.dsfnet.gpd.fx.util.AnalisaIdeDesenvolvimento;
import br.com.dsfnet.gpd.fx.util.OrdenacaoLista;
import br.com.dsfnet.gpd.fx.util.RemoteFactory;
import br.com.dsfnet.gpd.fx.view.BaseFxml;
import br.com.dsfnet.gpd.fx.view.MensagemView;
import br.com.jarch.util.LogUtils;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ResourceBundle;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;

public class FinalizacaoEmpacotamentoController
extends BaseFxml {
    @FXML
    private ComboBox comboBoxPlanejamento;
    @FXML
    private Button buttonInicioDesenvolvimento;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.atualizaCombo();
        Platform.runLater(() -> {
            try {
                this.clearLog();
            }
            catch (Exception ex) {
                LogUtils.generate((Throwable)ex);
            }
        });
    }

    public void buttonIniciarDesenvolvimentoAction(ActionEvent event) {
        Task<Void> task = new Task<Void>(){

            protected Void call() throws Exception {
                FinalizacaoEmpacotamentoController.this.desabilitaComponentes();
                EmpacotamentoEntity empacotamento = (EmpacotamentoEntity)FinalizacaoEmpacotamentoController.this.comboBoxPlanejamento.getSelectionModel().getSelectedItem();
                RemoteFactory.getInstance().getProcessamento().validacaoFimEmpacotamento(empacotamento.getId());
                AnalisaIdeDesenvolvimento.existeAlgumaEmExecucao();
                FinalizacaoEmpacotamentoController.this.startProcessLog();
                Platform.runLater(() -> FinalizacaoEmpacotamentoController.this.clearLog());
                FinalizacaoEmpacotamentoController.this.criaTaskAtualizacaoLabel();
                ArrayList log = new ArrayList();
                FinalizacaoEmpacotamentoController.this.getEmpacotamentoSvn().finalizaEmpacotamento(FinalizacaoEmpacotamentoController.this.getConfiguracaoSingleton().getServidorSvn(), FinalizacaoEmpacotamentoController.this.getConfiguracaoSingleton().getLogin(), FinalizacaoEmpacotamentoController.this.getConfiguracaoSingleton().getSenha(), empacotamento, null, log, FinalizacaoEmpacotamentoController.this.getOutputStream());
                RemoteFactory.getInstance().getProcessamento().atualizacaoBancoDadosFimEmpacotamento(empacotamento.getId());
                Platform.runLater(() -> FinalizacaoEmpacotamentoController.this.updateLogWebView(log.stream().collect(Collectors.joining("\n"))));
                return null;
            }

            protected void failed() {
                this.getException().printStackTrace();
                Platform.runLater(() -> {
                    FinalizacaoEmpacotamentoController.this.endProcessLog();
                    MensagemView.getInstancia().mostraErro(FinalizacaoEmpacotamentoController.this.anchorPane, this.getException().getMessage());
                    FinalizacaoEmpacotamentoController.this.habilitaComponentes();
                });
            }

            protected void succeeded() {
                Platform.runLater(() -> {
                    FinalizacaoEmpacotamentoController.this.endProcessLog();
                    MensagemView.getInstancia().mostraSucesso(FinalizacaoEmpacotamentoController.this.anchorPane, "Processamento Conclu\u00eddo com Sucesso");
                    FinalizacaoEmpacotamentoController.this.habilitaComponentes();
                    FinalizacaoEmpacotamentoController.this.atualizaCombo();
                });
            }
        };
        new Thread((Runnable)task).start();
    }

    private void desabilitaComponentes() {
        this.habilitaDesabilitaComponente(true);
    }

    private void habilitaComponentes() {
        this.habilitaDesabilitaComponente(false);
    }

    private void habilitaDesabilitaComponente(boolean disable) {
        Platform.runLater(() -> {
            this.comboBoxPlanejamento.setDisable(disable);
            this.buttonInicioDesenvolvimento.setDisable(disable);
        });
    }

    private void atualizaCombo() {
        this.comboBoxPlanejamento.getSelectionModel().clearSelection();
        this.comboBoxPlanejamento.getItems().clear();
        this.comboBoxPlanejamento.getItems().addAll((Collection)RemoteFactory.getInstance().getProcessamento().carregaListaFimEmpacotamento(this.getConfiguracaoSingleton().getLogin()).stream().sorted(OrdenacaoLista.empacotamentoComparator).collect(Collectors.toList()));
        this.comboBoxPlanejamento.setValue(null);
    }
}

