/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.fx.util;

import br.com.jarch.util.type.OperationSystemType;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Locale;

public final class AmbienteUtils {
    private AmbienteUtils() {
    }

    public static boolean isLinux() {
        return AmbienteUtils.sistemaOperacional() == OperationSystemType.LINUX;
    }

    public static boolean isWindows() {
        return AmbienteUtils.sistemaOperacional() == OperationSystemType.WINDOWS;
    }

    public static boolean isMac() {
        return AmbienteUtils.sistemaOperacional() == OperationSystemType.MAC;
    }

    public static String nomeComputador() throws UnknownHostException {
        InetAddress addr = InetAddress.getLocalHost();
        return addr.getHostName();
    }

    public static String ipComputador() throws UnknownHostException {
        InetAddress addr = InetAddress.getLocalHost();
        return addr.getHostAddress();
    }

    public static OperationSystemType sistemaOperacional() {
        String osName = System.getProperty("os.name");
        if (osName.toLowerCase(Locale.ENGLISH).contains("windows")) {
            return OperationSystemType.WINDOWS;
        }
        if (osName.toLowerCase(Locale.ENGLISH).contains("linux")) {
            return OperationSystemType.LINUX;
        }
        return OperationSystemType.MAC;
    }
}

