/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.versionamento;

import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.type.StatusType;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.jarch.core.annotation.JArchConfiguration;
import br.com.jarch.core.crud.entity.CrudEntity;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import java.io.Serializable;
import java.util.Date;

@Entity
@Table(name="VERSIONAMENTO")
@JArchConfiguration(ignorePatternsObjetcsDataBase=true, generateFilterSelection=false, generateDataDetail=false)
@SequenceGenerator(name="VersionamentoIdSequence", sequenceName="SEQ_VERSIONAMENTO_ID", allocationSize=1)
public class VersionamentoEntity
extends CrudEntity
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="VersionamentoIdSequence")
    private Long id;
    private String versao;
    private String tag;
    @Column(name="branch")
    private String numeroSol;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date inicio;
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date fim;
    @Enumerated(value=EnumType.STRING)
    private StatusType status;
    @Column(name="tag_versao1")
    private Long tagVersao1;
    @Column(name="tag_versao2")
    private Long tagVersao2;
    @Column(name="tag_versao3")
    private Long tagVersao3;
    @Column(name="tag_versao4")
    private Long tagVersao4;
    @OneToOne
    @JoinColumn(name="aplicacao_id")
    private SistemaEntity sistemaEntity;
    @OneToOne
    @JoinColumn(name="usuario_id")
    private UsuarioEntity usuarioEntity;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getVersao() {
        return this.versao;
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }

    public void setVersao(String versao) {
        this.versao = versao;
    }

    public String getNumeroSol() {
        return this.numeroSol;
    }

    public void setNumeroSol(String numeroSol) {
        this.numeroSol = numeroSol;
    }

    public SistemaEntity getSistemaEntity() {
        return this.sistemaEntity;
    }

    public void setSistemaEntity(SistemaEntity sistemaEntity) {
        this.sistemaEntity = sistemaEntity;
    }

    public UsuarioEntity getUsuarioEntity() {
        return this.usuarioEntity;
    }

    public void setUsuarioEntity(UsuarioEntity usuarioEntity) {
        this.usuarioEntity = usuarioEntity;
    }

    public Date getInicio() {
        return this.inicio;
    }

    public void setInicio(Date inicio) {
        this.inicio = inicio;
    }

    public Date getFim() {
        return this.fim;
    }

    public void setFim(Date fim) {
        this.fim = fim;
    }

    public StatusType getStatus() {
        return this.status;
    }

    public void setStatus(StatusType status) {
        this.status = status;
    }

    public Long getTagVersao1() {
        return this.tagVersao1;
    }

    public void setTagVersao1(Long tagVersao1) {
        this.tagVersao1 = tagVersao1;
    }

    public Long getTagVersao2() {
        return this.tagVersao2;
    }

    public void setTagVersao2(Long tagVersao2) {
        this.tagVersao2 = tagVersao2;
    }

    public Long getTagVersao3() {
        return this.tagVersao3;
    }

    public void setTagVersao3(Long tagVersao3) {
        this.tagVersao3 = tagVersao3;
    }

    public Long getTagVersao4() {
        return this.tagVersao4;
    }

    public void setTagVersao4(Long tagVersao4) {
        this.tagVersao4 = tagVersao4;
    }

    public int compareTo(VersionamentoEntity outro) {
        if (this.getSistemaEntity() != null && outro.getSistemaEntity() != null && this.getSistemaEntity().getCliente().compareTo(outro.getSistemaEntity().getCliente()) != 0) {
            return this.getSistemaEntity().getCliente().compareTo(outro.getSistemaEntity().getCliente());
        }
        if (this.getSistemaEntity() != null && outro.getSistemaEntity() != null && this.getSistemaEntity().getSistema().compareTo(outro.getSistemaEntity().getSistema()) != 0) {
            return this.getSistemaEntity().getSistema().compareTo(outro.getSistemaEntity().getSistema());
        }
        if (this.getSistemaEntity() != null && outro.getSistemaEntity() != null && this.getSistemaEntity().getTecnologia().compareTo(outro.getSistemaEntity().getTecnologia()) != 0) {
            return this.getSistemaEntity().getTecnologia().compareTo(outro.getSistemaEntity().getTecnologia());
        }
        if (this.getTag() != null && outro.getTag() != null) {
            return this.getTag().compareTo(outro.getTag());
        }
        if (this.getVersao() != null && outro.getVersao() != null) {
            return this.getVersao().compareTo(outro.getVersao());
        }
        if (this.getNumeroSol() != null && outro.getNumeroSol() != null) {
            return this.getNumeroSol().compareTo(outro.getNumeroSol());
        }
        return this.getId().compareTo(outro.getId());
    }

    public String toString() {
        Object print = "";
        if (this.sistemaEntity != null) {
            print = (String)print + "Cliente: " + this.sistemaEntity.getCliente();
            print = (String)print + " Produto: " + this.sistemaEntity.getSistema();
            print = (String)print + " Tecnologia: " + String.valueOf((Object)this.sistemaEntity.getTecnologia());
        }
        if (this.versao != null) {
            print = (String)print + " Vers\u00e3o: " + this.versao;
        }
        if (this.numeroSol != null) {
            print = (String)print + " BRANCH: " + this.numeroSol;
        }
        return print;
    }
}

