/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.sistema;

import br.com.dsfnet.gpd.client.ambiente.AmbienteEntity;
import br.com.dsfnet.gpd.client.sistema.ClienteType;
import br.com.dsfnet.gpd.client.sistema.DadosPublicacaoEntity;
import br.com.dsfnet.gpd.client.sistema.VersaoJavaJpaConverter;
import br.com.dsfnet.gpd.client.sistema.VersaoJavaType;
import br.com.dsfnet.gpd.client.type.TecnologiaType;
import br.com.jarch.core.annotation.JArchConfiguration;
import br.com.jarch.core.annotation.JArchLookup;
import br.com.jarch.core.annotation.JArchNoCloneId;
import br.com.jarch.core.annotation.JArchOrderBy;
import br.com.jarch.core.annotation.JArchOrderByField;
import br.com.jarch.core.annotation.JArchValidRequired;
import br.com.jarch.core.crud.entity.CrudEntity;
import br.com.jarch.core.jpa.converter.br.BooleanSNJpaConverter;
import jakarta.persistence.CascadeType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.OneToMany;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

@Entity
@Table(name="APLICACAO")
@JArchConfiguration(ignorePatternsObjetcsDataBase=true, generateFilterSelection=false)
@SequenceGenerator(name="AplicacaoIdSequence", sequenceName="SEQ_APLICACAO_ID", allocationSize=1)
@JArchOrderBy(fields={@JArchOrderByField(value="sistema")})
@JArchLookup(codeAttribute="id", descriptionAttribute="sistema")
public class SistemaEntity
extends CrudEntity
implements Serializable {
    @Id
    @GeneratedValue(strategy=GenerationType.SEQUENCE, generator="AplicacaoIdSequence")
    private Long id;
    @JArchValidRequired(value="label.sistema")
    @Column(nullable=false)
    private String sistema;
    @JArchValidRequired(value="label.cliente")
    @Column(nullable=false)
    private String cliente;
    @JArchValidRequired(value="label.tecnologia")
    @Enumerated(value=EnumType.STRING)
    @Column(nullable=false)
    private TecnologiaType tecnologia;
    @Column(name="projeto_svn", nullable=false)
    @JArchValidRequired(value="label.projetoSvn")
    private String projetoSvn;
    @Column(name="srvdev", nullable=false)
    @JArchValidRequired(value="label.servidorDesenvolvimento")
    private String servidorDesenvolvimento;
    @Column(name="srvqa", nullable=false)
    @JArchValidRequired(value="label.servidorQualidade")
    private String servidorQualidade;
    @Column(name="srvhom", nullable=false)
    @JArchValidRequired(value="label.servidorHomologacao")
    private String servidorHomologacao;
    @Column(name="srvempacot", nullable=false)
    @JArchValidRequired(value="label.servidorEmpacotamento")
    private String servidorEmpacotamento;
    @Column(name="srvaceite", nullable=false)
    @JArchValidRequired(value="label.servidorAceite")
    private String servidorAceite;
    @JArchValidRequired(value="label.servidorVersionamento")
    @Column(name="srvversion", nullable=false)
    private String servidorVersionamento;
    @Column(name="srvpublic", nullable=false)
    @JArchValidRequired(value="label.servidorPublica\u00e7\u00e3o")
    private String servidorPublicacao;
    @Column(name="srvaproveqa", nullable=false)
    private String servidorAprovacaoQualidade;
    @Column(name="srvaprovecliente", nullable=false)
    private String servidorAprovacaoCliente;
    @Column(name="SRVPRDIP")
    private String ipServidorProducao;
    @Column(name="SRVPRDDEST")
    private String pastaDestinoFonte;
    @Column(name="SRVPRDEXC")
    private String arquivosExclusao;
    @Column(name="SRVPRDBKP")
    private String arquivosBackup;
    @Column(name="SRVPRDCOM")
    private String commandoShellPosPublicacao;
    @Column(name="tag_versao1", nullable=false)
    private Long tagVersao1 = 1L;
    @Column(name="tag_versao2", nullable=false)
    private Long tagVersao2 = 0L;
    @Column(name="tag_versao3", nullable=false)
    private Long tagVersao3 = 0L;
    @Column(name="tag_versao4", nullable=false)
    private Long tagVersao4 = 0L;
    @Column(name="nome_pacote")
    private String nomePacote;
    @Column(name="pacotes")
    private String pacotes;
    @Column(name="sn_processoautomatico")
    private String processoAutomatico = "N";
    @OneToMany(fetch=FetchType.LAZY)
    @JoinTable(name="tb_aplicacao_ambiente", joinColumns={@JoinColumn(name="id_aplicacao")}, inverseJoinColumns={@JoinColumn(name="id_ambiente")})
    private Set<AmbienteEntity> listaAmbiente = new HashSet<AmbienteEntity>();
    @Column(name="sn_publicacao")
    @Convert(converter=BooleanSNJpaConverter.class)
    private Boolean permitePublicacao;
    @Column(name="nr_versaojava")
    @Convert(converter=VersaoJavaJpaConverter.class)
    private VersaoJavaType versaoJava;
    @Column(name="mm_dadospublicacao")
    private String dadosPublicacao;
    @Column(name="sn_ativo")
    @Convert(converter=BooleanSNJpaConverter.class)
    private Boolean ativo;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="sistema", orphanRemoval=true)
    @JArchNoCloneId
    private Set<DadosPublicacaoEntity> listaDadosPublicacao;

    public Collection<VersaoJavaType> getVersoesJava() {
        return VersaoJavaType.getCollection();
    }

    public Collection<TecnologiaType> getTecnologias() {
        return Arrays.stream(TecnologiaType.values()).toList();
    }

    public Collection<ClienteType> getClientes() {
        return ClienteType.getCollection();
    }

    public SistemaEntity() {
    }

    public SistemaEntity(Long id, String sistema) {
        this.id = id;
        this.sistema = sistema;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getSistema() {
        return this.sistema;
    }

    public void setSistema(String sistema) {
        this.sistema = sistema;
    }

    public Boolean getAtivo() {
        return this.ativo;
    }

    public void setAtivo(Boolean ativo) {
        this.ativo = ativo;
    }

    public VersaoJavaType getVersaoJava() {
        return this.versaoJava;
    }

    public void setVersaoJava(VersaoJavaType versaoJava) {
        this.versaoJava = versaoJava;
    }

    public Boolean getPermitePublicacao() {
        return this.permitePublicacao;
    }

    public void setPermitePublicacao(Boolean permitePublicacao) {
        this.permitePublicacao = permitePublicacao;
    }

    public Set<AmbienteEntity> getListaAmbiente() {
        return this.listaAmbiente;
    }

    public void setListaAmbiente(Set<AmbienteEntity> listaAmbiente) {
        this.listaAmbiente = listaAmbiente;
    }

    public String getProcessoAutomatico() {
        return this.processoAutomatico;
    }

    public void setProcessoAutomatico(String processoAutomatico) {
        this.processoAutomatico = processoAutomatico;
    }

    public String getPacotes() {
        return this.pacotes;
    }

    public void setPacotes(String pacotes) {
        this.pacotes = pacotes;
    }

    public String getNomePacote() {
        return this.nomePacote;
    }

    public void setNomePacote(String nomePacote) {
        this.nomePacote = nomePacote;
    }

    public Long getTagVersao4() {
        return this.tagVersao4;
    }

    public void setTagVersao4(Long tagVersao4) {
        this.tagVersao4 = tagVersao4;
    }

    public Long getTagVersao3() {
        return this.tagVersao3;
    }

    public void setTagVersao3(Long tagVersao3) {
        this.tagVersao3 = tagVersao3;
    }

    public Long getTagVersao2() {
        return this.tagVersao2;
    }

    public void setTagVersao2(Long tagVersao2) {
        this.tagVersao2 = tagVersao2;
    }

    public Long getTagVersao1() {
        return this.tagVersao1;
    }

    public void setTagVersao1(Long tagVersao1) {
        this.tagVersao1 = tagVersao1;
    }

    public String getCommandoShellPosPublicacao() {
        return this.commandoShellPosPublicacao;
    }

    public void setCommandoShellPosPublicacao(String commandoShellPosPublicacao) {
        this.commandoShellPosPublicacao = commandoShellPosPublicacao;
    }

    public String getArquivosBackup() {
        return this.arquivosBackup;
    }

    public void setArquivosBackup(String arquivosBackup) {
        this.arquivosBackup = arquivosBackup;
    }

    public String getArquivosExclusao() {
        return this.arquivosExclusao;
    }

    public void setArquivosExclusao(String arquivosExclusao) {
        this.arquivosExclusao = arquivosExclusao;
    }

    public String getPastaDestinoFonte() {
        return this.pastaDestinoFonte;
    }

    public void setPastaDestinoFonte(String pastaDestinoFonte) {
        this.pastaDestinoFonte = pastaDestinoFonte;
    }

    public String getIpServidorProducao() {
        return this.ipServidorProducao;
    }

    public void setIpServidorProducao(String ipServidorProducao) {
        this.ipServidorProducao = ipServidorProducao;
    }

    public String getServidorAprovacaoCliente() {
        return this.servidorAprovacaoCliente;
    }

    public void setServidorAprovacaoCliente(String servidorAprovacaoCliente) {
        this.servidorAprovacaoCliente = servidorAprovacaoCliente;
    }

    public String getServidorAprovacaoQualidade() {
        return this.servidorAprovacaoQualidade;
    }

    public void setServidorAprovacaoQualidade(String servidorAprovacaoQualidade) {
        this.servidorAprovacaoQualidade = servidorAprovacaoQualidade;
    }

    public String getServidorPublicacao() {
        return this.servidorPublicacao;
    }

    public void setServidorPublicacao(String servidorPublicacao) {
        this.servidorPublicacao = servidorPublicacao;
    }

    public String getServidorVersionamento() {
        return this.servidorVersionamento;
    }

    public void setServidorVersionamento(String servidorVersionamento) {
        this.servidorVersionamento = servidorVersionamento;
    }

    public String getServidorAceite() {
        return this.servidorAceite;
    }

    public void setServidorAceite(String servidorAceite) {
        this.servidorAceite = servidorAceite;
    }

    public String getServidorEmpacotamento() {
        return this.servidorEmpacotamento;
    }

    public void setServidorEmpacotamento(String servidorEmpacotamento) {
        this.servidorEmpacotamento = servidorEmpacotamento;
    }

    public String getServidorHomologacao() {
        return this.servidorHomologacao;
    }

    public void setServidorHomologacao(String servidorHomologacao) {
        this.servidorHomologacao = servidorHomologacao;
    }

    public String getServidorQualidade() {
        return this.servidorQualidade;
    }

    public void setServidorQualidade(String servidorQualidade) {
        this.servidorQualidade = servidorQualidade;
    }

    public String getServidorDesenvolvimento() {
        return this.servidorDesenvolvimento;
    }

    public void setServidorDesenvolvimento(String servidorDesenvolvimento) {
        this.servidorDesenvolvimento = servidorDesenvolvimento;
    }

    public String getProjetoSvn() {
        return this.projetoSvn;
    }

    public void setProjetoSvn(String projetoSvn) {
        this.projetoSvn = projetoSvn;
    }

    public String getCliente() {
        return this.cliente;
    }

    public void setCliente(String cliente) {
        this.cliente = cliente;
    }

    public TecnologiaType getTecnologia() {
        return this.tecnologia;
    }

    public void setTecnologia(TecnologiaType tecnologia) {
        this.tecnologia = tecnologia;
    }

    public Set<DadosPublicacaoEntity> getListaDadosPublicacao() {
        return this.listaDadosPublicacao;
    }

    public void setListaDadosPublicacao(Set<DadosPublicacaoEntity> listaDadosPublicacao) {
        this.listaDadosPublicacao = listaDadosPublicacao;
    }

    public void addListaDadosPublicacao(DadosPublicacaoEntity dadosPublicacao) {
        if (this.listaDadosPublicacao == null) {
            this.listaDadosPublicacao = new HashSet<DadosPublicacaoEntity>();
        }
        this.listaDadosPublicacao.add(dadosPublicacao);
    }

    public boolean isProcessoAutomatico() {
        return this.processoAutomatico != null && this.processoAutomatico.equals("S");
    }

    public String toString() {
        return this.sistema;
    }
}

