/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.sistema;

import br.com.dsfnet.gpd.client.sistema.AmbienteType;
import br.com.dsfnet.gpd.client.sistema.LocalType;
import br.com.dsfnet.gpd.client.sistema.ModuloType;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.jarch.core.annotation.JArchValidRequired;
import br.com.jarch.core.crud.entity.CrudEntity;
import br.com.jarch.core.jpa.converter.br.BooleanSNJpaConverter;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import jakarta.validation.constraints.Size;
import java.util.Collection;

@Table(name="tb_dadospublicacao")
@Entity(name="dadosPublicacao")
@SequenceGenerator(name="DadosPublicacaoIdSequence", sequenceName="sq_iddadospublicacao", allocationSize=1)
public class DadosPublicacaoEntity
extends CrudEntity {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO, generator="DadosPublicacaoIdSequence")
    @Column(name="id_dadospublicacao")
    private Long id;
    @ManyToOne
    @JoinColumn(name="id_aplicacao", nullable=false)
    @JArchValidRequired(value="label.sistema")
    private SistemaEntity sistema;
    @Column(name="tp_local", nullable=false, length=3)
    @JArchValidRequired(value="label.local")
    @Enumerated(value=EnumType.STRING)
    private LocalType local;
    @Column(name="tp_ambiente", nullable=false, length=3)
    @JArchValidRequired(value="label.ambiente")
    @Enumerated(value=EnumType.STRING)
    private AmbienteType ambiente;
    @Column(name="tp_modulo", nullable=false, length=3)
    @JArchValidRequired(value="label.modulo")
    @Enumerated(value=EnumType.STRING)
    private ModuloType modulo;
    @Column(name="ds_artefato", nullable=false, length=500)
    @JArchValidRequired(value="label.artefato")
    @Size(max=500, message="{message.maxSizeExceeded}")
    private @Size(max=500, message="{message.maxSizeExceeded}") String artefato;
    @Column(name="ds_ipservidor", nullable=false, length=500)
    @JArchValidRequired(value="label.ipServidor")
    @Size(max=500, message="{message.maxSizeExceeded}")
    private @Size(max=500, message="{message.maxSizeExceeded}") String ipServidor;
    @Column(name="ds_pathservidor", nullable=false, length=500)
    @JArchValidRequired(value="label.pathServidor")
    @Size(max=500, message="{message.maxSizeExceeded}")
    private @Size(max=500, message="{message.maxSizeExceeded}") String pathServidor;
    @Column(name="ds_comandoantescompilacao", nullable=false, length=500)
    @Size(max=500, message="{message.maxSizeExceeded}")
    private @Size(max=500, message="{message.maxSizeExceeded}") String comandoAntesCompilacao;
    @Column(name="ds_comandoreiniciarservidor", nullable=false, length=500)
    @Size(max=500, message="{message.maxSizeExceeded}")
    private @Size(max=500, message="{message.maxSizeExceeded}") String comandoReiniciarServidor;
    @Column(name="sn_contingencia", nullable=false, length=1)
    @Convert(converter=BooleanSNJpaConverter.class)
    @JArchValidRequired(value="label.contingencia")
    private Boolean contingencia;
    @Column(name="nr_porta", nullable=false)
    private Integer porta;
    @Column(name="ds_no", nullable=false, length=500)
    @Size(max=500, message="{message.maxSizeExceeded}")
    private @Size(max=500, message="{message.maxSizeExceeded}") String no;

    public DadosPublicacaoEntity() {
    }

    public DadosPublicacaoEntity(Long id, LocalType local, AmbienteType ambiente, ModuloType modulo, String artefato, String ipServidor, String pathServidor, String comandoAntesCompilacao, String comandoReiniciarServidor, Boolean contingencia, Integer porta, String no) {
        this.id = id;
        this.local = local;
        this.ambiente = ambiente;
        this.modulo = modulo;
        this.artefato = artefato;
        this.ipServidor = ipServidor;
        this.pathServidor = pathServidor;
        this.comandoAntesCompilacao = comandoAntesCompilacao;
        this.comandoReiniciarServidor = comandoReiniciarServidor;
        this.contingencia = contingencia;
        this.porta = porta;
        this.no = no;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SistemaEntity getSistema() {
        return this.sistema;
    }

    public void setSistema(SistemaEntity sistema) {
        this.sistema = sistema;
    }

    public LocalType getLocal() {
        return this.local;
    }

    public void setLocal(LocalType local) {
        this.local = local;
    }

    public AmbienteType getAmbiente() {
        return this.ambiente;
    }

    public void setAmbiente(AmbienteType ambiente) {
        this.ambiente = ambiente;
    }

    public ModuloType getModulo() {
        return this.modulo;
    }

    public void setModulo(ModuloType modulo) {
        this.modulo = modulo;
    }

    public String getArtefato() {
        return this.artefato;
    }

    public void setArtefato(String artefato) {
        this.artefato = artefato;
    }

    public String getIpServidor() {
        return this.ipServidor;
    }

    public void setIpServidor(String ipServidor) {
        this.ipServidor = ipServidor;
    }

    public String getPathServidor() {
        return this.pathServidor;
    }

    public void setPathServidor(String pathServidor) {
        this.pathServidor = pathServidor;
    }

    public String getComandoAntesCompilacao() {
        return this.comandoAntesCompilacao;
    }

    public void setComandoAntesCompilacao(String comandoAntesCompilacao) {
        this.comandoAntesCompilacao = comandoAntesCompilacao;
    }

    public String getComandoReiniciarServidor() {
        return this.comandoReiniciarServidor;
    }

    public void setComandoReiniciarServidor(String comandoReiniciarServidor) {
        this.comandoReiniciarServidor = comandoReiniciarServidor;
    }

    public Boolean getContingencia() {
        return this.contingencia;
    }

    public void setContingencia(Boolean contingencia) {
        this.contingencia = contingencia;
    }

    public Collection<LocalType> getLocals() {
        return LocalType.getCollection();
    }

    public String getLocalDescription() {
        return this.local == null ? "" : this.local.getDescription();
    }

    public Collection<AmbienteType> getAmbientes() {
        return AmbienteType.getCollection();
    }

    public String getAmbienteDescription() {
        return this.ambiente == null ? "" : this.ambiente.getDescription();
    }

    public Collection<ModuloType> getModulos() {
        return ModuloType.getCollection();
    }

    public String getModuloDescription() {
        return this.modulo == null ? "" : this.modulo.getDescription();
    }

    public Integer getPorta() {
        return this.porta;
    }

    public void setPorta(Integer porta) {
        this.porta = porta;
    }

    public String getNo() {
        return this.no;
    }

    public void setNo(String no) {
        this.no = no;
    }
}

