/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.rs;

import br.com.dsfnet.gpd.client.aceite.AceiteEntity;
import br.com.dsfnet.gpd.client.aceite.AceiteRepository;
import br.com.dsfnet.gpd.client.desenvolvimento.DesenvolvimentoEntity;
import br.com.dsfnet.gpd.client.desenvolvimento.DesenvolvimentoRepository;
import br.com.dsfnet.gpd.client.desenvolvimento.DesenvolvimentoService;
import br.com.dsfnet.gpd.client.empacotamento.EmpacotamentoEntity;
import br.com.dsfnet.gpd.client.empacotamento.EmpacotamentoRepository;
import br.com.dsfnet.gpd.client.empacotamento.EmpacotamentoService;
import br.com.dsfnet.gpd.client.exception.DesenvolvimentoException;
import br.com.dsfnet.gpd.client.exception.LoginException;
import br.com.dsfnet.gpd.client.fachada.LoginService;
import br.com.dsfnet.gpd.client.form.AplicacaoForm;
import br.com.dsfnet.gpd.client.form.AutenticacaoForm;
import br.com.dsfnet.gpd.client.form.DesenvolvimentoForm;
import br.com.dsfnet.gpd.client.form.DesenvolvimentoListaForm;
import br.com.dsfnet.gpd.client.form.RetornoForm;
import br.com.dsfnet.gpd.client.log.LogPlanejamentoRepository;
import br.com.dsfnet.gpd.client.log.LogVersionamentoRepository;
import br.com.dsfnet.gpd.client.planejamento.PlanejamentoEntity;
import br.com.dsfnet.gpd.client.planejamento.PlanejamentoRepository;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.sistema.SistemaRepository;
import br.com.dsfnet.gpd.client.sol.SolService;
import br.com.dsfnet.gpd.client.type.AmbienteType;
import br.com.dsfnet.gpd.client.type.PublicacaoType;
import br.com.dsfnet.gpd.client.type.TecnologiaType;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.dsfnet.gpd.client.util.Factory;
import br.com.dsfnet.gpd.client.versionamento.VersionamentoEntity;
import br.com.dsfnet.gpd.client.versionamento.VersionamentoService;
import br.com.jarch.util.JsonUtils;
import br.com.jarch.util.LogUtils;
import br.com.jarch.util.StringUtils;
import jakarta.inject.Inject;
import jakarta.json.Json;
import jakarta.json.JsonObject;
import jakarta.json.JsonReader;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@Path(value="/")
public class ServicoRest {
    @Inject
    private LoginService loginService;
    @Inject
    private DesenvolvimentoService desenvolvimentoService;
    @Inject
    private SolService solService;

    @POST
    @Path(value="login")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public RetornoForm login(AutenticacaoForm autenticacaoForm) {
        try {
            this.loginService.efetuaLogin(autenticacaoForm);
            return RetornoForm.getSucesso();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return RetornoForm.getProblema(-1, ex.getMessage());
        }
    }

    @GET
    @Path(value="/desenvolvimento/inicio/atualizabancodados")
    @Produces(value={"application/json"})
    public RetornoForm atualizaBancoDadosInicioaDesenvolvimento(@QueryParam(value="branch") String branch, @QueryParam(value="cliente") String cliente, @QueryParam(value="sistema") String sistema, @QueryParam(value="tecnologia") TecnologiaType tecnologia, @QueryParam(value="login") String login) {
        try {
            this.desenvolvimentoService.atualizaBancoDadosInicioDesenvolvimento(branch, cliente, sistema, tecnologia, login);
            return RetornoForm.getSucesso();
        }
        catch (Exception ex) {
            return RetornoForm.getProblema(-1, ex.getMessage());
        }
    }

    @POST
    @Path(value="/desenvolvimento/descarte/atualizabancodados/{desenvolvimentoId}")
    @Produces(value={"text/plain"})
    public String atualizaBancoDadosDescarteDesenvolvimento(@PathParam(value="desenvolvimentoId") Long desenvolvimentoId) {
        try {
            this.desenvolvimentoService.atualizaBancoDadosDescarteDesenvolvimento(desenvolvimentoId);
            return "OK";
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    @POST
    @Path(value="/desenvolvimento/salva/atualizabancodados/{desenvolvimentoId}")
    @Produces(value={"text/plain"})
    public String atualizaBancoDadosSalvaDesenvolvimento(@PathParam(value="desenvolvimentoId") Long desenvolvimentoId) {
        try {
            this.desenvolvimentoService.atualizaBancoDadosSalvaDesenvolvimento(desenvolvimentoId);
            return "OK";
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    @POST
    @Path(value="/desenvolvimento/finaliza/atualizabancodados/{desenvolvimentoId}")
    @Produces(value={"text/plain"})
    public String atualizaBancoDadosFinalizaDesenvolvimento(@PathParam(value="desenvolvimentoId") Long desenvolvimentoId) {
        try {
            this.desenvolvimentoService.atualizaBancoDadosFinalizaDesenvolvimento(desenvolvimentoId);
            return "OK";
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    @GET
    @Path(value="/desenvolvimento/inicio/valida")
    @Produces(value={"application/json"})
    public RetornoForm validaInicioDesenvolvimento(@QueryParam(value="branch") String branch, @QueryParam(value="cliente") String cliente, @QueryParam(value="sistema") String sistema, @QueryParam(value="tecnologia") TecnologiaType tecnologia, @QueryParam(value="login") String login) {
        try {
            sistema = sistema.replace("+", " ");
            this.desenvolvimentoService.validaInicioDesenvolvimento(branch, cliente, sistema, tecnologia, login);
            return RetornoForm.getSucesso();
        }
        catch (Exception ex) {
            return RetornoForm.getProblema(-1, ex.getMessage());
        }
    }

    @GET
    @Path(value="/desenvolvimento/descarte/valida")
    @Produces(value={"application/json"})
    public RetornoForm validaDescarteDesenvolvimento(@QueryParam(value="desenvolvimentoId") Long desenvolvimentoId, @QueryParam(value="login") String login) {
        try {
            this.desenvolvimentoService.validaDescarteDesenvolvimento(desenvolvimentoId, login);
            return RetornoForm.getSucesso();
        }
        catch (Exception ex) {
            return RetornoForm.getProblema(-1, ex.getMessage());
        }
    }

    @POST
    @Path(value="/desenvolvimento/salva/valida/{desenvolvimentoId}/{comentario}")
    @Produces(value={"text/plain"})
    public String validaSalvaDesenvolvimento(@PathParam(value="desenvolvimentoId") Long desenvolvimentoId, @PathParam(value="comentario") String comentario) {
        try {
            this.desenvolvimentoService.validaSalvaDesenvolvimento(desenvolvimentoId, comentario);
            return "OK";
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    @POST
    @Path(value="/desenvolvimento/finaliza/valida")
    @Produces(value={"text/plain"})
    public String validaFinalizaDesenvolvimento(InputStream dadosJsonStream) {
        StringBuilder dadosJsonBuilder = new StringBuilder();
        try {
            BufferedReader in = new BufferedReader(new InputStreamReader(dadosJsonStream));
            String line = null;
            while ((line = in.readLine()) != null) {
                dadosJsonBuilder.append(line);
            }
            DesenvolvimentoForm desenvolvimentoForm = (DesenvolvimentoForm)JsonUtils.toObject(DesenvolvimentoForm.class, (String)dadosJsonBuilder.toString());
            SistemaEntity sistemaEntity = SistemaRepository.getInstance().pesquisar(desenvolvimentoForm.getCliente(), desenvolvimentoForm.getSistema(), desenvolvimentoForm.getTecnologia());
            AplicacaoForm aplicacaoForm = Factory.getAplicacaoForm(sistemaEntity);
            this.desenvolvimentoService.validaFimDesenvolvimento(desenvolvimentoForm, aplicacaoForm);
            return "OK";
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    @POST
    @Path(value="/aplicacao/pesquisa/{cliente}/{sistema}/{tecnologia}")
    @Produces(value={"text/plain"})
    public String pesquisaAplicacao(@PathParam(value="cliente") String cliente, @PathParam(value="sistema") String sistema, @PathParam(value="tecnologia") String tecnologia) {
        try {
            sistema = sistema.replace("+", " ");
            SistemaEntity sistemaEntity = SistemaRepository.getInstance().pesquisar(cliente, sistema, TecnologiaType.valueOf(tecnologia));
            AplicacaoForm aplicacaoForm = Factory.getAplicacaoForm(sistemaEntity);
            String retorno = JsonUtils.toJson((Object)aplicacaoForm);
            return retorno;
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    @POST
    @Path(value="/desenvolvimento/pesquisa/ultimasol/{login}/{branch}")
    @Produces(value={"application/json"})
    public DesenvolvimentoForm pesquisaUltimaSolDesenvolvimento(@PathParam(value="login") String login, @PathParam(value="branch") String branch) {
        try {
            DesenvolvimentoEntity desenvolvimentoEntity = DesenvolvimentoRepository.getInstance().pesquisaBranch(branch);
            DesenvolvimentoForm form = Factory.getDesenvolvimentoForm(desenvolvimentoEntity, login);
            return form;
        }
        catch (Exception ex) {
            return null;
        }
    }

    @POST
    @Path(value="/sistema/lista")
    @Produces(value={"text/plain"})
    public String listaSistema() {
        try {
            List<String> listaSistema = SistemaRepository.getInstance().listaSistema();
            StringBuilder retorno = new StringBuilder();
            for (String sistema : listaSistema) {
                retorno.append(sistema + ";");
            }
            return retorno.toString();
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    @POST
    @Path(value="/sistemas/ativos")
    @Produces(value={"text/plain"})
    public String sistemasAtivos() {
        return SistemaRepository.getInstance().ativos().stream().map(SistemaEntity::getSistema).distinct().sorted().collect(Collectors.joining(";"));
    }

    @POST
    @Path(value="/sistema/cliente/{sigla}")
    @Produces(value={"text/plain"})
    public String listaSistema(@PathParam(value="sigla") String sigla) {
        try {
            List<String> listaSistema = SistemaRepository.getInstance().listaSistema(sigla);
            StringBuilder retorno = new StringBuilder();
            for (String sistema : listaSistema) {
                retorno.append(sistema + ";");
            }
            return retorno.toString();
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    @GET
    @Path(value="/cliente/lista")
    @Produces(value={"text/plain"})
    public String listaCliente() {
        try {
            List<String> listaCliente = SistemaRepository.getInstance().listaCliente();
            StringBuilder retorno = new StringBuilder();
            for (String cliente : listaCliente) {
                retorno.append(cliente + ";");
            }
            return retorno.toString();
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    @POST
    @Path(value="/sol/descricao/{branch}")
    @Produces(value={"text/plain"})
    public String descricaoSol(@PathParam(value="branch") String branch) {
        try {
            if (StringUtils.isNullOrEmpty((String)branch)) {
                throw new LoginException("Task/Branch de preenchimento obrigat\u00f3rio");
            }
            return this.solService.descricaoBranch(branch);
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
    }

    @Path(value="/desenvolvimento/solsNovo")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public List<DesenvolvimentoForm> listaDesenvolvimentoAbertoNovo(AutenticacaoForm autenticacaoForm) throws DesenvolvimentoException {
        if (autenticacaoForm.getLogin() == null || autenticacaoForm.getLogin().isEmpty()) {
            throw new DesenvolvimentoException("Login obrigat\u00f3rio");
        }
        Set<DesenvolvimentoEntity> sols = DesenvolvimentoRepository.getInstance().listaAberto(autenticacaoForm.getLogin());
        ArrayList<DesenvolvimentoForm> listaDesenvolvimento = new ArrayList<DesenvolvimentoForm>();
        for (DesenvolvimentoEntity e : sols) {
            String descricaoSol = this.solService.descricaoBranch(e.getNumeroSol().toString());
            DesenvolvimentoForm desenvolvimentoForm = Factory.getDesenvolvimentoForm(e, autenticacaoForm.getLogin());
            desenvolvimentoForm.setDescricaoSol(descricaoSol.replaceAll("\n", " "));
            desenvolvimentoForm.setLogin(autenticacaoForm.getLogin());
            desenvolvimentoForm.setSenha(autenticacaoForm.getSenha());
            listaDesenvolvimento.add(desenvolvimentoForm);
        }
        return listaDesenvolvimento;
    }

    @Path(value="/desenvolvimento/sols")
    @POST
    @Produces(value={"application/json"})
    @Consumes(value={"application/json"})
    public DesenvolvimentoListaForm listaDesenvolvimentoAberto(AutenticacaoForm autenticacaoForm) throws DesenvolvimentoException {
        if (autenticacaoForm.getLogin() == null || autenticacaoForm.getLogin().isEmpty()) {
            throw new DesenvolvimentoException("Login obrigat\u00f3rio");
        }
        Set<DesenvolvimentoEntity> branchs = DesenvolvimentoRepository.getInstance().listaAberto(autenticacaoForm.getLogin());
        DesenvolvimentoListaForm desenvolvimentoListaForm = new DesenvolvimentoListaForm();
        for (DesenvolvimentoEntity e : branchs) {
            String descricaoSol = this.solService.descricaoBranch(e.getNumeroSol().toString());
            DesenvolvimentoForm desenvolvimentoForm = Factory.getDesenvolvimentoForm(e, autenticacaoForm.getLogin());
            desenvolvimentoForm.setDescricaoSol(descricaoSol.replaceAll("\n", " "));
            desenvolvimentoForm.setLogin(autenticacaoForm.getLogin());
            desenvolvimentoForm.setSenha(autenticacaoForm.getSenha());
            desenvolvimentoListaForm.adiciona(desenvolvimentoForm);
        }
        return desenvolvimentoListaForm;
    }

    @Path(value="empacotamentoAutomatico/{idGpd}/{tipoGpd}/{ambiente}")
    @POST
    @Produces(value={"application/json"})
    public Response empacotamentoAutomatico(@PathParam(value="idGpd") Long idGpd, @PathParam(value="tipoGpd") String tipoGpd, @PathParam(value="ambiente") String ambienteStr) {
        try {
            System.out.println("idGpd:" + idGpd);
            System.out.println("tipoGpd:" + tipoGpd);
            System.out.println("ambiente:" + ambienteStr);
            AmbienteType ambiente = AmbienteType.valueOf(ambienteStr);
            PlanejamentoEntity planejamentoEntity = PlanejamentoRepository.getInstance().pesquisar(idGpd);
            if ((tipoGpd == null || tipoGpd.equals("MERGE_PUBLICACAO")) && !ambiente.equals((Object)AmbienteType.NENHUM)) {
                EmpacotamentoService.getInstance().chamaJenkinsPublicacao(planejamentoEntity.getId(), ambiente);
            } else if (tipoGpd.equals("PUBLICACAO") || ambiente.equals((Object)AmbienteType.NENHUM)) {
                UsuarioEntity usuarioEntity = LogPlanejamentoRepository.getInstance().retornaUsuario(idGpd);
                EmpacotamentoService.getInstance().gravaEmpacotamento(planejamentoEntity, usuarioEntity);
                if (!ambiente.equals((Object)AmbienteType.NENHUM)) {
                    List<EmpacotamentoEntity> listaEmpacotamento = EmpacotamentoRepository.getInstance().pesquisar(planejamentoEntity.getSistemaEntity().getId(), planejamentoEntity.getVersao());
                    EmpacotamentoEntity empacotamentoEntity = listaEmpacotamento.stream().findFirst().orElse(null);
                    boolean encontrado = AceiteRepository.getInstance().listaBloqueado().stream().anyMatch(aceiteEntity -> aceiteEntity.getSistemaEntity().equals(empacotamentoEntity.getSistemaEntity()) && aceiteEntity.getVersao().equals(empacotamentoEntity.getVersao()));
                    if (!encontrado) {
                        AceiteRepository.getInstance().bloquear(empacotamentoEntity, usuarioEntity.getLogin(), ambiente);
                    }
                }
            }
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception ex) {
            LogUtils.generate((Throwable)ex);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ex.getMessage()).build();
        }
    }

    @Path(value="versionamentoAutomatico/{idGpd}/{tipoGpd}/{tag}")
    @POST
    @Produces(value={"application/json"})
    public Response versionamentoAutomatico(@PathParam(value="idGpd") Long idGpd, @PathParam(value="tipoGpd") String tipoGpd, @PathParam(value="tag") String tag) {
        try {
            System.out.println("idGpd:" + idGpd);
            if (tipoGpd != null && tipoGpd.equals(PublicacaoType.INDIVIDUAL.name())) {
                this.versionamentoIndividual(idGpd, tag);
            } else {
                this.versionamentoPacote(idGpd, tag);
            }
            return Response.status((Response.Status)Response.Status.OK).build();
        }
        catch (Exception ex) {
            LogUtils.generate((Throwable)ex);
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ex.getMessage()).build();
        }
    }

    private void versionamentoIndividual(Long idGpd, String tag) {
        UsuarioEntity usuarioEntity = LogVersionamentoRepository.getInstance().retornaUsuarioIndividual(idGpd);
        DesenvolvimentoEntity desenvolvimentoEntity = (DesenvolvimentoEntity)DesenvolvimentoRepository.getInstance().find(idGpd);
        VersionamentoEntity versionamentoEntity = VersionamentoService.getInstance().atualizacaoBancoDadosInicioVersionamento(usuarioEntity.getLogin(), PublicacaoType.INDIVIDUAL, desenvolvimentoEntity.getId(), null);
        versionamentoEntity.setTag(tag);
        VersionamentoService.getInstance().atualizacaoBancoDadosFimVersionamento(PublicacaoType.INDIVIDUAL, versionamentoEntity.getId(), tag, desenvolvimentoEntity.getSistemaEntity().getNomePacote(), null);
    }

    private void versionamentoPacote(Long idGpd, String tag) {
        UsuarioEntity usuarioEntity = LogVersionamentoRepository.getInstance().retornaUsuarioPacote(idGpd);
        AceiteEntity aceiteEntity = (AceiteEntity)AceiteRepository.getInstance().find(idGpd);
        List<EmpacotamentoEntity> listaEmpacotamento = EmpacotamentoRepository.getInstance().pesquisar(aceiteEntity.getSistemaEntity().getId(), aceiteEntity.getVersao());
        for (EmpacotamentoEntity empacotamentoEntity : listaEmpacotamento) {
            VersionamentoEntity versionamentoEntity = VersionamentoService.getInstance().atualizacaoBancoDadosInicioVersionamento(usuarioEntity.getLogin(), PublicacaoType.PACOTE, null, empacotamentoEntity.getId());
            versionamentoEntity.setTag(tag);
            VersionamentoService.getInstance().atualizacaoBancoDadosFimVersionamento(PublicacaoType.PACOTE, versionamentoEntity.getId(), tag, empacotamentoEntity.getSistemaEntity().getNomePacote(), null);
        }
    }

    @Path(value="logEmpacotamentoAutomatico/{idGpd}")
    @PUT
    @Produces(value={"application/json"})
    public Response logEmpacotamentoJenkins(@PathParam(value="idGpd") Long idGpd, String json) {
        Response response;
        block8: {
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(json));
            try {
                JsonObject jsonObject = jsonReader.readObject();
                String mensagem = jsonObject.getString("mensagem");
                LogPlanejamentoRepository.getInstance().incluir(idGpd, new Date(), mensagem);
                response = Response.status((Response.Status)Response.Status.OK).build();
                if (jsonReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    LogUtils.generate((Throwable)ex);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ex.getMessage()).build();
                }
            }
            jsonReader.close();
        }
        return response;
    }

    @Path(value="logVersionamentoAutomatico/{idGpd}/{tipoGpd}")
    @PUT
    @Produces(value={"application/json"})
    public Response logVersionamentoJenkins(@PathParam(value="idGpd") Long idGpd, @PathParam(value="tipoGpd") String tipoGpd, String json) {
        Response response;
        block10: {
            JsonReader jsonReader = Json.createReader((Reader)new StringReader(json));
            try {
                JsonObject jsonObject = jsonReader.readObject();
                String mensagem = jsonObject.getString("mensagem");
                if (tipoGpd.equals(PublicacaoType.INDIVIDUAL.name())) {
                    LogVersionamentoRepository.getInstance().incluiIndividual(idGpd, new Date(), mensagem);
                } else {
                    LogVersionamentoRepository.getInstance().incluiPacote(idGpd, new Date(), mensagem);
                }
                response = Response.status((Response.Status)Response.Status.OK).build();
                if (jsonReader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception ex) {
                    LogUtils.generate((Throwable)ex);
                    return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)ex.getMessage()).build();
                }
            }
            jsonReader.close();
        }
        return response;
    }
}

