/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.log;

import br.com.dsfnet.gpd.client.aceite.AceiteEntity;
import br.com.dsfnet.gpd.client.aceite.AceiteRepository;
import br.com.dsfnet.gpd.client.desenvolvimento.DesenvolvimentoEntity;
import br.com.dsfnet.gpd.client.desenvolvimento.DesenvolvimentoRepository;
import br.com.dsfnet.gpd.client.log.LogVersionamentoEntity;
import br.com.dsfnet.gpd.client.log.LogVersionamentoRepository;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.dsfnet.gpd.client.usuario.UsuarioRepository;
import br.com.jarch.core.annotation.JArchDao;
import br.com.jarch.core.crud.dao.CrudDao;
import jakarta.persistence.TypedQuery;
import jakarta.transaction.Transactional;
import java.util.Collection;
import java.util.Date;
import java.util.List;

@JArchDao
public class LogVersionamentoDao
extends CrudDao<LogVersionamentoEntity>
implements LogVersionamentoRepository {
    @Override
    public UsuarioEntity retornaUsuarioIndividual(Long idDesenvolvimento) {
        Collection lista = this.searchAllBy("desenvolvimentoEntity", idDesenvolvimento);
        LogVersionamentoEntity logVersionamentoEntity = lista.stream().findAny().orElse(null);
        return logVersionamentoEntity.getUsuarioEntity();
    }

    @Override
    public UsuarioEntity retornaUsuarioPacote(Long idAceite) {
        Collection lista = this.searchAllBy("aceiteEntity", idAceite);
        LogVersionamentoEntity logVersionamentoEntity = lista.stream().findAny().orElse(null);
        return logVersionamentoEntity.getUsuarioEntity();
    }

    @Override
    public void iniciaProcessoAutomaticoIndividual(Long idDesenvolvimento, String login) {
        this.removeLogIndividual(idDesenvolvimento);
        this.inclui(idDesenvolvimento, null, login, new Date(), "Solicitou o versionamento autom\u00e1tico individual");
    }

    @Override
    public void iniciaProcessoAutomaticoPacote(Long idAceite, String login) {
        this.removeLogPacote(idAceite);
        this.inclui(null, idAceite, login, new Date(), "Solicitou o versionamento autom\u00e1tico pacote");
    }

    @Override
    public void incluiIndividual(Long idDesenvolvimento, Date data, String mensagem) {
        UsuarioEntity usuarioEntity = this.retornaUsuarioIndividual(idDesenvolvimento);
        this.inclui(idDesenvolvimento, null, usuarioEntity.getLogin(), data, mensagem);
    }

    @Override
    public void incluiPacote(Long idAceite, Date data, String mensagem) {
        UsuarioEntity usuarioEntity = this.retornaUsuarioPacote(idAceite);
        this.inclui(null, idAceite, usuarioEntity.getLogin(), data, mensagem);
    }

    @Override
    @Transactional
    public void inclui(Long idDesenvolvimento, Long idAceite, String login, Date data, String mensagem) {
        DesenvolvimentoEntity desenvolvimentoEntity = null;
        AceiteEntity aceiteEntity = null;
        if (idDesenvolvimento != null) {
            desenvolvimentoEntity = (DesenvolvimentoEntity)DesenvolvimentoRepository.getInstance().find(idDesenvolvimento);
        } else {
            aceiteEntity = (AceiteEntity)AceiteRepository.getInstance().find(idAceite);
        }
        UsuarioEntity usuarioEntity = (UsuarioEntity)UsuarioRepository.getInstance().searchOneBy("login", login);
        LogVersionamentoEntity logVersionamentoEntity = new LogVersionamentoEntity();
        logVersionamentoEntity.setData(data);
        logVersionamentoEntity.setMensagem(mensagem);
        logVersionamentoEntity.setAceiteEntity(aceiteEntity);
        logVersionamentoEntity.setDesenvolvimentoEntity(desenvolvimentoEntity);
        logVersionamentoEntity.setUsuarioEntity(usuarioEntity);
        this.getEntityManager().persist((Object)logVersionamentoEntity);
    }

    @Override
    @Transactional
    public void removeLogIndividual(Long idDesenvolvimento) {
        List<LogVersionamentoEntity> lista = this.pesquisaIdDesenvolvimento(idDesenvolvimento);
        for (LogVersionamentoEntity logVersionamentoEntity : lista) {
            this.getEntityManager().remove((Object)logVersionamentoEntity);
        }
    }

    @Override
    @Transactional
    public void removeLogPacote(Long idAceite) {
        List<LogVersionamentoEntity> lista = this.pesquisaIdAceite(idAceite);
        for (LogVersionamentoEntity logVersionamentoEntity : lista) {
            this.getEntityManager().remove((Object)logVersionamentoEntity);
        }
    }

    @Override
    public List<LogVersionamentoEntity> pesquisaIdDesenvolvimento(Long id) {
        TypedQuery query = this.getEntityManager().createQuery("SELECT l FROM LogVersionamentoEntity l WHERE l.desenvolvimentoEntity.id = :id", LogVersionamentoEntity.class);
        query.setParameter("id", (Object)id);
        return query.getResultList();
    }

    @Override
    public List<LogVersionamentoEntity> pesquisaIdAceite(Long id) {
        TypedQuery query = this.getEntityManager().createQuery("SELECT l FROM LogVersionamentoEntity l WHERE l.aceiteEntity.id = :id", LogVersionamentoEntity.class);
        query.setParameter("id", (Object)id);
        return query.getResultList();
    }
}

