/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.desenvolvimento;

import br.com.dsfnet.gpd.client.desenvolvimento.DesenvolvimentoEntity;
import br.com.dsfnet.gpd.client.desenvolvimento.DesenvolvimentoRepository;
import br.com.dsfnet.gpd.client.form.AutorizacaoForm;
import br.com.dsfnet.gpd.client.homologacao.HomologacaoRepository;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.sistema.SistemaRepository;
import br.com.dsfnet.gpd.client.type.AmbienteType;
import br.com.dsfnet.gpd.client.type.StatusType;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.dsfnet.gpd.client.usuario.UsuarioRepository;
import br.com.dsfnet.gpd.client.util.DataHoraUtils;
import br.com.jarch.core.annotation.JArchDao;
import br.com.jarch.core.crud.dao.CrudDao;
import br.com.jarch.util.CollectionUtils;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.transaction.Transactional;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@JArchDao
public class DesenvolvimentoDao
extends CrudDao<DesenvolvimentoEntity>
implements DesenvolvimentoRepository {
    @Override
    public boolean existeBloqueado(String projetoSvn, String sistema, String branch) {
        Query query = this.getEntityManager().createQuery("SELECT ad FROM DesenvolvimentoEntity ad WHERE ad.sistemaEntity.sistema = :sistema AND \t   ad.sistemaEntity.projetoSvn = :projetoSvn AND \t   ad.numeroSol = :branch AND       ad.status = :bloqueado AND       ad.fim IS NULL");
        query.setParameter("sistema", (Object)sistema);
        query.setParameter("projetoSvn", (Object)projetoSvn);
        query.setParameter("branch", (Object)branch);
        query.setParameter("bloqueado", (Object)StatusType.BLOQUEADO);
        return !query.getResultList().isEmpty();
    }

    @Override
    public boolean existeFinalizado(String projetoSvn, String sistema, String branch) {
        Query query = this.getEntityManager().createQuery("SELECT ad FROM DesenvolvimentoEntity ad WHERE ad.sistemaEntity.sistema = :sistema AND \t   ad.sistemaEntity.projetoSvn = :projetoSvn AND \t   ad.numeroSol = :branch AND       ad.status = :liberado AND       ad.fim IS NOT NULL");
        query.setParameter("sistema", (Object)sistema);
        query.setParameter("projetoSvn", (Object)projetoSvn);
        query.setParameter("branch", (Object)branch);
        query.setParameter("liberado", (Object)StatusType.LIBERADO);
        return !query.getResultList().isEmpty();
    }

    @Override
    public List<DesenvolvimentoEntity> aplicacaoEmUso(String sistema, String projetoSvn, String login) {
        Query query = this.getEntityManager().createQuery("SELECT ad FROM DesenvolvimentoEntity ad WHERE ad.sistemaEntity.sistema = :sistema AND \t   ad.sistemaEntity.projetoSvn = :projetoSvn AND \t   ad.usuarioEntity.login = :login AND       ad.fim IS NULL");
        query.setParameter("sistema", (Object)sistema);
        query.setParameter("projetoSvn", (Object)projetoSvn);
        query.setParameter("login", (Object)login);
        return CollectionUtils.transform(DesenvolvimentoEntity.class, (Collection)query.getResultList());
    }

    @Override
    public boolean solAberto(String numeroSol, String login) {
        Query query = this.getEntityManager().createQuery("SELECT ad FROM DesenvolvimentoEntity ad WHERE ad.numeroSol = :numeroSol AND \t   ad.usuarioEntity.login = :login AND       ad.fim IS NULL");
        query.setParameter("numeroSol", (Object)numeroSol);
        query.setParameter("login", (Object)login);
        try {
            List listaRetorno = CollectionUtils.transform(DesenvolvimentoEntity.class, (Collection)query.getResultList());
            return !listaRetorno.isEmpty();
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    @Transactional
    public void iniciar(Long aplicacaoId, String branch, String usuario) {
        SistemaEntity sistemaEntity = (SistemaEntity)SistemaRepository.getInstance().find(aplicacaoId);
        UsuarioEntity usuarioEntity = UsuarioRepository.getInstance().pesquisaLogin(usuario);
        DesenvolvimentoEntity desenvolvimentoEntity = new DesenvolvimentoEntity();
        desenvolvimentoEntity.setNumeroSol(branch);
        desenvolvimentoEntity.setSistemaEntity(sistemaEntity);
        desenvolvimentoEntity.setInicio(new Date());
        desenvolvimentoEntity.setStatus(StatusType.BLOQUEADO);
        desenvolvimentoEntity.setUsuarioEntity(usuarioEntity);
        this.getEntityManager().persist((Object)desenvolvimentoEntity);
    }

    @Override
    @Transactional
    public void finalizar(Long id) {
        DesenvolvimentoEntity desenvolvimentoEntity = (DesenvolvimentoEntity)this.find(id);
        desenvolvimentoEntity.setFim(new Date());
        desenvolvimentoEntity.setStatus(StatusType.LIBERADO);
        this.getEntityManager().merge((Object)desenvolvimentoEntity);
        long homologacaoId = HomologacaoRepository.getInstance().bloquear(desenvolvimentoEntity.getSistemaEntity().getCliente(), desenvolvimentoEntity.getSistemaEntity().getSistema(), desenvolvimentoEntity.getSistemaEntity().getTecnologia(), desenvolvimentoEntity.getNumeroSol(), desenvolvimentoEntity.getUsuarioEntity().getLogin());
        HomologacaoRepository.getInstance().liberar(homologacaoId);
    }

    @Override
    @Transactional
    public void descartar(Long id) {
        DesenvolvimentoEntity desenvolvimentoEntity = (DesenvolvimentoEntity)this.find(id);
        desenvolvimentoEntity.setFim(new Date());
        desenvolvimentoEntity.setStatus(StatusType.DESCARTADO);
        this.getEntityManager().merge((Object)desenvolvimentoEntity);
    }

    @Override
    public DesenvolvimentoEntity pesquisaBranch(String branch) {
        Query query = this.getEntityManager().createQuery("SELECT ad FROM DesenvolvimentoEntity ad WHERE ad.numeroSol = :numeroSol AND       NOT EXISTS( SELECT 0 \t\t\t\t   FROM DesenvolvimentoEntity x                   WHERE x.numeroSol = ad.numeroSol AND                         x.id > ad.id)");
        query.setParameter("numeroSol", (Object)branch);
        return (DesenvolvimentoEntity)query.getSingleResult();
    }

    @Override
    public List<String> listaSolAberto(String login) {
        Query query = this.getEntityManager().createQuery("SELECT ad FROM DesenvolvimentoEntity ad WHERE ad.usuarioEntity.login = :login AND       ad.numeroSol IS NOT NULL AND       ad.fim IS NULL");
        query.setParameter("login", (Object)login);
        List lista = CollectionUtils.transform(DesenvolvimentoEntity.class, (Collection)query.getResultList());
        ArrayList<String> listaRetorno = new ArrayList<String>();
        for (DesenvolvimentoEntity desenvolvimentoEntity : lista) {
            listaRetorno.add(desenvolvimentoEntity.getNumeroSol());
        }
        return listaRetorno;
    }

    @Override
    public List<DesenvolvimentoEntity> listaUltimasSol(String login) {
        Query query = this.getEntityManager().createQuery("SELECT d FROM DesenvolvimentoEntity d JOIN FETCH d.sistemaEntity apl JOIN FETCH d.usuarioEntity usu WHERE d.usuarioEntity.login = :login AND       d.numeroSol IS NOT NULL AND       NOT EXISTS( SELECT 0                   FROM DesenvolvimentoEntity x                   WHERE x.usuarioEntity.id = d.usuarioEntity.id AND                         x.numeroSol = d.numeroSol AND                         x.sistemaEntity.id = d.sistemaEntity.id AND                         x.id > d.id) ORDER BY d.inicio DESC");
        query.setParameter("login", (Object)login);
        List lista = CollectionUtils.transform(DesenvolvimentoEntity.class, (Collection)query.getResultList());
        return lista;
    }

    @Override
    public List<DesenvolvimentoEntity> listaUltimasSol() {
        Query query = this.getEntityManager().createQuery("SELECT d FROM DesenvolvimentoEntity d JOIN FETCH d.sistemaEntity apl JOIN FETCH d.usuarioEntity usu WHERE d.numeroSol IS NOT NULL AND       NOT EXISTS( SELECT 0                   FROM DesenvolvimentoEntity x                   WHERE x.numeroSol = d.numeroSol AND                         x.sistemaEntity.id = d.sistemaEntity.id AND                         x.id > d.id) ORDER BY d.inicio DESC");
        List lista = CollectionUtils.transform(DesenvolvimentoEntity.class, (Collection)query.getResultList());
        return lista;
    }

    @Override
    public List<DesenvolvimentoEntity> listaNaoEmpacotadoNaoVersionado() {
        TypedQuery query = this.getEntityManager().createQuery("SELECT d FROM DesenvolvimentoEntity d WHERE d.numeroSol IS NOT NULL AND       d.fim IS NOT NULL AND       d.status = :liberado AND       NOT EXISTS( SELECT 0                   FROM DesenvolvimentoEntity x                   WHERE x.sistemaEntity.id = d.sistemaEntity.id AND                         x.status = :liberado AND                         x.numeroSol = d.numeroSol AND                         x.id > d.id) AND       EXISTS( SELECT 0               FROM HomologacaoEntity x               WHERE x.sistemaEntity.id = d.sistemaEntity.id AND                     x.numeroSol = d.numeroSol AND                     x.fim IS NOT NULL AND                     x.fim >= d.fim) AND       NOT EXISTS( SELECT 0                   FROM EmpacotamentoEntity x                   WHERE x.sistemaEntity.id = d.sistemaEntity.id AND                         x.numeroSol = d.numeroSol) AND       NOT EXISTS( SELECT 0                   FROM VersionamentoEntity x                   WHERE x.sistemaEntity.id = d.sistemaEntity.id AND                         x.numeroSol = d.numeroSol AND                         x.status != :descartado AND                         x.inicio >= d.fim) AND       NOT EXISTS( SELECT 0                   FROM AutorizacaoEntity x                   WHERE x.sistemaEntity.id = d.sistemaEntity.id AND                         x.numeroSol = d.numeroSol AND                         (x.autorizacao < :inicioDia OR x.autorizacao > :fimDia)) ORDER BY d.numeroSol DESC", DesenvolvimentoEntity.class);
        query.setParameter("descartado", (Object)StatusType.DESCARTADO);
        query.setParameter("liberado", (Object)StatusType.LIBERADO);
        query.setParameter("inicioDia", (Object)DataHoraUtils.inicioDia(new Date()));
        query.setParameter("fimDia", (Object)DataHoraUtils.fimDia(new Date()));
        return query.getResultList();
    }

    @Override
    public Set<String> pesquisaFinalizadoNaoPlanejado(Long aplicacaoId) {
        Query query = this.getEntityManager().createQuery("SELECT d.numeroSol FROM DesenvolvimentoEntity d  WHERE d.numeroSol IS NOT NULL AND       d.status = :status AND       d.sistemaEntity.id = :idAplicacao AND       NOT EXISTS( SELECT 0                   FROM PlanejamentoSolEntity x                   WHERE x.numeroSol = d.numeroSol AND                         x.planejamentoEntity.sistemaEntity.id = d.sistemaEntity.id) AND       NOT EXISTS( SELECT 0                   FROM VersionamentoEntity x                   WHERE x.numeroSol = d.numeroSol AND                         x.sistemaEntity.id = d.sistemaEntity.id AND                          x.status = :status) ORDER BY d.numeroSol");
        query.setParameter("idAplicacao", (Object)aplicacaoId);
        query.setParameter("status", (Object)StatusType.LIBERADO);
        try {
            return new TreeSet<String>(CollectionUtils.transform(String.class, (Collection)query.getResultList()));
        }
        catch (Exception ex) {
            throw new RuntimeException("N\u00e3o existe Branch para planejamento neste Cliente/Produto/Tecnologia");
        }
    }

    @Override
    public Set<DesenvolvimentoEntity> listaAberto(String login) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(DesenvolvimentoEntity.class);
        Root root = criteria.from(DesenvolvimentoEntity.class);
        criteria.select((Selection)root);
        Predicate whereLogin = builder.equal((Expression)root.join("usuarioEntity").get("login"), (Object)login);
        Predicate whereFim = builder.isNull((Expression)root.get("fim"));
        criteria.where(new Predicate[]{whereLogin, whereFim});
        List lista = this.getEntityManager().createQuery(criteria).getResultList();
        TreeSet<DesenvolvimentoEntity> listaRetorno = new TreeSet<DesenvolvimentoEntity>();
        listaRetorno.addAll(lista);
        return listaRetorno;
    }

    @Override
    public Set<DesenvolvimentoEntity> listaQualidade() {
        Query query = this.getEntityManager().createQuery("SELECT d FROM DesenvolvimentoEntity d WHERE d.numeroSol IS NOT NULL AND       d.status = :status AND       NOT EXISTS( SELECT 0                   FROM DesenvolvimentoEntity x                   WHERE x.sistemaEntity.id = d.sistemaEntity.id AND                         x.numeroSol = d.numeroSol AND                         x.status = d.status AND                         x.id > d.id) AND       NOT EXISTS( SELECT 0                   FROM QualidadeEntity x                   WHERE x.sistemaEntity.id = d.sistemaEntity.id AND                         x.numeroSol = d.numeroSol AND                         (x.fim > d.fim OR x.fim IS NULL)) AND       NOT EXISTS( SELECT 0                   FROM HomologacaoEntity x                   WHERE x.sistemaEntity.id = d.sistemaEntity.id AND                         x.fim IS NOT NULL AND                         x.numeroSol = d.numeroSol AND                         (x.fim > d.fim OR x.fim IS NULL))");
        query.setParameter("status", (Object)StatusType.LIBERADO);
        List lista = CollectionUtils.transform(DesenvolvimentoEntity.class, (Collection)query.getResultList());
        TreeSet<DesenvolvimentoEntity> listaRetorno = new TreeSet<DesenvolvimentoEntity>();
        listaRetorno.addAll(lista);
        return listaRetorno;
    }

    @Override
    public Set<DesenvolvimentoEntity> listaHomologacao() {
        Query query = this.getEntityManager().createQuery("SELECT d FROM DesenvolvimentoEntity d WHERE d.numeroSol IS NOT NULL AND       d.status = :status AND       NOT EXISTS( SELECT 0                   FROM DesenvolvimentoEntity x                   WHERE x.sistemaEntity.id = d.sistemaEntity.id AND                         x.numeroSol = d.numeroSol AND                         x.status = d.status AND                         x.id > d.id) AND       NOT EXISTS( SELECT 0                   FROM HomologacaoEntity x                   WHERE x.sistemaEntity.id = d.sistemaEntity.id AND                         x.numeroSol = d.numeroSol AND                         (x.fim > d.fim OR x.fim IS NULL))");
        query.setParameter("status", (Object)StatusType.LIBERADO);
        List lista = CollectionUtils.transform(DesenvolvimentoEntity.class, (Collection)query.getResultList());
        TreeSet<DesenvolvimentoEntity> listaRetorno = new TreeSet<DesenvolvimentoEntity>();
        listaRetorno.addAll(lista);
        return listaRetorno;
    }

    @Override
    public Set<DesenvolvimentoEntity> listaAceiteIndividual(AmbienteType ambiente) {
        Query query = this.getEntityManager().createQuery("SELECT d FROM DesenvolvimentoEntity d JOIN FETCH d.usuarioEntity JOIN FETCH d.sistemaEntity WHERE d.numeroSol IS NOT NULL AND       d.status = :liberado AND       NOT EXISTS( SELECT 0                   FROM DesenvolvimentoEntity x                   WHERE x.sistemaEntity.id = d.sistemaEntity.id AND                         x.numeroSol = d.numeroSol AND                         x.status = d.status AND                         x.id > d.id) AND       NOT EXISTS( SELECT 0                   FROM PlanejamentoSolEntity x                   WHERE x.planejamentoEntity.sistemaEntity.id = d.sistemaEntity.id AND                         x.numeroSol = d.numeroSol) AND       NOT EXISTS( SELECT 0                   FROM VersionamentoEntity x                   WHERE x.sistemaEntity.id = d.sistemaEntity.id AND                         x.numeroSol = d.numeroSol AND                         x.status = :liberado) AND       NOT EXISTS( SELECT 0                   FROM AceiteEntity x                   WHERE x.sistemaEntity.id = d.sistemaEntity.id AND                         x.numeroSol = d.numeroSol AND                         x.status != :descartado AND \t\t\t\t\t\t x.ambiente = :ambiente AND                         (x.fim > d.fim OR x.fim IS NULL))");
        query.setParameter("liberado", (Object)StatusType.LIBERADO);
        query.setParameter("descartado", (Object)StatusType.DESCARTADO);
        query.setParameter("ambiente", (Object)ambiente);
        List lista = CollectionUtils.transform(DesenvolvimentoEntity.class, (Collection)query.getResultList());
        TreeSet<DesenvolvimentoEntity> listaRetorno = new TreeSet<DesenvolvimentoEntity>();
        listaRetorno.addAll(lista);
        return listaRetorno;
    }

    @Override
    public List<DesenvolvimentoEntity> pesquisaSolAplicacao(String numeroSol, Long aplicacaoId) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(DesenvolvimentoEntity.class);
        Root root = criteria.from(DesenvolvimentoEntity.class);
        criteria.select((Selection)root);
        Predicate whereNumeroSol = builder.equal((Expression)root.get("numeroSol"), (Object)numeroSol);
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Order orderById = builder.asc((Expression)root.get("id"));
        criteria.where(new Predicate[]{whereNumeroSol, whereAplicacao});
        criteria.orderBy(new Order[]{orderById});
        return this.getEntityManager().createQuery(criteria).getResultList();
    }

    @Override
    public List<AutorizacaoForm> listaDesenvolvimento() {
        Query query = this.getEntityManager().createQuery("SELECT NEW " + AutorizacaoForm.class.getName() + "(d.id, apl.cliente, apl.sistema, apl.tecnologia, d.numeroSol) FROM DesenvolvimentoEntity d   JOIN d.sistemaEntity apl WHERE d.fim is not null   AND NOT EXISTS (SELECT 0 FROM VersionamentoEntity x     WHERE apl = x.sistemaEntity       AND d.numeroSol = x.numeroSol)  AND NOT EXISTS (SELECT 0 FROM PlanejamentoEntity x     JOIN x.listaSol x2     WHERE apl = x.sistemaEntity       AND d.numeroSol = x2.numeroSol)ORDER BY d.sistemaEntity.cliente, d.sistemaEntity.sistema, d.numeroSol");
        return CollectionUtils.transform(AutorizacaoForm.class, (Collection)query.getResultList());
    }
}

