/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.autorizacao;

import br.com.dsfnet.gpd.client.autorizacao.AutorizacaoEntity;
import br.com.dsfnet.gpd.client.autorizacao.AutorizacaoRepository;
import br.com.dsfnet.gpd.client.form.AutorizacaoForm;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.sistema.SistemaRepository;
import br.com.dsfnet.gpd.client.type.StatusType;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.dsfnet.gpd.client.usuario.UsuarioRepository;
import br.com.jarch.core.annotation.JArchDao;
import br.com.jarch.core.crud.dao.CrudDao;
import br.com.jarch.core.model.type.ActionCrudType;
import br.com.jarch.util.CollectionUtils;
import jakarta.persistence.Query;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.transaction.Transactional;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@JArchDao
public class AutorizacaoDao
extends CrudDao<AutorizacaoEntity>
implements AutorizacaoRepository {
    @Override
    public Set<AutorizacaoForm> listaIndividual() {
        Query query = this.getEntityManager().createQuery("SELECT NEW " + AutorizacaoForm.class.getName() + "(d.id, apl.cliente, apl.sistema, apl.tecnologia, d.numeroSol) FROM DesenvolvimentoEntity d   JOIN d.sistemaEntity apl WHERE d.numeroSol IS NOT NULL AND       d.status = :status AND       NOT EXISTS( SELECT 0                   FROM VersionamentoEntity x                   WHERE x.sistemaEntity.id = apl.id AND                         x.numeroSol = d.numeroSol AND                         x.status = :status) AND       NOT EXISTS( SELECT 0               \t   FROM DesenvolvimentoEntity x               \t   WHERE x.sistemaEntity.id = apl.id AND                         x.numeroSol = d.numeroSol AND                         x.status = :status AND                         (x.fim > d.fim))");
        query.setParameter("status", (Object)StatusType.LIBERADO);
        List lista = CollectionUtils.transform(AutorizacaoForm.class, (Collection)query.getResultList());
        TreeSet<AutorizacaoForm> listaRetorno = new TreeSet<AutorizacaoForm>();
        listaRetorno.addAll(lista);
        return listaRetorno;
    }

    @Override
    public Set<AutorizacaoForm> listaPacote() {
        Query query = this.getEntityManager().createQuery("SELECT NEW " + AutorizacaoForm.class.getName() + "(e.id, apl.cliente, apl.sistema, apl.tecnologia, e.versao) FROM EmpacotamentoEntity e   JOIN e.sistemaEntity apl WHERE NOT EXISTS( SELECT 0                   FROM VersionamentoEntity x                   WHERE x.sistemaEntity.id = apl.id AND                         x.versao = e.versao AND                         x.status = :status) AND       NOT EXISTS( SELECT 0               \t   FROM EmpacotamentoEntity x               \t   WHERE x.sistemaEntity.id = apl.id AND                         x.versao = e.versao AND                         (x.fim > e.fim))");
        query.setParameter("status", (Object)StatusType.LIBERADO);
        List lista = CollectionUtils.transform(AutorizacaoForm.class, (Collection)query.getResultList());
        TreeSet<AutorizacaoForm> listaRetorno = new TreeSet<AutorizacaoForm>();
        listaRetorno.addAll(lista);
        return listaRetorno;
    }

    @Override
    public Set<AutorizacaoForm> listaPacoteLiberado() {
        Query query = this.getEntityManager().createQuery("SELECT NEW " + AutorizacaoForm.class.getName() + "(e.id, apl.cliente, apl.sistema, apl.tecnologia, e.versao) FROM EmpacotamentoEntity e   JOIN e.sistemaEntity apl WHERE NOT EXISTS( SELECT 0                   FROM VersionamentoEntity x                   WHERE x.sistemaEntity.id = apl.id AND                         x.versao = e.versao AND                         x.status = :status)       AND NOT EXISTS( SELECT 0               \t   FROM EmpacotamentoEntity x               \t   WHERE x.sistemaEntity.id = apl.id AND                         x.versao = e.versao AND                         (x.fim > e.fim))      AND EXISTS( SELECT 0               \t   FROM AceiteEntity x               \t   WHERE x.sistemaEntity.id = apl.id AND                         x.versao = e.versao AND                         x.status = :status)");
        query.setParameter("status", (Object)StatusType.LIBERADO);
        List lista = CollectionUtils.transform(AutorizacaoForm.class, (Collection)query.getResultList());
        TreeSet<AutorizacaoForm> listaRetorno = new TreeSet<AutorizacaoForm>();
        listaRetorno.addAll(lista);
        return listaRetorno;
    }

    @Override
    @Transactional
    public void autorizacao(AutorizacaoForm form, Date dataAutorizacao, String login) {
        ActionCrudType actionCrudType;
        AutorizacaoEntity autorizacao;
        try {
            autorizacao = this.pesquisa(form);
            actionCrudType = ActionCrudType.CHANGE;
        }
        catch (Exception ex) {
            actionCrudType = ActionCrudType.INSERT;
            autorizacao = new AutorizacaoEntity();
            SistemaEntity aplicacao = SistemaRepository.getInstance().pesquisar(form.getCliente(), form.getSistema(), form.getTecnologia());
            autorizacao = new AutorizacaoEntity();
            autorizacao.setSistemaEntity(aplicacao);
            autorizacao.setData(new Date());
        }
        autorizacao.setAutorizacao(dataAutorizacao);
        if (form.getVersao() == null || form.getVersao().equals("")) {
            autorizacao.setNumeroSol(form.getNumeroSol());
        } else {
            autorizacao.setVersao(form.getVersao());
        }
        UsuarioEntity usuario = UsuarioRepository.getInstance().pesquisaLogin(login);
        autorizacao.setUsuarioEntity(usuario);
        if (actionCrudType == ActionCrudType.INSERT) {
            this.getEntityManager().persist((Object)autorizacao);
        } else {
            this.getEntityManager().merge((Object)autorizacao);
        }
    }

    @Override
    public AutorizacaoEntity pesquisa(AutorizacaoForm autorizacao) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(AutorizacaoEntity.class);
        Root root = criteria.from(AutorizacaoEntity.class);
        criteria.select((Selection)root);
        Predicate whereCliente = builder.equal((Expression)root.join("sistemaEntity").get("cliente"), (Object)autorizacao.getCliente());
        Predicate whereSistema = builder.equal((Expression)root.join("sistemaEntity").get("sistema"), (Object)autorizacao.getSistema());
        Predicate whereTecnologia = builder.equal((Expression)root.join("sistemaEntity").get("tecnologia"), (Object)autorizacao.getTecnologia());
        Predicate whereSolVersao = autorizacao.getVersao() == null || autorizacao.getVersao().equals("") ? builder.equal((Expression)root.get("numeroSol"), (Object)autorizacao.getNumeroSol()) : builder.equal((Expression)root.get("versao"), (Object)autorizacao.getVersao());
        criteria.where(new Predicate[]{whereCliente, whereSistema, whereTecnologia, whereSolVersao});
        return (AutorizacaoEntity)this.getEntityManager().createQuery(criteria).getSingleResult();
    }

    @Override
    public List<AutorizacaoEntity> pesquisaSolAplicacao(String numeroSol, Long aplicacaoId) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(AutorizacaoEntity.class);
        Root root = criteria.from(AutorizacaoEntity.class);
        criteria.select((Selection)root);
        Predicate whereNumeroSol = builder.equal((Expression)root.get("numeroSol"), (Object)numeroSol);
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Order orderById = builder.asc((Expression)root.get("id"));
        criteria.where(new Predicate[]{whereNumeroSol, whereAplicacao});
        criteria.orderBy(new Order[]{orderById});
        return this.getEntityManager().createQuery(criteria).getResultList();
    }

    @Override
    public List<AutorizacaoEntity> pesquisaVersaoAplicacao(String versao, Long aplicacaoId) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(AutorizacaoEntity.class);
        Root root = criteria.from(AutorizacaoEntity.class);
        criteria.select((Selection)root);
        Predicate whereVersao = builder.equal((Expression)root.get("versao"), (Object)versao);
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Order orderById = builder.asc((Expression)root.get("id"));
        criteria.where(new Predicate[]{whereVersao, whereAplicacao});
        criteria.orderBy(new Order[]{orderById});
        return this.getEntityManager().createQuery(criteria).getResultList();
    }

    @Override
    public List<AutorizacaoEntity> pesquisaVersaoAplicacao(List<String> listaVersao, Long aplicacaoId) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(AutorizacaoEntity.class);
        Root root = criteria.from(AutorizacaoEntity.class);
        criteria.select((Selection)root);
        Predicate[] wheresOr = new Predicate[listaVersao.size()];
        int i = 0;
        for (String tag : listaVersao) {
            wheresOr[i++] = builder.equal((Expression)root.get("versao"), (Object)tag);
        }
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Order orderById = builder.asc((Expression)root.get("id"));
        criteria.where(new Predicate[]{whereAplicacao, builder.or(wheresOr)});
        criteria.orderBy(new Order[]{orderById});
        return this.getEntityManager().createQuery(criteria).getResultList();
    }

    @Override
    public List<AutorizacaoEntity> listaAutorizacao() {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(AutorizacaoEntity.class);
        Root root = criteria.from(AutorizacaoEntity.class);
        root.fetch("sistemaEntity");
        root.fetch("usuarioEntity");
        criteria.select((Selection)root);
        Order orderById = builder.desc((Expression)root.get("id"));
        criteria.orderBy(new Order[]{orderById});
        return this.getEntityManager().createQuery(criteria).getResultList();
    }
}

