/*
 * Decompiled with CFR 0.152.
 */
package br.com.dsfnet.gpd.client.aceite;

import br.com.dsfnet.gpd.client.aceite.AceiteEntity;
import br.com.dsfnet.gpd.client.aceite.AceiteRepository;
import br.com.dsfnet.gpd.client.desenvolvimento.DesenvolvimentoEntity;
import br.com.dsfnet.gpd.client.empacotamento.EmpacotamentoEntity;
import br.com.dsfnet.gpd.client.form.AutorizacaoForm;
import br.com.dsfnet.gpd.client.sistema.SistemaEntity;
import br.com.dsfnet.gpd.client.sistema.SistemaRepository;
import br.com.dsfnet.gpd.client.type.AmbienteType;
import br.com.dsfnet.gpd.client.type.StatusType;
import br.com.dsfnet.gpd.client.type.TecnologiaType;
import br.com.dsfnet.gpd.client.usuario.UsuarioEntity;
import br.com.dsfnet.gpd.client.usuario.UsuarioRepository;
import br.com.jarch.core.annotation.JArchDao;
import br.com.jarch.core.crud.dao.CrudDao;
import br.com.jarch.util.CollectionUtils;
import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import jakarta.transaction.Transactional;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

@JArchDao
public class AceiteDao
extends CrudDao<AceiteEntity>
implements AceiteRepository {
    @Override
    @Transactional
    public void bloquear(DesenvolvimentoEntity desenvolvimento, String login, AmbienteType ambiente) {
        SistemaEntity aplicacao = (SistemaEntity)SistemaRepository.getInstance().find(desenvolvimento.getSistemaEntity().getId());
        UsuarioEntity usuario = UsuarioRepository.getInstance().pesquisaLogin(login);
        AceiteEntity aceite = new AceiteEntity();
        aceite.setSistemaEntity(aplicacao);
        aceite.setUsuarioEntity(usuario);
        aceite.setNumeroSol(desenvolvimento.getNumeroSol());
        aceite.setInicio(new Date());
        aceite.setStatus(StatusType.BLOQUEADO);
        aceite.setAmbiente(ambiente);
        this.getEntityManager().persist((Object)aceite);
    }

    @Override
    @Transactional
    public void bloquear(EmpacotamentoEntity empacotamento, String login, AmbienteType ambiente) {
        SistemaEntity aplicacao = (SistemaEntity)SistemaRepository.getInstance().find(empacotamento.getSistemaEntity().getId());
        UsuarioEntity usuario = UsuarioRepository.getInstance().pesquisaLogin(login);
        AceiteEntity aceite = new AceiteEntity();
        aceite.setSistemaEntity(aplicacao);
        aceite.setUsuarioEntity(usuario);
        aceite.setVersao(empacotamento.getVersao());
        aceite.setInicio(new Date());
        aceite.setStatus(StatusType.BLOQUEADO);
        aceite.setAmbiente(ambiente);
        this.getEntityManager().persist((Object)aceite);
    }

    @Override
    @Transactional
    public void descartar(Long id) {
        AceiteEntity aceite = (AceiteEntity)this.find(id);
        aceite.setStatus(StatusType.DESCARTADO);
        aceite.setFim(new Date());
    }

    @Override
    @Transactional
    public void liberar(Long id) {
        AceiteEntity aceite = (AceiteEntity)this.find(id);
        aceite.setStatus(StatusType.LIBERADO);
        aceite.setFim(new Date());
    }

    @Override
    @Transactional
    public void descartar(String cliente, String produto, TecnologiaType tecnologia, String versao, AmbienteType ambiente) {
        TypedQuery query = this.getEntityManager().createQuery("SELECT a FROM AceiteEntity a WHERE a.sistemaEntity.cliente = :cliente AND \t   a.sistemaEntity.sistema = :sistema AND \t   a.sistemaEntity.tecnologia = :tecnologia AND \t   a.versao = :versao AND       a.status <> :status AND       a.ambiente = :ambiente", AceiteEntity.class);
        query.setParameter("cliente", (Object)cliente);
        query.setParameter("sistema", (Object)produto);
        query.setParameter("tecnologia", (Object)tecnologia);
        query.setParameter("versao", (Object)versao);
        query.setParameter("status", (Object)StatusType.DESCARTADO);
        query.setParameter("ambiente", (Object)ambiente);
        try {
            List aceites = query.getResultList();
            for (AceiteEntity aceite : aceites) {
                aceite.setFim(new Date());
                aceite.setStatus(StatusType.DESCARTADO);
            }
        }
        catch (NoResultException noResultException) {
            // empty catch block
        }
    }

    @Override
    public AceiteEntity pesquisaPacoteLiberadoParaVersionar(String cliente, String sistema, TecnologiaType tecnologia, String versao) {
        Query query = this.getEntityManager().createQuery("SELECT aq FROM AceiteEntity aq WHERE aq.sistemaEntity.cliente = :cliente AND \t   aq.sistemaEntity.sistema = :sistema AND \t   aq.sistemaEntity.tecnologia = :tecnologia AND \t   aq.versao = :versao AND       aq.status = :status ");
        query.setParameter("cliente", (Object)cliente);
        query.setParameter("sistema", (Object)sistema);
        query.setParameter("tecnologia", (Object)tecnologia);
        query.setParameter("versao", (Object)versao);
        query.setParameter("status", (Object)StatusType.LIBERADO);
        return (AceiteEntity)query.getResultList().get(0);
    }

    @Override
    public List<AceiteEntity> listaVersaoSolServidor() {
        Query query = this.getEntityManager().createQuery("SELECT a FROM AceiteEntity a JOIN FETCH a.sistemaEntity apl JOIN FETCH a.usuarioEntity usu WHERE a.fim IS NULL OR       (a.fim IS NOT NULL AND NOT EXISTS( SELECT 0            \t        \t\t\t\t  FROM AceiteEntity x                 \t\t  \t\t\t\t  WHERE x.fim IS NULL AND                                                x.sistemaEntity.id = a.sistemaEntity.id AND \t \t\t\t\t\t\t\t\t\t\t\tx.sistemaEntity.servidorAceite = a.sistemaEntity.servidorAceite) AND \t\t\t\t\t\t\t\t  NOT EXISTS( SELECT 0            \t        \t\t\t\t  FROM AceiteEntity x                 \t\t  \t\t\t\t  WHERE x.sistemaEntity.id = a.sistemaEntity.id AND \t\t\t\t\t\t\t\t\t\t\t\tx.id > a.id)) ORDER BY a.inicio DESC");
        return CollectionUtils.transform(AceiteEntity.class, (Collection)query.getResultList());
    }

    @Override
    public List<AutorizacaoForm> listaAceiteLiberado() {
        Query query = this.getEntityManager().createQuery("SELECT NEW " + AutorizacaoForm.class.getName() + "(a.id, apl.cliente, apl.sistema, apl.tecnologia, a.versao) FROM AceiteEntity a   JOIN a.sistemaEntity apl WHERE a.status = :status ORDER BY a.sistemaEntity.cliente, a.sistemaEntity.sistema, a.versao");
        query.setParameter("status", (Object)StatusType.LIBERADO);
        return CollectionUtils.transform(AutorizacaoForm.class, (Collection)query.getResultList());
    }

    @Override
    public List<AceiteEntity> listaBloqueado(String sistema, String projetoSvn, String servidorAceite, AmbienteType ambiente) {
        Query query = this.getEntityManager().createQuery("SELECT ad FROM AceiteEntity ad WHERE ad.sistemaEntity.sistema = :sistema AND \t   ad.sistemaEntity.projetoSvn = :projetoSvn AND       ad.sistemaEntity.servidorAceite = :servidorAceite AND       ad.ambiente = :ambiente AND       ad.fim IS NULL");
        query.setParameter("sistema", (Object)sistema);
        query.setParameter("projetoSvn", (Object)projetoSvn);
        query.setParameter("servidorAceite", (Object)servidorAceite);
        query.setParameter("ambiente", (Object)ambiente);
        return CollectionUtils.transform(AceiteEntity.class, (Collection)query.getResultList());
    }

    @Override
    public Set<AceiteEntity> listaBloqueado() {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(AceiteEntity.class);
        Root root = criteria.from(AceiteEntity.class);
        criteria.select((Selection)root);
        Predicate whereFim = builder.isNull((Expression)root.get("fim"));
        criteria.where((Expression)whereFim);
        List lista = this.getEntityManager().createQuery(criteria).getResultList();
        TreeSet<AceiteEntity> listaRetorno = new TreeSet<AceiteEntity>();
        listaRetorno.addAll(lista);
        return listaRetorno;
    }

    @Override
    public Set<AceiteEntity> listaBloqueado(String login, AmbienteType ambiente) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(AceiteEntity.class);
        Root root = criteria.from(AceiteEntity.class);
        criteria.select((Selection)root);
        Predicate whereFim = builder.isNull((Expression)root.get("fim"));
        Predicate whereLogin = builder.equal((Expression)root.join("usuarioEntity").get("login"), (Object)login);
        Predicate whereAmbiente = builder.equal((Expression)root.get("ambiente"), (Object)ambiente);
        criteria.where(new Predicate[]{whereFim, whereLogin, whereAmbiente});
        List lista = this.getEntityManager().createQuery(criteria).getResultList();
        TreeSet<AceiteEntity> listaRetorno = new TreeSet<AceiteEntity>();
        listaRetorno.addAll(lista);
        return listaRetorno;
    }

    @Override
    public boolean bloqueadoIndividual(Long aplicacaoId, String branch) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(AceiteEntity.class);
        Root root = criteria.from(AceiteEntity.class);
        criteria.select((Selection)root);
        Predicate whereStatus = builder.equal((Expression)root.get("status"), (Object)StatusType.BLOQUEADO);
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Predicate whereSol = builder.equal((Expression)root.get("numeroSol"), (Object)branch);
        criteria.where(new Predicate[]{whereAplicacao, whereSol, whereStatus});
        List lista = this.getEntityManager().createQuery(criteria).getResultList();
        return !lista.isEmpty();
    }

    @Override
    public boolean bloqueadoPacote(Long aplicacaoId, String branch) {
        Query query = this.getEntityManager().createQuery("SELECT a FROM AceiteEntity a WHERE a.sistemaEntity.id = :aplicacaoId AND \t   a.status = :bloqueado AND       a.versao IS NOT NULL AND       EXISTS( SELECT x               FROM PlanejamentoEntity x               WHERE x.sistemaEntity.id = a.sistemaEntity.id AND                     x.versao = a.versao AND                     EXISTS( SELECT y                             FROM PlanejamentoSolEntity y                             WHERE y.planejamentoEntity.id = x.id AND                                   y.numeroSol = :numeroSol))");
        query.setParameter("aplicacaoId", (Object)aplicacaoId);
        query.setParameter("bloqueado", (Object)StatusType.BLOQUEADO);
        query.setParameter("numeroSol", (Object)branch);
        return !query.getResultList().isEmpty();
    }

    @Override
    public List<AceiteEntity> pesquisaSolAplicacao(String numeroSol, Long aplicacaoId) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(AceiteEntity.class);
        Root root = criteria.from(AceiteEntity.class);
        criteria.select((Selection)root);
        Predicate whereNumeroSol = builder.equal((Expression)root.get("numeroSol"), (Object)numeroSol);
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Order orderById = builder.asc((Expression)root.get("id"));
        criteria.where(new Predicate[]{whereNumeroSol, whereAplicacao});
        criteria.orderBy(new Order[]{orderById});
        return this.getEntityManager().createQuery(criteria).getResultList();
    }

    @Override
    public List<AceiteEntity> pesquisaVersaoAplicacao(List<String> listaVersao, Long aplicacaoId) {
        CriteriaBuilder builder = this.getEntityManager().getEntityManagerFactory().getCriteriaBuilder();
        CriteriaQuery criteria = builder.createQuery(AceiteEntity.class);
        Root root = criteria.from(AceiteEntity.class);
        criteria.select((Selection)root);
        Predicate[] wheresOr = new Predicate[listaVersao.size()];
        int i = 0;
        for (String tag : listaVersao) {
            wheresOr[i++] = builder.equal((Expression)root.get("versao"), (Object)tag);
        }
        Predicate whereAplicacao = builder.equal((Expression)root.join("sistemaEntity").get("id"), (Object)aplicacaoId);
        Order orderById = builder.asc((Expression)root.get("id"));
        criteria.where(new Predicate[]{whereAplicacao, builder.or(wheresOr)});
        criteria.orderBy(new Order[]{orderById});
        return this.getEntityManager().createQuery(criteria).getResultList();
    }
}

