/*
 * Decompiled with CFR 0.152.
 */
package org.atmosphere.container;

import javax.servlet.ServletContext;
import javax.websocket.DeploymentException;
import javax.websocket.HandshakeResponse;
import javax.websocket.server.HandshakeRequest;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;
import org.atmosphere.container.JSR356Endpoint;
import org.atmosphere.container.Servlet30CometSupport;
import org.atmosphere.cpr.AtmosphereConfig;
import org.atmosphere.cpr.AtmosphereFramework;
import org.atmosphere.cpr.WebSocketProcessorFactory;
import org.atmosphere.util.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSR356AsyncSupport
extends Servlet30CometSupport {
    private static final Logger logger = LoggerFactory.getLogger(JSR356AsyncSupport.class);
    private static final String PATH = "/{path";
    private final AtmosphereConfigurator configurator;

    public JSR356AsyncSupport(AtmosphereConfig config) {
        this(config, config.getServletContext());
    }

    public JSR356AsyncSupport(AtmosphereConfig config, ServletContext ctx) {
        super(config);
        ServerContainer container = (ServerContainer)ctx.getAttribute(ServerContainer.class.getName());
        if (container == null) {
            if (ctx.getServerInfo().contains("WebLogic")) {
                logger.error("{} must use JDK 1.8+ with WebSocket", (Object)ctx.getServerInfo());
            }
            throw new IllegalStateException("Unable to configure jsr356 at that stage. ServerContainer is null");
        }
        int pathLength = 5;
        String s = config.getInitParameter("org.atmosphere.cpr.jsr356.pathMappingLength");
        if (s != null) {
            pathLength = Integer.valueOf(s);
        }
        logger.trace("JSR356 Path mapping Size {}", (Object)pathLength);
        String servletPath = config.getInitParameter("org.atmosphere.container.JSR356AsyncSupport.mappingPath");
        if (servletPath == null && ((servletPath = IOUtils.guestServletPath(config)).equals("") || servletPath.equals("/") || servletPath.equals("/*"))) {
            servletPath = "/{path}";
        }
        logger.info("JSR 356 Mapping path {}", (Object)servletPath);
        this.configurator = new AtmosphereConfigurator(config.framework());
        StringBuilder b = new StringBuilder(servletPath);
        for (int i = 0; i < pathLength; ++i) {
            try {
                container.addEndpoint(ServerEndpointConfig.Builder.create(JSR356Endpoint.class, (String)b.toString()).configurator((ServerEndpointConfig.Configurator)this.configurator).build());
            }
            catch (DeploymentException e) {
                logger.warn("Duplicate Servlet Mapping Path {}. Use {} init-param to prevent this message", (Object)servletPath, (Object)"org.atmosphere.container.JSR356AsyncSupport.mappingPath");
                logger.trace("", (Throwable)e);
                servletPath = IOUtils.guestServletPath(config);
                logger.warn("Duplicate guess {}", (Object)servletPath, (Object)e);
                b.setLength(0);
                b.append(servletPath);
            }
            b.append(PATH).append(i).append("}");
        }
    }

    @Override
    public boolean supportWebSocket() {
        return true;
    }

    @Override
    public String getContainerName() {
        return super.getContainerName() + " and jsr356/WebSocket API";
    }

    public static final class AtmosphereConfigurator
    extends ServerEndpointConfig.Configurator {
        private final AtmosphereFramework framework;
        final ThreadLocal<JSR356Endpoint> endPoint = new ThreadLocal();
        final ThreadLocal<HandshakeRequest> hRequest = new ThreadLocal();

        public AtmosphereConfigurator(AtmosphereFramework framework) {
            this.framework = framework;
        }

        public <T> T getEndpointInstance(Class<T> endpointClass) throws InstantiationException {
            if (JSR356Endpoint.class.isAssignableFrom(endpointClass)) {
                JSR356Endpoint e = new JSR356Endpoint(this.framework, WebSocketProcessorFactory.getDefault().getWebSocketProcessor(this.framework));
                if (this.hRequest.get() != null) {
                    e.handshakeRequest(this.hRequest.get());
                    this.hRequest.set(null);
                } else {
                    this.endPoint.set(e);
                }
                return (T)((Object)e);
            }
            return (T)super.getEndpointInstance(endpointClass);
        }

        public void modifyHandshake(ServerEndpointConfig sec, HandshakeRequest request, HandshakeResponse response) {
            if (this.endPoint.get() == null) {
                this.hRequest.set(request);
            } else {
                this.endPoint.get().handshakeRequest(request);
                this.endPoint.set(null);
            }
        }
    }
}

